/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.filter;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class DeleteFilterAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        String name = request.getReqPar("name");
        if (name == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 9;
        }
        try {
            cl.deleteFilter(name);
        }
        catch (CalFacadeException cfe) {
            if (cfe.getMessage().equals("org.bedework.exception.unknown.filter")) {
                form.getErr().emit("org.bedework.client.error.unknown.filter", (Object)name);
                return 5;
            }
            form.getErr().emit((Throwable)cfe);
            return 9;
        }
        catch (Throwable t) {
            form.getErr().emit(t);
            return 9;
        }
        form.assignReloadRequired(true);
        return 0;
    }
}

