/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.location;

import javax.servlet.http.HttpServletResponse;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwString;
import org.bedework.util.misc.Uid;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class AddSubLocationAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        HttpServletResponse resp = request.getResponse();
        if (cl.getPublicAdmin() && !form.getAuthorisedUser()) {
            resp.setStatus(403);
            return 47;
        }
        String uid = request.getReqPar("uid");
        BwLocation location = null;
        if (uid != null) {
            location = cl.getLocation(uid);
        }
        if (this.debug) {
            if (location == null) {
                this.logIt("No location with id " + uid);
            } else {
                this.logIt("Retrieved location " + location.getUid());
            }
        }
        form.assignAddingLocation(false);
        form.setLocation(location);
        if (location == null) {
            resp.setStatus(404);
            return 47;
        }
        String subaddr = request.getReqPar("sub");
        BwLocation newloc = new BwLocation();
        newloc.setUid(Uid.getUid());
        newloc.setCreatorHref(location.getCreatorHref());
        newloc.setOwnerHref(location.getOwnerHref());
        newloc.setPublick(location.getPublick());
        if (location.getAddress() != null) {
            newloc.setAddress((BwString)location.getAddress().clone());
        } else {
            newloc.setAddress(new BwString(null, ""));
        }
        BwString addr = newloc.getAddress();
        if (addr.getValue().contains("\t")) {
            int pos = addr.getValue().lastIndexOf("\t");
            addr.setValue(addr.getValue().substring(0, pos));
        }
        addr.setValue(addr.getValue() + "\t" + subaddr);
        if (location.getSubaddress() != null) {
            newloc.setSubaddress((BwString)location.getSubaddress().clone());
        }
        newloc.setLink(location.getLink());
        try {
            cl.addLocation(newloc);
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            resp.setStatus(500);
            return 47;
        }
        resp.addHeader("etag", cl.getCurrentChangeToken());
        resp.setContentType("text/json; charset=UTF-8");
        form.setLocation(newloc);
        cl.writeJson(request.getResponse(), (Object)newloc);
        resp.getOutputStream().close();
        resp.setStatus(200);
        return 47;
    }
}

