/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.location;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwLocation;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class DeleteLocationAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest() || cl.getPublicAdmin() && !form.getAuthorisedUser()) {
            return 4;
        }
        String uid = form.getLocationUid();
        if (uid == null) {
            return 5;
        }
        form.setPropRefs(null);
        BwLocation loc = cl.getLocation(uid);
        Client.DeleteReffedEntityResult delResult = cl.deleteLocation(loc);
        if (delResult == null) {
            form.getErr().emit("org.bedework.client.error.unknown.location", (Object)uid);
            return 5;
        }
        if (!delResult.getDeleted()) {
            form.setPropRefs(delResult.getReferences());
            form.getErr().emit("org.bedework.client.error.referenced.location");
            return 30;
        }
        form.getMsg().emit("org.bedework.client.message.deleted.locations", 1);
        return 0;
    }
}

