/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.location;

import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.http.HttpServletResponse;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.responses.LocationsResponse;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;

public class FetchLocationsAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Collection<BwLocation> vals;
        String kind;
        Client cl = request.getClient();
        HttpServletResponse resp = request.getResponse();
        form.setNocache(false);
        String changeToken = cl.getCurrentChangeToken();
        String ifNoneMatch = request.getRequest().getHeader("if-none-match");
        if (changeToken != null && changeToken.equals(ifNoneMatch)) {
            resp.setStatus(304);
            return 47;
        }
        resp.addHeader("etag", changeToken);
        BwSession sess = request.getSess();
        switch (kind = request.getReqPar("kind", "owners")) {
            case "owners": {
                String attrName = "bw_locations_list";
                vals = sess.getLocations(request, 1, true);
                break;
            }
            case "editable": {
                String attrName = "bw_editable_locations_list";
                vals = sess.getLocations(request, 2, false);
                break;
            }
            default: {
                resp.setStatus(400);
                return 47;
            }
        }
        resp.setContentType("text/json; charset=UTF-8");
        LocationsResponse locs = new LocationsResponse();
        locs.setLocations(vals);
        BasicSystemProperties props = cl.getBasicSystemProperties();
        BwPrincipal pr = cl.getCurrentPrincipal();
        for (BwLocation loc : vals) {
            loc.fixNames(props, pr);
        }
        if (cl.getPublicAdmin()) {
            Collection<BwLocation> prefs = sess.getLocations(request, 3, false);
            ArrayList<String> preferred = new ArrayList<String>();
            for (BwLocation prefLoc : prefs) {
                prefLoc.fixNames(props, pr);
                preferred.add(prefLoc.getHref());
            }
            locs.setPreferred(preferred);
        }
        this.okReturn(locs);
        cl.writeJson(resp, (Object)locs);
        resp.getOutputStream().close();
        return 47;
    }
}

