/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.location;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwLocation;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwWebUtil;

public class UpdateLocationAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        String deleted;
        Client cl = request.getClient();
        if (cl.isGuest() || cl.getPublicAdmin() && !form.getAuthorisedUser()) {
            return 4;
        }
        if (request.getReqPar("delete") != null) {
            return 18;
        }
        BwLocation location = form.getLocation();
        boolean add = form.getAddingLocation();
        if (location == null) {
            form.setLocation(null);
            form.getErr().emit("org.bedework.client.error.unknown.location");
            return 5;
        }
        boolean added = false;
        String keyName = request.getReqPar("keyName");
        if (keyName != null) {
            String keyValue = request.getReqPar("keyValue");
            if (keyValue == null) {
                location.delKey(keyName);
            } else {
                location.updKey(keyName, keyValue);
            }
        }
        BwWebUtil.ValidateResult ver = BwWebUtil.validateLocation(form);
        if (!ver.ok) {
            return 2;
        }
        if (cl.isSuperUser() && "true".equals(deleted = request.getReqPar("deleted"))) {
            location.setStatus("deleted");
        }
        if (add) {
            added = cl.addLocation(location);
        } else {
            cl.updateLocation(location);
        }
        form.assignAddingLocation(false);
        if (add) {
            if (added) {
                form.getMsg().emit("org.bedework.client.message.added.locations", 1);
            } else {
                form.getErr().emit("org.bedework.client.error.duplicatelocation");
            }
        } else {
            form.getMsg().emit("org.bedework.client.message.updated.location");
        }
        return 0;
    }
}

