/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.misc;

import java.io.Writer;
import java.util.Collection;
import java.util.TreeSet;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class ExportAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        String calPath = request.getReqPar("calPath");
        Client cl = request.getClient();
        EventInfo ev = null;
        Collection<Object> evs = null;
        int method = 1;
        if (request.getReqPar("guid") != null || request.getReqPar("href") != null || request.getReqPar("eventName") != null || request.getReqPar("contentName") != null) {
            if (this.debug) {
                this.debugMsg("Export event by guid or name");
            }
            if ((ev = this.findEvent(request, RecurringRetrievalMode.Rmode.overrides)) == null) {
                return 9;
            }
            method = ev.getEvent().getScheduleMethod();
            if (!Icalendar.validItipMethodType((int)method)) {
                method = 1;
            }
        } else {
            BwDateTime end;
            BwDateTime start;
            if (calPath == null) {
                this.warn("No collection path supplied");
                return 5;
            }
            BwCalendar col = cl.getCollection(calPath);
            if (col == null) {
                return 5;
            }
            String dl = request.getReqPar("dateLimits");
            BwTimeRange tr = null;
            AuthProperties authp = cl.getAuthProperties();
            if (dl != null) {
                if (dl.equals("active")) {
                    tr = new BwTimeRange(BwDateTimeUtil.getDateTime((String)DateTimeUtil.isoDate(), (boolean)true, (boolean)false, null), null);
                } else if (dl.equals("limited")) {
                    tr = form.getEventDates().getTimeRange();
                }
            }
            if (tr != null) {
                start = tr.getStart();
                end = tr.getEnd();
            } else {
                start = BwDateTime.makeBwDateTime((Date)new DateTime());
                int days = request.getIntReqPar("days", -32767);
                int max = authp.getMaxWebCalPeriod();
                if (days < 0) {
                    days = max;
                } else if (days > max && !cl.isSuperUser()) {
                    days = max;
                }
                BwDuration dur = new BwDuration();
                dur.setDays(days);
                end = start.addDuration(dur);
            }
            evs = cl.getEvents("(colPath='" + col.getPath() + "')", start, end, request.present("expand"));
            if (evs == null) {
                return 5;
            }
        }
        if (ev != null) {
            evs = new TreeSet<EventInfo>();
            evs.add(ev);
        }
        IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(cl));
        Calendar ical = trans.toIcal(evs, method);
        request.getResponse().setHeader("Content-Disposition", "Attachment; Filename=\"" + form.getContentName() + "\"");
        request.getResponse().setContentType("text/calendar; charset=UTF-8");
        IcalTranslator.writeCalendar((Calendar)ical, (Writer)request.getResponse().getWriter());
        request.getResponse().getWriter().close();
        return 47;
    }
}

