/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.misc;

import java.io.Writer;
import java.util.ArrayList;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.component.VFreeBusy;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.BwTimeRange;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.VFreeUtil;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;

public class FreeBusyPublishAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        BwTimeRange tr;
        BwPrincipal principal = null;
        Client cl = request.getClient();
        BwModuleState mstate = request.getModule().getState();
        this.gotoDateView(request, mstate.getDate(), mstate.getViewType());
        String userId = request.getReqPar("user");
        String cua = null;
        if (userId == null) {
            cua = request.getReqPar("cua");
        }
        if (cua != null) {
            principal = cl.calAddrToPrincipal(cua);
        } else if (userId != null) {
            principal = cl.getUser(userId);
        } else if (!form.getGuest()) {
            principal = cl.getCurrentPrincipal();
        }
        if (principal == null) {
            request.getResponse().sendError(404);
            return 47;
        }
        BwCalendar cal = null;
        String calPath = request.getReqPar("calPath");
        if (calPath != null && (cal = cl.getCollection(calPath)) == null) {
            request.getResponse().sendError(404, calPath);
            return 47;
        }
        AuthProperties authp = request.getSess().getAuthpars();
        int max = 0;
        if (!cl.isSuperUser()) {
            max = authp.getMaxFBPeriod();
        }
        if ((tr = BwDateTimeUtil.getPeriod((String)request.getReqPar("start"), (String)request.getReqPar("end"), (int)5, (int)authp.getDefaultFBPeriod(), (int)5, (int)max)) == null) {
            request.getResponse().sendError(400, "dates");
            return 47;
        }
        try {
            if (this.debug) {
                this.debugMsg("getFreeBusy for start =  " + tr.getStart() + " end = " + tr.getEnd());
            }
            ArrayList<BwCalendar> cals = null;
            if (cal != null) {
                cals = new ArrayList<BwCalendar>();
                cals.add(cal);
            }
            String orgUri = cl.getCurrentCalendarAddress();
            BwOrganizer org = new BwOrganizer();
            org.setOrganizerUri(orgUri);
            BwEvent fb = cl.getFreeBusy(cals, principal, tr.getStart(), tr.getEnd(), org, null, null);
            VFreeBusy vfreeBusy = VFreeUtil.toVFreeBusy((BwEvent)fb);
            Calendar ical = null;
            if (vfreeBusy != null) {
                ical = IcalTranslator.newIcal((int)1);
                ical.getComponents().add((Object)vfreeBusy);
            }
            form.setContentName("freebusy.ics");
            request.getResponse().setHeader("Content-Disposition", "Attachment; Filename=\"freebusy.ics\"");
            request.getResponse().setContentType("text/calendar; charset=UTF-8");
            IcalTranslator.writeCalendar((Calendar)ical, (Writer)request.getResponse().getWriter());
        }
        catch (CalFacadeAccessException cfae) {
            request.getResponse().sendError(403);
        }
        return 47;
    }
}

