/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.misc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.apache.struts.upload.FormFile;
import org.bedework.appcommon.CheckData;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.webcommon.AddEventResult;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class UploadAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        if (form.getGuest()) {
            return 4;
        }
        String transparency = request.getReqPar("transparency");
        if (!CheckData.checkTransparency((String)transparency)) {
            form.getErr().emit("org.bedework.validation.error.invalid.transparency", (Object)transparency);
            return 2;
        }
        String status = request.getReqPar("status");
        if (!CheckData.checkStatus((String)status)) {
            form.getErr().emit("org.bedework.validation.error.invalid.status", (Object)status);
            return 2;
        }
        boolean stripAlarms = request.getBooleanReqPar("stripAlarms", false);
        Client cl = request.getClient();
        HashMap<String, String> paths = new HashMap<String, String>();
        String newCalPath = request.getReqPar("newCalPath");
        FormFile upFile = form.getUploadFile();
        if (upFile == null) {
            return 0;
        }
        String fileName = upFile.getFileName();
        if (fileName == null || fileName.length() == 0) {
            form.getErr().emit("org.bedework.client.error.missingfilename", 1);
            return 2;
        }
        int numEventsAdded = 0;
        int numEventsUpdated = 0;
        int numFailedOverrides = 0;
        BwCalendar col = null;
        try {
            InputStream is = upFile.getInputStream();
            IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(cl));
            Icalendar ic = trans.fromIcal(null, (Reader)new InputStreamReader(is));
            int method = ic.getMethodType();
            if (!cl.getPublicAdmin() && method != 1 && (Icalendar.itipReplyMethodType((int)method) || Icalendar.itipRequestMethodType((int)method))) {
                return this.importScheduleMessage(request, ic, null, stripAlarms);
            }
            ArrayList<AddEventResult> aers = new ArrayList<AddEventResult>();
            form.setAddEventResults(aers);
            for (Object o : ic) {
                Set alarms;
                if (!(o instanceof EventInfo)) continue;
                EventInfo ei = (EventInfo)o;
                BwEvent ev = ei.getEvent();
                ev.setName(ev.getUid() + ".ics");
                if (transparency != null) {
                    ev.setTransparency(transparency);
                }
                if (status != null) {
                    ev.setStatus(status);
                }
                if (stripAlarms && (alarms = ev.getAlarms()) != null) {
                    alarms.clear();
                }
                if (newCalPath != null) {
                    if (col == null && (col = cl.getCollection(newCalPath)) == null) {
                        form.getErr().emit("org.bedework.validation.error.missingcalendar");
                    }
                    ev.setColPath(col.getPath());
                } else {
                    String icalName = IcalDefs.entityTypeIcalNames[ev.getEntityType()];
                    String path = (String)paths.get(icalName);
                    if (path == null && (path = cl.getPreferredCollectionPath(icalName)) == null) {
                        form.getErr().emit("org.bedework.validation.error.missingcalendar");
                    }
                    paths.put(icalName, path);
                    ev.setColPath(path);
                }
                col = cl.getCollection(newCalPath);
                if (col == null) {
                    form.getErr().emit("org.bedework.validation.error.missingcalendar");
                }
                ev.setScheduleMethod(0);
                if (ei.getNewEvent()) {
                    try {
                        EventInfo.UpdateResult eur = cl.addEvent(ei, true, false);
                        AddEventResult aer = new AddEventResult(ev, eur.failedOverrides);
                        aers.add(aer);
                        if (eur.failedOverrides != null) {
                            numFailedOverrides += eur.failedOverrides.size();
                        }
                        ++numEventsAdded;
                    }
                    catch (CalFacadeException cfe) {
                        if (!cfe.getMessage().equals("org.bedework.exception.norecurrenceinstances")) {
                            throw cfe;
                        }
                        form.getErr().emit(cfe.getMessage(), (Object)cfe.getExtra());
                    }
                    continue;
                }
                cl.updateEvent(ei, false, null);
                ++numEventsUpdated;
            }
        }
        catch (CalFacadeException cfe) {
            if (this.debug) {
                cfe.printStackTrace();
            }
            form.getErr().emit(cfe.getMessage(), (Object)cfe.getExtra());
            return 29;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw t;
        }
        if (numFailedOverrides > 0) {
            form.getErr().emit("org.bedework.client.error.failed.overrides", numFailedOverrides);
        }
        form.getMsg().emit("org.bedework.client.message.added.events", numEventsAdded);
        form.getMsg().emit("org.bedework.client.message.updated.events", numEventsUpdated);
        return 0;
    }

    private int importScheduleMessage(BwRequest request, Icalendar ic, BwCalendar cal, boolean stripAlarms) throws Throwable {
        Client cl = request.getClient();
        if (ic.size() != 1) {
            request.getErr().emit("org.bedework.validation.error.invalid.scheddata");
            return 2;
        }
        Iterator it = ic.iterator();
        Object o = it.next();
        if (o instanceof EventInfo) {
            Set alarms;
            EventInfo ei = (EventInfo)o;
            BwEvent ev = (BwEvent)ei.getEvent().clone();
            BwOrganizer org = ev.getOrganizer();
            if (org == null) {
                request.getErr().emit("org.bedework.validation.error.missingorganizer");
                return 2;
            }
            String userUri = cl.getCurrentCalendarAddress();
            boolean isOrganizer = userUri.equals(org.getOrganizerUri());
            ev.setOrganizerSchedulingObject(Boolean.valueOf(isOrganizer));
            ev.setAttendeeSchedulingObject(Boolean.valueOf(!isOrganizer));
            ev.setScheduleMethod(ic.getMethodType());
            ev.setName(ev.getUid() + ".ics");
            ev.setColPath(cal.getPath());
            ei = new EventInfo(ev);
            if (stripAlarms && (alarms = ev.getAlarms()) != null) {
                alarms.clear();
            }
            cl.addEvent(ei, false, true);
            request.getMsg().emit("org.bedework.client.message.added.events", 1);
        }
        return 0;
    }
}

