/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.misc;

import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import net.fortuna.ical4j.model.Calendar;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.locale.BwLocale;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;

public class WebCalendarAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        String st;
        Client cl = request.getClient();
        BwModuleState mstate = request.getModule().getState();
        this.gotoDateView(request, mstate.getDate(), mstate.getViewType());
        Locale loc = BwLocale.getLocale();
        java.util.Calendar start = java.util.Calendar.getInstance(loc);
        java.util.Calendar end = java.util.Calendar.getInstance(loc);
        String name = request.getReqPar("name");
        if (name == null) {
            name = start.toString();
        }
        if ((st = request.getReqPar("start")) == null) {
            start.add(3, -1);
        } else {
            int days = request.getIntReqPar("start", -32767);
            if (days != -32767) {
                start.add(5, days);
            } else {
                Date jdt = DateTimeUtil.fromISODate((String)st);
                start.setTime(jdt);
            }
        }
        String et = request.getReqPar("end");
        if (et == null) {
            end.add(2, 1);
        } else {
            int days = request.getIntReqPar("end", -32767);
            if (days != -32767) {
                end.add(5, days);
            } else {
                Date jdt = DateTimeUtil.fromISODate((String)et);
                end.setTime(jdt);
            }
        }
        java.util.Calendar check = java.util.Calendar.getInstance(loc);
        check.setTime(start.getTime());
        check.add(5, 93);
        if (check.before(end)) {
            request.getResponse().sendError(400, "dates");
            return 47;
        }
        String fexpr = request.getReqPar("fexpr");
        if (fexpr == null) {
            request.getResponse().sendError(400, "no fexpr specified");
            return 47;
        }
        try {
            BwDateTime sdt = BwDateTimeUtil.getDateTime((String)DateTimeUtil.isoDate((Date)start.getTime()), (boolean)true, (boolean)false, null);
            BwDateTime edt = BwDateTimeUtil.getDateTime((String)DateTimeUtil.isoDate((Date)end.getTime()), (boolean)true, (boolean)false, null);
            if (this.debug) {
                this.debugMsg("getEvents for start = " + sdt + " end = " + edt);
            }
            Collection evs = cl.getEvents(fexpr, sdt, edt, request.present("expanded"));
            IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(cl));
            Calendar c = trans.toIcal(evs, 1);
            if (!name.endsWith(".ics")) {
                name = name + ".ics";
            }
            form.setContentName(name);
            request.getResponse().setHeader("Content-Disposition", "Attachment; Filename=\"" + name + "\"");
            request.getResponse().setContentType("text/calendar; charset=UTF-8");
            IcalTranslator.writeCalendar((Calendar)c, (Writer)request.getResponse().getWriter());
        }
        catch (CalFacadeAccessException cfae) {
            request.getResponse().sendError(403);
        }
        return 47;
    }
}

