/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.monitor;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import javax.xml.namespace.QName;
import org.bedework.calfacade.MonitorStat;
import org.bedework.calfacade.svc.BwSysMonitorMBean;
import org.bedework.util.jmx.MBeanUtil;
import org.bedework.util.xml.XmlEmit;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class MonitorAction
extends BwAbstractAction {
    private static BwSysMonitorMBean monitor;
    public static QName monitorTag;
    public static QName statTag;
    public static QName nameTag;
    public static QName valueTag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        List stats = this.getMonitor().getStats();
        request.getResponse().setContentType("text/xml; charset=UTF-8");
        try (PrintWriter wtr = request.getResponse().getWriter();){
            XmlEmit xml = new XmlEmit();
            xml.startEmit((Writer)wtr);
            xml.openTag(monitorTag);
            for (MonitorStat stat : stats) {
                xml.openTag(statTag);
                xml.property(nameTag, stat.getName());
                xml.property(valueTag, stat.getValue());
                xml.closeTag(statTag);
            }
            xml.closeTag(monitorTag);
        }
        return 47;
    }

    private synchronized BwSysMonitorMBean getMonitor() throws Throwable {
        if (monitor == null) {
            monitor = (BwSysMonitorMBean)MBeanUtil.getMBean(BwSysMonitorMBean.class, (String)"org.bedework:service=BwSysMonitor");
        }
        return monitor;
    }

    static {
        monitorTag = new QName("monitor");
        statTag = new QName("stat");
        nameTag = new QName("name");
        valueTag = new QName("value");
    }
}

