/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.notifications;

import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.util.misc.Util;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class SubscribeAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        HttpServletResponse response = request.getResponse();
        if (cl.isGuest()) {
            response.setStatus(403);
            return 47;
        }
        boolean add = request.present("add");
        boolean remove = request.present("remove");
        if (add && remove) {
            form.getErr().emit("org.bedework.client.error.badrequest");
            response.setStatus(400);
            return 47;
        }
        String href = cl.getCurrentPrincipalHref();
        List emails = request.getReqPars("email");
        try {
            if (remove) {
                cl.unsubscribe(href, emails);
            } else {
                if (Util.isEmpty((Collection)emails)) {
                    form.getErr().emit("org.bedework.client.error.badrequest");
                    response.setStatus(400);
                    return 47;
                }
                cl.subscribe(href, emails);
            }
        }
        catch (CalFacadeException cfe) {
            cl.rollback();
            if (this.debug) {
                this.error(cfe);
            }
            response.setStatus(400);
            return 47;
        }
        response.setStatus(200);
        return 47;
    }
}

