/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.pref;

import java.util.List;
import java.util.TreeSet;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.util.timezones.Timezones;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class UpdatePrefsAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        int ival;
        Boolean bool;
        int endMinutes;
        int startMinutes;
        int pageSize;
        int mode;
        String str;
        BwPreferences prefs;
        Client cl = request.getClient();
        boolean tzChanged = false;
        if (cl.getPublicAdmin() && request.getReqPar("user") != null) {
            if (!form.getCurUserSuperUser()) {
                return 4;
            }
            prefs = cl.getPreferences(request.getReqPar("user"));
        } else {
            prefs = cl.getPreferences();
        }
        if (cl.getPublicAdmin() && cl.isSuperUser()) {
            int maxEntitySize;
            if (request.present("approvers")) {
                prefs.setCalsuiteApprovers(request.getReqPar("approvers"));
            }
            if (request.present("approver")) {
                str = request.getReqPar("approver");
                if (str == null) {
                    prefs.removeProperties("userpref:calsuite-approvers");
                } else {
                    List approvers = request.getReqPars("approver");
                    prefs.setCalsuiteApprovers(String.join((CharSequence)",", approvers));
                }
            }
            if ((str = request.getReqPar("defaultImageDirectory")) != null) {
                BwCalendar cal = cl.getCollection(str);
                if (cal == null) {
                    form.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)str);
                    return 5;
                }
                prefs.setDefaultImageDirectory(str);
                form.assignImageUploadDirectory(str);
            }
            if ((maxEntitySize = request.getIntReqPar("maxEntitySize", -1)) > 0) {
                prefs.setMaxEntitySize((long)maxEntitySize);
            }
        }
        if ((str = request.getReqPar("preferredView")) != null) {
            if (cl.getView(str) == null) {
                form.getErr().emit("org.bedework.client.error.unknown.view", (Object)str);
                return 5;
            }
            prefs.setPreferredView(str);
        }
        if ((str = request.getReqPar("viewPeriod")) != null) {
            prefs.setPreferredViewPeriod(this.validViewPeriod(str));
        }
        if ((str = this.validViewMode(request.getReqPar("defaultViewMode"))) != null) {
            prefs.setDefaultViewMode(str);
        }
        if ((str = request.getReqPar("defaultTzid")) != null && Timezones.getTz((String)str) != null) {
            prefs.setDefaultTzid(str);
            tzChanged = true;
        }
        if (request.present("defaultCategory")) {
            str = request.getReqPar("defaultCategory");
            if (str == null) {
                prefs.removeProperties("userpref:default-category");
            } else {
                List inUids = request.getReqPars("defaultCategory");
                TreeSet<String> uids = new TreeSet<String>();
                for (String uid : inUids) {
                    if (uid == null || cl.getCategory(uid) == null) continue;
                    uids.add(uid);
                }
                prefs.setDefaultCategoryUids(uids);
            }
        }
        if (request.present("hour24")) {
            prefs.setHour24(request.getBooleanReqPar("hour24").booleanValue());
            form.setHour24(prefs.getHour24());
        }
        if ((str = request.getReqPar("skin")) != null) {
            prefs.setSkinName(str);
        }
        if ((str = request.getReqPar("skinStyle")) != null) {
            prefs.setSkinStyle(str);
        }
        if ((str = request.getReqPar("email")) != null) {
            prefs.setEmail(str);
        }
        if (request.present("noNotifications")) {
            prefs.setNoNotifications(request.getBooleanReqPar("noNotifications").booleanValue());
        }
        if ((str = request.getReqPar("newCalPath")) != null) {
            BwCalendar cal = cl.getCollection(str);
            if (cal == null) {
                form.getErr().emit("org.bedework.client.error.unknown.calendar", (Object)str);
                return 5;
            }
            prefs.setDefaultCalendarPath(cal.getPath());
        }
        if ((mode = request.getIntReqPar("userMode", -1)) != -1) {
            if (mode < 0 || mode > 2) {
                form.getErr().emit("org.bedework.validation.error.invalid.prefusermode");
                return 31;
            }
            prefs.setUserMode(mode);
        }
        if ((pageSize = request.getIntReqPar("pageSize", -1)) != -1) {
            if (pageSize < 0) {
                form.getErr().emit("org.bedework.validation.error.invalid.pagesize");
                return 31;
            }
            prefs.setPageSize(pageSize);
        }
        if ((str = request.getReqPar("workDays")) != null) {
            prefs.setWorkDays(str);
        }
        if ((startMinutes = request.getIntReqPar("workdayStart", -1)) != -1) {
            if (startMinutes < 0 || startMinutes > 1439) {
                form.getErr().emit("org.bedework.validation.error.invalid.prefworkdaystart");
                return 31;
            }
        } else {
            startMinutes = prefs.getWorkdayStart();
        }
        if ((endMinutes = request.getIntReqPar("workdayEnd", -1)) != -1) {
            if (endMinutes < 0 || endMinutes > 1439) {
                form.getErr().emit("org.bedework.validation.error.invalid.prefworkdayend");
                return 31;
            }
        } else {
            endMinutes = prefs.getWorkdayEnd();
        }
        if (startMinutes > endMinutes) {
            form.getErr().emit("org.bedework.validation.error.invalid.prefworkdays");
            return 31;
        }
        prefs.setWorkdayStart(startMinutes);
        prefs.setWorkdayEnd(endMinutes);
        str = request.getReqPar("preferredEndType");
        if (str != null) {
            if ("duration".equals(str) || "date".equals(str)) {
                prefs.setPreferredEndType(str);
                form.setEndDateType(prefs.getPreferredEndType());
            } else {
                form.getErr().emit("org.bedework.validation.error.invalid.prefendtype");
                return 31;
            }
        }
        if ((bool = request.getBooleanReqPar("scheduleAutoRespond")) != null) {
            prefs.setScheduleAutoRespond(bool.booleanValue());
        }
        if ((ival = request.getIntReqPar("scheduleAutoCancelAction", -1)) != -1) {
            if (ival < 0 || ival > BwPreferences.scheduleMaxAutoCancel) {
                form.getErr().emit("org.bedework.validation.error.invalid.invalidprefautocancel");
                return 31;
            }
            prefs.setScheduleAutoCancelAction(ival);
        }
        if ((bool = request.getBooleanReqPar("scheduleDoubleBook")) != null) {
            prefs.setScheduleDoubleBook(bool.booleanValue());
        }
        if ((ival = request.getIntReqPar("scheduleAutoProcessResponses", -1)) != -1) {
            if (ival < 0 || ival > BwPreferences.scheduleMaxAutoProcessResponses) {
                form.getErr().emit("org.bedework.validation.error.invalid.invalidprefautoprocess");
                return 31;
            }
            prefs.setScheduleAutoProcessResponses(ival);
        }
        cl.updatePreferences(prefs);
        if (tzChanged) {
            Timezones.setThreadDefaultTzid((String)prefs.getDefaultTzid());
        }
        form.setUserPreferences(prefs);
        form.getMsg().emit("org.bedework.client.message.updated.prefs");
        return 0;
    }

    private String validViewMode(String s) {
        if (s == null) {
            return null;
        }
        String ls = s.toLowerCase();
        if ("list".equals(ls)) {
            return ls;
        }
        if ("daily".equals(ls)) {
            return ls;
        }
        if ("grid".equals(ls)) {
            return ls;
        }
        return null;
    }
}

