/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.resources;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class AddResourceAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        String rclass = request.getReqPar("class");
        String name = request.getReqPar("name");
        String contentType = request.getReqPar("ct");
        String type = request.getReqPar("type");
        if (rclass == null) {
            rclass = "calsuite";
        }
        if (name == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 28;
        }
        if (contentType == null) {
            form.getErr().emit("org.bedework.validation.error.missingcontenttype");
            return 28;
        }
        if (type == null) {
            form.getErr().emit("org.bedework.validation.error.missingtype");
            return 28;
        }
        if ((rclass.equals("global") || rclass.equals("admin")) && !form.getCurUserSuperUser()) {
            return 4;
        }
        BwResource r = cl.getCSResource((BwCalSuite)form.getCurrentCalSuite(), name, rclass);
        if (r != null) {
            return 16;
        }
        r = new BwResource();
        r.setName(name);
        BwResourceContent rc = new BwResourceContent();
        r.setContent(rc);
        contentType = contentType + "\ttype=" + type;
        r.setContentType(contentType);
        cl.addCSResource((BwCalSuite)form.getCurrentCalSuite(), r, rclass);
        form.setResourceName(name);
        form.setResourceClass(rclass);
        form.assignAddingResource(true);
        return 0;
    }
}

