/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.resources;

import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class RemoveResourceAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        String cancel = request.getReqPar("cancel");
        if (cancel != null) {
            return 32;
        }
        String name = request.getReqPar("name");
        if (name == null) {
            form.getErr().emit("org.bedework.validation.error.missingname");
            return 2;
        }
        String rclass = request.getReqPar("class");
        if (rclass == null) {
            form.getErr().emit("org.bedework.validation.error.missingclass");
            return 2;
        }
        BwResource r = cl.getCSResource((BwCalSuite)form.getCurrentCalSuite(), name, rclass);
        if (r == null) {
            form.getErr().emit("org.bedework.client.error.unknown.resource", (Object)name);
            return 5;
        }
        cl.deleteCSResource((BwCalSuite)form.getCurrentCalSuite(), name, rclass);
        form.getMsg().emit("org.bedework.client.message.deleted.resource");
        return 0;
    }
}

