/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.resources;

import org.bedework.appcommon.CalSuiteResource;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.RenderAction;

public class RenderResourceAction
extends RenderAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        String name = form.getResourceName();
        if (name == null) {
            request.getErr().emit("org.bedework.validation.error.missingname");
            return 2;
        }
        String rclass = form.getResourceClass();
        if (rclass == null) {
            rclass = "calsuite";
        }
        if ((rclass.equals("global") || rclass.equals("admin")) && !form.getCurUserSuperUser()) {
            return 4;
        }
        String mod = request.getReqPar("mod");
        BwResource resource = cl.getCSResource((BwCalSuite)form.getCurrentCalSuite(), name, rclass);
        if (resource == null) {
            request.getErr().emit("org.bedework.client.error.unknown.resource", (Object)name);
            return 2;
        }
        if (mod != null && mod.equals("true")) {
            form.assignAddingResource(false);
        }
        form.setCalSuiteResource(new CalSuiteResource(resource, rclass));
        return 0;
    }
}

