/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.schedule;

import java.util.List;
import org.bedework.appcommon.EventKey;
import org.bedework.appcommon.client.Client;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.base.CategorisedEntity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.ValidationError;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.BwWebUtil;
import org.bedework.webcommon.event.EventActionBase;

public class AttendeeRespond
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        List<ValidationError> ves;
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        if (request.present("initUpdate")) {
            EventInfo ei = form.getEventInfo();
            if (ei == null) {
                return 9;
            }
            form.setEventKey(new EventKey(ei.getEvent(), true));
            this.initSession(request);
            return 0;
        }
        EventInfo ei = this.refetchEvent(request);
        if (ei == null) {
            return 9;
        }
        BwEvent ev = ei.getEvent();
        String methStr = request.getReqPar("method");
        if ("REFRESH".equals(methStr)) {
            ScheduleResult sr = cl.requestRefresh(ei, request.getReqPar("comment"));
            this.emitScheduleStatus(form, sr, false);
            this.initSession(request);
            return 0;
        }
        int method = ev.getScheduleMethod();
        if (method == 5) {
            return 0;
        }
        if ("COUNTER".equals(methStr)) {
            boolean publicAdmin = cl.getPublicAdmin();
            this.setEventText(request, ev, true, null);
            int res = form.getEventDates().updateEvent(ei);
            if (res == 17) {
                return res;
            }
            if (publicAdmin) {
                if (!this.adminEventLocation(request, ei)) {
                    return 17;
                }
            } else if (this.setEventLocation(request, ei, form, false)) {
                // empty if block
            }
            if (publicAdmin && !this.setEventContact(request, false)) {
                return 17;
            }
            BwAbstractAction.SetEntityCategoriesResult secr = this.setEntityCategories(request, null, (CategorisedEntity)ev, null);
            if (secr.rcode != 0) {
                return secr.rcode;
            }
        }
        if ((ves = BwWebUtil.validateEvent(cl, false, false, ev)) != null) {
            for (ValidationError ve : ves) {
                form.getErr().emit(ve.getErrorCode(), (Object)ve.getExtra());
            }
            return 17;
        }
        String partStat = request.getReqPar("partstat");
        this.setupAttendeeRespond(cl, ei, request.getReqPar("delegate"), methStr, partStat, request.getReqPar("comment"), request.getBooleanReqPar("rsvp", false));
        EventInfo.UpdateResult ur = cl.updateEvent(ei, false, null);
        this.emitScheduleStatus(form, ur.schedulingResult, false);
        this.initSession(request);
        return 0;
    }

    private void initSession(BwRequest request) throws Throwable {
        BwSession sess = request.getSess();
        sess.embedAddContentCalendarCollections(request);
        sess.embedUserCollections(request);
        sess.embedContactCollection(request, 1);
        sess.embedCategories(request, false, 1);
        sess.embedLocations(request, 1);
    }

    private String setupAttendeeRespond(Client cl, EventInfo ei, String delegate, String meth, String partStat, String orgComment, boolean rsvp) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        BwEventProxy proxy = null;
        if (ev instanceof BwEventProxy) {
            proxy = (BwEventProxy)ev;
        }
        if (!ev.getAttendeeSchedulingObject().booleanValue()) {
            return "org.bedework.error.scheduling.badmethod";
        }
        String uri = cl.getCurrentCalendarAddress();
        BwAttendee att = ev.findAttendee(uri);
        if (att == null) {
            return "org.bedework.error.scheduling.notattendee";
        }
        if (ev.getOriginator() == null) {
            return "org.bedework.error.scheduling.noOriginator";
        }
        int method = 0;
        if (delegate == null && !Icalendar.itipReplyMethodType((int)(method = Icalendar.findMethodType((String)meth)))) {
            return "org.bedework.error.scheduling.badresponsemethod";
        }
        ev.setScheduleMethod(method);
        if (delegate != null) {
            String calAddr = cl.uriToCaladdr(delegate);
            if (calAddr == null) {
                return "org.bedework.validation.error.invalid.user";
            }
            att.setPartstat("DELEGATED");
            att.setDelegatedTo(calAddr);
            att.setRsvp(rsvp);
        } else if (method == 3) {
            int pStat = IcalDefs.checkPartstat((String)partStat);
            if (pStat != 1 && pStat != 2 && pStat != 3) {
                return "org.bedework.error.scheduling.invalidpartstatus";
            }
            if (proxy != null) {
                att = (BwAttendee)att.clone();
                ev.removeAttendee(att);
                ev.addAttendee(att);
            }
            att.setPartstat(partStat);
        } else if (method != 7) {
            throw new RuntimeException("Never get here");
        }
        return null;
    }
}

