/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.schedule;

import java.util.Collection;
import java.util.Date;
import org.bedework.appcommon.EventFormatter;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.RecurRuleComponents;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.event.EventActionBase;

public class ProcessInboxEvent
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (!request.present("calPath")) {
            request.setSessionAttr("bw_default_event_calendar", cl.getPreferences().getDefaultCalendarPath());
            return 1;
        }
        boolean preserveInbox = request.present("preserveInbox");
        form.assignAddingEvent(false);
        RecurringRetrievalMode.Rmode mode = !request.present("recurrenceId") ? RecurringRetrievalMode.Rmode.overrides : RecurringRetrievalMode.Rmode.expanded;
        EventInfo einf = this.findEvent(request, mode);
        if (einf == null) {
            return 9;
        }
        request.removeSessionAttr("bw_req_uid");
        if (einf.getEvent().getEntityType() == 7) {
            form.setRequestedUid(einf.getEvent().getUid());
            String tab = request.getReqPar("tab");
            if (tab == null) {
                request.removeSessionAttr("bw_req_vpoll_tab");
            } else {
                request.setSessionAttr("bw_req_vpoll_tab", tab);
            }
            if (!preserveInbox) {
                cl.deleteEvent(einf, false);
            }
            return 1;
        }
        EventInfo colEi = cl.getStoredMeeting(einf.getEvent());
        if (colEi == null) {
            this.copyEvent(request, einf.getEvent());
            if (!preserveInbox) {
                cl.deleteEvent(einf, false);
            }
            form.getMsg().emit("org.bedework.client.message.schedule.colcopy.deleted");
            return 43;
        }
        if (!preserveInbox) {
            cl.deleteEvent(einf, false);
        }
        form.setEventInfo(colEi, false);
        BwEvent ev = colEi.getEvent();
        if (ev.getRrules() != null) {
            Collection rrcs = RecurRuleComponents.fromEventRrules((BwEvent)ev);
            form.setRruleComponents(rrcs);
        } else {
            form.setRruleComponents(null);
        }
        EventFormatter ef = new EventFormatter(cl, new IcalTranslator((IcalCallback)new IcalCallbackcb(cl)), colEi);
        form.setCurEventFmt(ef);
        Date evdt = DateTimeUtil.fromISODateTimeUTC((String)ev.getDtstart().getDate());
        this.setViewDate(request, DateTimeUtil.isoDate((Date)evdt).substring(0, 8));
        form.setMeetingCal(cl.getCollection(ev.getColPath()));
        request.getSess().embedLocations(request, 1);
        return 1;
    }
}

