/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.schedule;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import javax.servlet.http.HttpServletResponse;
import net.fortuna.ical4j.model.Date;
import org.bedework.appcommon.client.Client;
import org.bedework.caldav.util.ParseUtil;
import org.bedework.caldav.util.TimeRange;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.json.JsonUtil;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class RequestFreeBusy
extends BwAbstractAction {
    private static final int indentSize = 2;
    private static final String blanks = "                               ";
    private static final int blanksLen = "                               ".length();

    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        try {
            BwDateTime end;
            Client cl = request.getClient();
            List attendees = request.getReqPars("attendeeUri");
            TreeSet<String> attendeeUris = new TreeSet<String>();
            for (String att : attendees) {
                attendeeUris.add(cl.uriToCaladdr(att));
            }
            String orgUri = request.getReqPar("organizerUri");
            if (orgUri == null) {
                orgUri = cl.getCurrentCalendarAddress();
            }
            AuthProperties authp = request.getSess().getAuthpars();
            int max = 0;
            if (!cl.isSuperUser()) {
                max = authp.getMaxFBPeriod();
            }
            TimeRange tr = ParseUtil.getPeriod((String)request.getReqPar("start"), (String)request.getReqPar("end"), (int)5, (int)authp.getDefaultFBPeriod(), (int)5, (int)max);
            HttpServletResponse resp = request.getResponse();
            if (tr == null) {
                resp.sendError(400, "dates");
                return 47;
            }
            BwDateTime start = BwDateTime.makeBwDateTime((Date)tr.getStart());
            BwEvent fbreq = BwEventObj.makeFreeBusyRequest((BwDateTime)start, (BwDateTime)(end = BwDateTime.makeBwDateTime((Date)tr.getEnd())), null, (String)orgUri, null, attendeeUris);
            if (fbreq == null) {
                return 33;
            }
            ScheduleResult sr = cl.schedule(new EventInfo(fbreq), null, null, false);
            form.setContentName("freebusy.js");
            resp.setHeader("Content-Disposition", "Attachment; Filename=\"freebusy.js\"");
            resp.setContentType("text/json; charset=UTF-8");
            this.outputJson(resp, sr);
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            request.getResponse().sendError(500, t.getMessage());
        }
        return 47;
    }

    private void outputJson(HttpServletResponse resp, ScheduleResult sr) throws Throwable {
        PrintWriter wtr = resp.getWriter();
        int indent = 0;
        ((Writer)wtr).write("{\n");
        indent += 2;
        ((Writer)wtr).write("  \"microformats\": {\n");
        ((Writer)wtr).write("    \"schedule-response\": [\n");
        indent += 2;
        Collection srrs = sr.recipientResults.values();
        int ct = srrs.size();
        for (ScheduleResult.ScheduleRecipientResult srr : srrs) {
            this.outputJson(wtr, indent + 2, srr, ct > 1);
            --ct;
        }
        this.indented(wtr, indent, "]\n");
        this.indented(wtr, indent -= 2, "}\n");
        ((Writer)wtr).write("}\n");
    }

    private void outputJson(Writer wtr, int indent, ScheduleResult.ScheduleRecipientResult srr, boolean withComma) throws Throwable {
        this.indented(wtr, indent, "{\n");
        int indentPlus = indent + 2;
        this.outputJsonValue(wtr, indentPlus, "recipient", srr.recipient);
        this.outputJsonValue(wtr, indentPlus, "status", String.valueOf(srr.getStatus()), srr.freeBusy != null);
        if (srr.freeBusy != null) {
            this.outputJson(wtr, indentPlus, srr.freeBusy);
        }
        if (withComma) {
            this.indented(wtr, indentPlus, "},\n");
        } else {
            this.indented(wtr, indentPlus, "}\n");
        }
    }

    private void outputJson(Writer wtr, int indent, BwEvent ev) throws Throwable {
        this.outputJsonStart(wtr, indent, "calendar-data", false);
        wtr.write("{\n");
        int indentPlus = indent + 2;
        this.outputJsonValue(wtr, indentPlus, "dtstart", ev.getDtstart().getDate());
        this.outputJsonValue(wtr, indentPlus, "dtend", ev.getDtend().getDate());
        this.outputJsonValue(wtr, indentPlus, "uid", ev.getUid());
        this.outputJsonValue(wtr, indentPlus, "organizer", ev.getOrganizer().getOrganizerUri());
        ArrayList<String> attUris = new ArrayList<String>();
        for (BwAttendee att : ev.getAttendees()) {
            attUris.add(att.getAttendeeUri());
        }
        this.outputJsonValues(wtr, indentPlus, "attendee", attUris, ev.getFreeBusyPeriods() != null);
        if (ev.getFreeBusyPeriods() != null) {
            this.outputJsonStart(wtr, indentPlus, "freebusy", true);
            indentPlus += 2;
            int ct = ev.getFreeBusyPeriods().size();
            for (BwFreeBusyComponent fbc : ev.getFreeBusyPeriods()) {
                this.indented(wtr, indentPlus, "{\n");
                this.outputJsonValue(wtr, indentPlus += 2, "fbtype", fbc.getTypeVal());
                this.outputJsonValues(wtr, indentPlus, "periods", fbc.getPeriods(), false);
                indentPlus -= 2;
                if (ct > 1) {
                    this.indented(wtr, indentPlus, "},\n");
                } else {
                    this.indented(wtr, indentPlus, "}\n");
                }
                --ct;
            }
            this.indented(wtr, indentPlus, "]\n");
            indentPlus -= 2;
        }
        this.indented(wtr, indentPlus -= 2, "}\n");
    }

    private void outputJsonValue(Writer wtr, int indent, String name, String val) throws Throwable {
        this.outputJsonStart(wtr, indent, name, false);
        this.outputJsonValue(wtr, indent, val);
    }

    private void outputJsonValue(Writer wtr, int indent, String name, String val, boolean withComma) throws Throwable {
        this.outputJsonStart(wtr, indent, name, false);
        this.outputJsonValue(wtr, indent, val, withComma);
    }

    private void outputJsonValues(Writer wtr, int indent, String name, Collection<? extends Object> vals, boolean withComma) throws Throwable {
        this.outputJsonStart(wtr, indent, name, true);
        int indentPlus = indent + 2;
        int ct = vals.size();
        for (Object object : vals) {
            this.outputJsonValue(wtr, indentPlus, String.valueOf(object), ct > 1);
            --ct;
        }
        if (withComma) {
            this.indented(wtr, indentPlus, "],\n");
        } else {
            this.indented(wtr, indentPlus, "]\n");
        }
    }

    private void outputJsonStart(Writer wtr, int indent, String name, boolean multi) throws Throwable {
        this.indented(wtr, indent, "\"");
        wtr.write(JsonUtil.jsonName((String)name));
        if (multi) {
            wtr.write("\" : [");
        } else {
            wtr.write("\" : ");
        }
    }

    private void outputJsonValue(Writer wtr, int indent, String val) throws Throwable {
        this.outputJsonValue(wtr, indent, val, true);
    }

    private void outputJsonValue(Writer wtr, int indent, String val, boolean withComma) throws Throwable {
        this.indented(wtr, indent, "{");
        wtr.write("\"value\" : ");
        if (val == null) {
            wtr.write(JsonUtil.jsonEncode((String)""));
        } else {
            wtr.write(JsonUtil.jsonEncode((String)val));
        }
        if (withComma) {
            wtr.write("},\n");
        } else {
            wtr.write("}\n");
        }
    }

    private void indented(Writer wtr, int indent, String val) throws Throwable {
        this.indent(wtr, indent);
        wtr.write(val);
    }

    private void indent(Writer wtr, int indent) throws Throwable {
        if (indent >= blanksLen) {
            wtr.write(blanks);
        } else {
            wtr.write(blanks.substring(0, indent));
        }
    }
}

