/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.search;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import net.fortuna.ical4j.model.Calendar;
import org.bedework.appcommon.EventFormatter;
import org.bedework.appcommon.client.Client;
import org.bedework.appcommon.client.IcalCallbackcb;
import org.bedework.appcommon.client.SearchParams;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.indexing.SearchResultEntry;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.icalendar.IcalCallback;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.util.xml.XmlEmit;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwModuleState;
import org.bedework.webcommon.BwRequest;
import org.bedework.webcommon.BwSession;
import org.bedework.webcommon.event.EventActionBase;

public class SearchParamsAction
extends EventActionBase {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        int forward;
        boolean gridMode;
        BwModuleState mstate = request.getModule().getState();
        SearchParams params = new SearchParams();
        Client cl = request.getClient();
        boolean forFeederOneShot = "y".equals(request.getReqPar("f"));
        if (request.getBooleanReqPar("listMode", false)) {
            cl.setViewMode("list");
        }
        boolean listMode = "list".equals(cl.getViewMode()) || forFeederOneShot;
        boolean bl = gridMode = !listMode && "grid".equals(cl.getViewMode());
        if (this.debug) {
            this.debugMsg("Client mode is " + cl.getViewMode());
        }
        if ((forward = this.setSearchParams(request, params, gridMode)) != 0) {
            return forward;
        }
        String outFormat = params.getFormat();
        boolean generateCalendarContent = false;
        boolean generateIcal = false;
        boolean generateXcal = false;
        if (outFormat != null) {
            switch (outFormat) {
                case "text/calendar": {
                    generateCalendarContent = true;
                    generateIcal = true;
                    break;
                }
                case "application/calendar+xml": {
                    generateCalendarContent = true;
                    generateXcal = true;
                    break;
                }
                case "application/calendar+json": {
                    generateCalendarContent = true;
                }
            }
        }
        HttpServletResponse response = request.getResponse();
        if (forFeederOneShot || generateCalendarContent) {
            String changeToken;
            form.setNocache(false);
            String ifNoneMatch = request.getRequest().getHeader("if-none-match");
            if (ifNoneMatch != null && (changeToken = cl.getCurrentChangeToken()) != null && changeToken.equals(ifNoneMatch)) {
                response.setStatus(304);
                return 47;
            }
        }
        params.setForExport(request.getBooleanReqPar("forExport", false));
        request.setRequestAttr("bw_search_params", params);
        if (params.getStatus() == Response.Status.ok) {
            mstate.setSearchResult(cl.search(params));
        }
        request.refresh();
        if (generateCalendarContent) {
            List sres = cl.getSearchResult(BwIndexer.Position.current);
            if (sres == null || sres.size() == 0) {
                return 47;
            }
            IcalTranslator trans = new IcalTranslator((IcalCallback)new IcalCallbackcb(request.getClient()));
            ArrayList<EventInfo> eis = new ArrayList<EventInfo>(sres.size());
            for (SearchResultEntry sre : sres) {
                if (!(sre.getEntity() instanceof EventFormatter)) continue;
                eis.add(((EventFormatter)sre.getEntity()).getEventInfo());
            }
            String contentName = form.getContentName();
            if (contentName == null) {
                contentName = generateIcal ? "calendar.ics" : (generateXcal ? "calendar.xcs" : "calendar.jcs");
            }
            response.setHeader("Content-Disposition", "Attachment; Filename=\"" + contentName + "\"");
            response.setContentType(outFormat + "; charset=UTF-8");
            response.addHeader("etag", cl.getCurrentChangeToken());
            response.setContentLength(-1);
            try (PrintWriter wtr = response.getWriter();){
                if (generateIcal) {
                    Calendar ical = trans.toIcal(eis, 1);
                    IcalTranslator.writeCalendar((Calendar)ical, (Writer)wtr);
                } else if (generateXcal) {
                    XmlEmit xml = new XmlEmit();
                    xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:icalendar-2.0", "X"), true);
                    xml.startEmit((Writer)wtr);
                    trans.writeXmlCalendar(eis, 1, xml);
                } else {
                    trans.writeJcal(eis, 1, (Writer)wtr);
                }
            }
            return 47;
        }
        if (params.getStatus() == Response.Status.ok) {
            request.setRequestAttr("bw_search_result", mstate.getSearchResult());
        }
        BwSession sess = request.getSess();
        if (cl.getPublicAdmin()) {
            sess.embedAddContentCalendarCollections(request);
        }
        if (!forFeederOneShot) {
            if (!gridMode) {
                return 45;
            }
            return 0;
        }
        if (params.getStatus() == Response.Status.ok) {
            request.setRequestAttr("bw_search_list", cl.getSearchResult(BwIndexer.Position.current));
        }
        sess.embedCategories(request, false, 1);
        response.addHeader("etag", cl.getCurrentChangeToken());
        return 0;
    }
}

