/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.sharing;

import org.bedework.appcommon.client.Client;
import org.bedework.caldav.util.sharing.AccessType;
import org.bedework.caldav.util.sharing.RemoveType;
import org.bedework.caldav.util.sharing.SetType;
import org.bedework.caldav.util.sharing.ShareType;
import org.bedework.calfacade.BwCalendar;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class ShareCollectionAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        BwCalendar col = request.getCollection(false);
        if (col == null) {
            return 5;
        }
        String cua = request.getCua(false);
        if (cua == null) {
            form.getErr().emit("org.bedework.validation.error.missingrecipients");
            return 2;
        }
        String calAddr = cl.uriToCaladdr(cua);
        if (calAddr == null) {
            form.getErr().emit("org.bedework.validation.error.invalid.user", (Object)cua);
            return 2;
        }
        ShareType share = new ShareType();
        if (request.present("remove")) {
            RemoveType rem = new RemoveType();
            rem.setHref(calAddr);
            share.getRemove().add(rem);
        } else {
            SetType set = new SetType();
            set.setHref(calAddr);
            String colName = request.getReqPar("colName");
            if (colName == null) {
                set.setSummary(col.getSummary());
            } else {
                set.setSummary(colName);
            }
            AccessType at = new AccessType();
            if (form.getGuest()) {
                at.setRead(Boolean.valueOf(true));
            } else {
                boolean readWrite = request.present("rw");
                if (readWrite && !col.getOwnerHref().equals(cl.getCurrentPrincipalHref())) {
                    readWrite = false;
                }
                if (readWrite) {
                    at.setReadWrite(Boolean.valueOf(true));
                } else {
                    at.setRead(Boolean.valueOf(true));
                }
            }
            set.setAccess(at);
            share.getSet().add(set);
        }
        cl.share(col.getOwnerHref(), col, share);
        if (request.getErrorsEmitted()) {
            return 2;
        }
        cl.flushState();
        return 1;
    }
}

