/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.sharing;

import org.bedework.appcommon.client.Client;
import org.bedework.caldav.util.notifications.NotificationType;
import org.bedework.caldav.util.sharing.InviteNotificationType;
import org.bedework.caldav.util.sharing.InviteReplyType;
import org.bedework.calfacade.exc.CalFacadeForbidden;
import org.bedework.webcommon.BwAbstractAction;
import org.bedework.webcommon.BwActionFormBase;
import org.bedework.webcommon.BwRequest;

public class ShareReplyAction
extends BwAbstractAction {
    @Override
    public int doAction(BwRequest request, BwActionFormBase form) throws Throwable {
        Client cl = request.getClient();
        if (cl.isGuest()) {
            return 4;
        }
        NotificationType note = cl.findNotification(request.getReqPar("name"));
        if (note == null) {
            return 5;
        }
        if (!(note.getNotification() instanceof InviteNotificationType)) {
            request.getErr().emit("org.bedework.client.error.badrequest", (Object)"Not an invite");
            return 3;
        }
        InviteNotificationType invite = (InviteNotificationType)note.getNotification();
        Boolean accept = request.getBooleanReqPar("accept");
        if (accept == null) {
            request.getErr().emit("org.bedework.client.error.badrequest", (Object)"Missing accept");
            return 3;
        }
        String colName = null;
        if (accept.booleanValue() && (colName = request.getReqPar("colName")) == null) {
            request.getErr().emit("org.bedework.client.error.badrequest", (Object)"Missing colName");
            return 3;
        }
        InviteReplyType reply = new InviteReplyType();
        reply.setHref(invite.getHref());
        reply.setAccepted(accept);
        reply.setHostUrl(invite.getHostUrl());
        reply.setInReplyTo(invite.getUid());
        reply.setSummary(colName);
        boolean error = false;
        try {
            cl.sharingReply(reply);
        }
        catch (CalFacadeForbidden cf) {
            request.getErr().emit(cf.getMessage());
            error = true;
        }
        cl.removeNotification(note);
        form.setNotificationInfo(null);
        cl.flushState();
        if (error) {
            return 3;
        }
        return 1;
    }
}

