/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webcommon.taglib;

import java.net.URLEncoder;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.JspWriter;
import javax.xml.namespace.QName;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.wrappers.CalendarWrapper;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;
import org.bedework.webcommon.taglib.EmitTextTag;

public class EmitCollectionTag
extends EmitTextTag {
    private boolean full;
    private boolean noTag;

    @Override
    public int doEndTag() throws JspTagException {
        try {
            BwCalendar col = (BwCalendar)this.getObject(false);
            String outerTag = null;
            if (!this.getNoTag()) {
                outerTag = this.getTagName();
                if (outerTag == null) {
                    outerTag = this.property;
                }
                if (outerTag == null) {
                    outerTag = "collection";
                }
            }
            JspWriter out = this.pageContext.getOut();
            String indent = this.getIndent();
            if (indent == null) {
                indent = "";
            }
            this.outerTagStart(out, outerTag);
            this.emitCollection(col, out, indent);
            this.outerTagEnd(out, outerTag, indent);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new JspTagException("Error: " + t.getMessage());
        }
        return 6;
    }

    protected void outerTagStart(JspWriter out, String tagName) throws Throwable {
        if (tagName == null) {
            return;
        }
        out.print('<');
        out.print(tagName);
        out.println('>');
    }

    protected void outerTagEnd(JspWriter out, String tagName, String indent) throws Throwable {
        if (tagName == null) {
            return;
        }
        out.print(indent);
        out.print("</");
        out.print(tagName);
        out.println('>');
    }

    protected void emitCollection(BwCalendar col, JspWriter out, String indent) throws Throwable {
        String val = null;
        if (col != null) {
            val = col.getName();
        }
        this.emitElement(out, indent, "name", val);
        if (col != null) {
            val = col.getSummary();
        }
        this.emitElement(out, indent, "summary", val);
        if (col != null) {
            val = col.getPath();
        }
        this.emitElement(out, indent, "path", val);
        if (val != null) {
            val = URLEncoder.encode(val, "UTF-8");
        }
        this.emitElement(out, indent, "encodedPath", val);
        if (col != null) {
            val = col.getOwnerHref();
        }
        this.emitElement(out, indent, "ownerHref", val);
        if (col != null) {
            val = String.valueOf(col.getCalType());
        }
        this.emitElement(out, indent, "actualCalType", val);
        if (col != null && col.getCalType() == 7) {
            CalendarWrapper cw = (CalendarWrapper)col;
            BwCalendar target = cw.getAliasedEntity();
            val = target == null ? String.valueOf(-1) : String.valueOf(target.getCalType());
        }
        this.emitElement(out, indent, "calType", val);
        val = col != null ? col.getProperty(NamespaceAbbrevs.prefixed((QName)AppleServerTags.readWrite)) : null;
        if (val != null) {
            this.emitElement(out, indent, "read-write", "true");
        }
        if (col != null) {
            if (col.getShared()) {
                this.emitElement(out, indent, "shared", "true");
            }
            this.emitElement(out, indent, "calendarCollection", String.valueOf(col.getCalendarCollection()));
            this.emitElement(out, indent, "affectsFreeBusy", String.valueOf(col.getAffectsFreeBusy()));
        } else {
            this.emitElement(out, indent, "calendarCollection", "false");
            this.emitElement(out, indent, "affectsFreeBusy", "false");
        }
        if (col != null) {
            val = String.valueOf(col.getColor());
        }
        this.emitElement(out, indent, "color", val);
        if (col != null) {
            val = String.valueOf(col.getIsTopicalArea());
        }
        this.emitElement(out, indent, "isTopicalArea", val);
        if (col != null) {
            val = String.valueOf(col.getDisplay());
        }
        this.emitElement(out, indent, "display", val);
        if (col != null) {
            val = String.valueOf(col.getDisabled());
        }
        this.emitElement(out, indent, "disabled", val);
        if (col != null) {
            val = col.getLastRefreshStatus();
        }
        this.emitElement(out, indent, "lastRefreshStatus", val);
        if (col != null) {
            val = col.getLastRefresh();
        }
        this.emitElement(out, indent, "lastRefresh", val);
        if (col != null) {
            val = String.valueOf(col.getOpen());
        }
        this.emitElement(out, indent, "open", val);
        if (col == null || !this.full) {
            return;
        }
        String prefPath = this.getPreferences().getDefaultCalendarPath();
        if (prefPath != null && prefPath.equals(col.getPath())) {
            this.emitElement(out, indent, "default-scheduling-collection", null);
            this.emitElement(out, indent, "can-be-shared", null);
        } else if (col.getCalType() == 1) {
            this.emitElement(out, indent, "can-be-shared", null);
            this.emitElement(out, indent, "can-be-published", null);
        } else if (col.getCalType() == 7 || col.getCalType() == 8) {
            this.emitElement(out, indent, "can-be-shared", null);
        }
        String inviteStr = col.getProperty(NamespaceAbbrevs.prefixed((QName)AppleServerTags.invite));
        if (inviteStr != null) {
            if (inviteStr.startsWith("<?xml")) {
                inviteStr = inviteStr.substring(inviteStr.indexOf("<", 3));
            }
            out.println(inviteStr);
        }
        this.emitElement(out, indent, "desc", col.getDescription());
        this.emitElement(out, indent, "canAlias", String.valueOf(col.getCanAlias()));
        this.emitElement(out, indent, "isSubscription", String.valueOf(col.getAlias()));
        this.emitCdataElement(out, indent, "aliasUri", col.getAliasUri());
        this.emitElement(out, indent, "internalAlias", String.valueOf(col.getInternalAlias()));
        this.emitElement(out, indent, "externalSub", String.valueOf(col.getExternalSub()));
        this.emitElement(out, indent, "unremoveable", String.valueOf(col.getUnremoveable()));
        this.emitElement(out, indent, "refreshRate", String.valueOf(col.getRefreshRate()));
        this.emitElement(out, indent, "filterExpr", col.getFilterExpr());
    }

    private void emitElement(JspWriter out, String indent, String name, String val) throws Throwable {
        this.emitElement(out, indent, name, val, false);
    }

    private void emitCdataElement(JspWriter out, String indent, String name, String val) throws Throwable {
        this.emitElement(out, indent, name, val, true);
    }

    private void emitElement(JspWriter out, String indent, String name, String val, boolean alwaysCdata) throws Throwable {
        out.print(indent);
        out.print("  <");
        out.print(name);
        out.print('>');
        if (val != null) {
            boolean cdata;
            boolean bl = cdata = alwaysCdata || val.indexOf(38) >= 0 || val.indexOf(60) >= 0 || val.indexOf("<![CDATA[") >= 0;
            if (!cdata) {
                out.print(val);
            } else {
                int start = 0;
                while (start < val.length()) {
                    int end = val.indexOf("]]", start);
                    boolean lastSeg = end < 0;
                    String seg = lastSeg ? val.substring(start) : val.substring(start, end);
                    boolean bl2 = cdata = alwaysCdata || seg.indexOf(38) >= 0 || seg.indexOf(60) >= 0 || seg.indexOf("<![CDATA[") >= 0 || start > 0 && seg.startsWith(">");
                    if (!cdata) {
                        out.print(seg);
                    } else {
                        out.print("<![CDATA[");
                        out.print(seg);
                        out.print("]]>");
                    }
                    if (lastSeg) break;
                    out.print("]]");
                    start = end + 2;
                }
            }
        }
        out.print("</");
        out.print(name);
        out.println('>');
    }

    public void setFull(boolean val) {
        this.full = val;
    }

    public boolean getFull() {
        return this.full;
    }

    public void setNoTag(boolean val) {
        this.noTag = val;
    }

    public boolean getNoTag() {
        return this.noTag;
    }
}

