/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvci;

import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvci.CalSvcFactory;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.calsvci.SchemaBuilder;
import org.bedework.util.misc.Util;

public class CalSvcFactoryDefault
implements CalSvcFactory {
    private static final String defaultSvciClass = "org.bedework.calsvc.CalSvc";
    private static final String schemaBuilderClass = "org.bedework.calcore.hibernate.SchemaBuilderImpl";
    private static final String systemConfigClass = "org.bedework.calsvc.jmx.ConfigurationsImpl";
    private static Configurations conf;

    public static SystemProperties getSystemProperties() throws CalFacadeException {
        return new CalSvcFactoryDefault().getSystemConfig().getSystemProperties();
    }

    @Override
    public CalSvcI getSvc(CalSvcIPars pars) throws CalFacadeException {
        CalSvcI svc = (CalSvcI)CalSvcFactoryDefault.loadInstance(defaultSvciClass, CalSvcI.class);
        svc.init(pars);
        return svc;
    }

    @Override
    public SchemaBuilder getSchemaBuilder() throws CalFacadeException {
        return (SchemaBuilder)CalSvcFactoryDefault.loadInstance(schemaBuilderClass, SchemaBuilder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Configurations getSystemConfig() throws CalFacadeException {
        if (conf != null) {
            return conf;
        }
        String string = defaultSvciClass;
        synchronized (defaultSvciClass) {
            if (conf != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return conf;
            }
            conf = (Configurations)CalSvcFactoryDefault.loadInstance(systemConfigClass, Configurations.class);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return conf;
        }
    }

    public static Properties getPr() throws CalFacadeException {
        try {
            SystemProperties sysProps = CalSvcFactoryDefault.getSystemProperties();
            Properties pr = new Properties();
            if (Util.isEmpty((Collection)sysProps.getSyseventsProperties())) {
                throw new CalFacadeException("No sysevent properties defined");
            }
            StringBuilder sb = new StringBuilder();
            List ps = sysProps.getSyseventsProperties();
            for (String p : ps) {
                sb.append(p);
                sb.append("\n");
            }
            pr.load(new StringReader(sb.toString()));
            return pr;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t.getMessage());
        }
    }

    private static Object loadInstance(String cname, Class interfaceClass) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = loader.loadClass(cname);
            if (cl == null) {
                throw new CalFacadeException("Class " + cname + " not found");
            }
            Object o = cl.newInstance();
            if (o == null) {
                throw new CalFacadeException("Unable to instantiate class " + cname);
            }
            if (!interfaceClass.isInstance(o)) {
                throw new CalFacadeException("Class " + cname + " is not a subclass of " + interfaceClass.getName());
            }
            return o;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }
}

