/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvci;

import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.util.misc.Util;

public class SynchReportItem
implements Comparable<SynchReportItem> {
    private final String token;
    private EventInfo event;
    private BwResource resource;
    private BwCalendar col;
    private final String vpath;
    private boolean canSync;

    public SynchReportItem(String vpath, EventInfo event) {
        this.vpath = vpath;
        this.event = event;
        this.token = event.getEvent().getCtoken();
    }

    public SynchReportItem(String vpath, BwResource resource) {
        this.vpath = vpath;
        this.resource = resource;
        this.token = resource.getEtagValue();
    }

    public SynchReportItem(String vpath, BwCalendar col, boolean canSync) {
        this.vpath = vpath;
        this.col = col;
        this.canSync = canSync;
        this.token = col.getLastmod().getTagValue();
    }

    public SynchReportItem(String vpath, BwCalendar col, boolean canSync, String token) {
        this.vpath = vpath;
        this.col = col;
        this.canSync = canSync;
        String colToken = col.getLastmod().getTagValue();
        this.token = colToken.compareTo(token) > 0 ? colToken : token;
    }

    public String getToken() {
        return this.token;
    }

    public EventInfo getEvent() {
        return this.event;
    }

    public BwResource getResource() {
        return this.resource;
    }

    public BwCalendar getCol() {
        return this.col;
    }

    public String getVpath() {
        return this.vpath;
    }

    public boolean getCanSync() {
        return this.canSync;
    }

    @Override
    public int compareTo(SynchReportItem that) {
        int res = this.token.compareTo(that.token);
        if (res != 0) {
            return res;
        }
        res = Util.cmpObjval((Comparable)this.getResource(), (Comparable)that.getResource());
        if (res != 0) {
            return res;
        }
        res = Util.cmpObjval((Comparable)this.getEvent(), (Comparable)that.getEvent());
        if (res != 0) {
            return res;
        }
        return Util.cmpObjval((Comparable)this.getCol(), (Comparable)that.getCol());
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof SynchReportItem)) {
            return false;
        }
        return this.compareTo((SynchReportItem)o) == 0;
    }
}

