/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.MesssageHandler;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;

public abstract class AbstractScheduler
extends CalSvcDb
implements MesssageHandler {
    public AbstractScheduler() {
        super(null);
    }

    protected String getParentPath(String href) {
        int pos = href.lastIndexOf("/");
        if (pos <= 0) {
            return null;
        }
        return href.substring(0, pos);
    }

    protected String getName(String href) {
        int pos = href.lastIndexOf("/");
        if (pos <= 0) {
            return href;
        }
        if (pos == href.length() - 1) {
            return null;
        }
        return href.substring(pos + 1);
    }

    protected CalSvcI getSvci(String principalHref) throws CalFacadeException {
        CalSvcIPars runAsPars = CalSvcIPars.getServicePars((String)"scheduler", (String)principalHref, (boolean)false, (boolean)"/principals/users/root".equals(principalHref));
        CalSvcI svci = new CalSvcFactoryDefault().getSvc(runAsPars);
        this.setSvc(svci);
        svci.open();
        svci.beginTransaction();
        return svci;
    }

    protected void rollback(CalSvcI svci) {
        try {
            svci.rollbackTransaction();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSvci(CalSvcI svci) throws CalFacadeException {
        if (svci == null || !svci.isOpen()) {
            return;
        }
        CalFacadeException exc = null;
        try {
            try {
                svci.endTransaction();
            }
            catch (CalFacadeException cfe) {
                this.rollback(svci);
                exc = cfe;
            }
        }
        finally {
            svci.close();
        }
        if (exc != null) {
            throw exc;
        }
    }
}

