/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.sql.Blob;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.bedework.access.Access;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.Acl;
import org.bedework.access.PrivilegeSet;
import org.bedework.calcorei.Calintf;
import org.bedework.calcorei.CalintfFactory;
import org.bedework.caldav.util.notifications.admin.AdminNoteParsers;
import org.bedework.caldav.util.notifications.eventreg.EventregParsers;
import org.bedework.caldav.util.notifications.suggest.SuggestParsers;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwGroup;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwStats;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.base.UpdateFromTimeZonesInfo;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.IndexProperties;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.ifs.IfInfo;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.mail.MailerIntf;
import org.bedework.calfacade.responses.GetEntityResponse;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calfacade.svc.UserAuth;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calfacade.util.CalFacadeUtil;
import org.bedework.calsvc.Admin;
import org.bedework.calsvc.CalSuites;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvc.CategoriesImpl;
import org.bedework.calsvc.ContactsImpl;
import org.bedework.calsvc.DumpImpl;
import org.bedework.calsvc.Events;
import org.bedework.calsvc.Filters;
import org.bedework.calsvc.GroupsCallBack;
import org.bedework.calsvc.LocationsImpl;
import org.bedework.calsvc.Notifications;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvc.ResourcesImpl;
import org.bedework.calsvc.RestoreImpl;
import org.bedework.calsvc.Sharing;
import org.bedework.calsvc.SvciPrincipalInfo;
import org.bedework.calsvc.Synch;
import org.bedework.calsvc.Syspars;
import org.bedework.calsvc.TimeZonesStoreImpl;
import org.bedework.calsvc.UserAuthCallBack;
import org.bedework.calsvc.Users;
import org.bedework.calsvc.Views;
import org.bedework.calsvc.scheduling.Scheduling;
import org.bedework.calsvc.scheduling.SchedulingIntf;
import org.bedework.calsvci.AdminI;
import org.bedework.calsvci.CalSuitesI;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.Categories;
import org.bedework.calsvci.Contacts;
import org.bedework.calsvci.DumpIntf;
import org.bedework.calsvci.EventsI;
import org.bedework.calsvci.FiltersI;
import org.bedework.calsvci.Locations;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.PreferencesI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.RestoreIntf;
import org.bedework.calsvci.SchedulingI;
import org.bedework.calsvci.SharingI;
import org.bedework.calsvci.SynchI;
import org.bedework.calsvci.SynchReport;
import org.bedework.calsvci.SynchReportItem;
import org.bedework.calsvci.SysparsI;
import org.bedework.calsvci.TimeZonesStoreI;
import org.bedework.calsvci.UsersI;
import org.bedework.calsvci.ViewsI;
import org.bedework.icalendar.IcalCallback;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.jmx.MBeanUtil;
import org.bedework.util.misc.Util;
import org.bedework.util.security.PwEncryptionIntf;
import org.bedework.util.security.keys.GenKeysMBean;
import org.bedework.util.timezones.Timezones;
import org.hibernate.exception.ConstraintViolationException;

public class CalSvc
extends CalSvcI {
    private CalSvcIPars pars;
    private boolean debug;
    private static Configurations configs;
    private boolean open;
    private boolean creating;
    private boolean authenticated;
    private PrincipalInfo principalInfo;
    BwAuthUser adminUser;
    private PreferencesI prefsHandler;
    private AdminI adminHandler;
    private EventsI eventsHandler;
    private FiltersI filtersHandler;
    private CalendarsI calendarsHandler;
    private SysparsI sysparsHandler;
    private CalSuitesI calSuitesHandler;
    private NotificationsI notificationsHandler;
    private ResourcesI resourcesHandler;
    private SchedulingIntf sched;
    private SharingI sharingHandler;
    private SynchI synch;
    private UsersI usersHandler;
    private ViewsI viewsHandler;
    private Categories categoriesHandler;
    private Locations locationsHandler;
    private Contacts contactsHandler;
    private final Collection<CalSvcDb> handlers = new ArrayList<CalSvcDb>();
    private transient Calintf cali;
    private transient PwEncryptionIntf pwEncrypt;
    private Timezones timezones;
    private TimeZonesStoreI tzstore;
    private static String tzserverUri;
    private UserAuth userAuth;
    private transient UserAuth.CallBack uacb;
    private transient Directories.CallBack gcb;
    private Directories userGroups;
    private Directories adminGroups;
    private IcalCallback icalcb;
    private transient Logger log;
    private static volatile Object synchlock;
    private static final Map<String, BwPrincipal> authUsers;
    private static final Map<String, BwPrincipal> unauthUsers;

    public void init(CalSvcIPars parsParam) throws CalFacadeException {
        this.init(parsParam, false);
    }

    private void init(CalSvcIPars parsParam, boolean creating) throws CalFacadeException {
        this.pars = (CalSvcIPars)parsParam.clone();
        this.creating = creating;
        this.debug = this.getLogger().isDebugEnabled();
        long start = System.currentTimeMillis();
        this.fixUsers();
        try {
            if (configs == null) {
                configs = new CalSvcFactoryDefault().getSystemConfig();
            }
            this.open();
            this.beginTransaction();
            if (this.userGroups != null) {
                this.userGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
            }
            if (this.adminGroups != null) {
                this.adminGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
            }
            SystemProperties sp = this.getSystemProperties();
            if (tzserverUri == null) {
                tzserverUri = sp.getTzServeruri();
                if (tzserverUri == null) {
                    throw new CalFacadeException("No timezones server URI defined");
                }
                Timezones.initTimezones((String)tzserverUri);
                Timezones.setSystemDefaultTzid((String)sp.getTzid());
            }
            this.tzstore = new TimeZonesStoreImpl(this);
            System.setProperty("net.fortuna.ical4j.timezone.registry", "org.bedework.icalendar.TimeZoneRegistryFactoryImpl");
            if (!creating) {
                String tzid = this.getPrefsHandler().get().getDefaultTzid();
                if (tzid != null) {
                    Timezones.setThreadDefaultTzid((String)tzid);
                }
                if (!this.pars.isGuest()) {
                    // empty if block
                }
            }
            if ((this.pars.getPublicAdmin() || this.pars.getAllowSuperUser()) && this.pars.getAuthUser() != null) {
                ((SvciPrincipalInfo)this.principalInfo).setSuperUser(this.getSysparsHandler().isRootUser(this.principalInfo.getAuthPrincipal()));
            }
            this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.USER_SVCINIT, (AccessPrincipal)this.getPrincipal(), (long)(System.currentTimeMillis() - start)));
        }
        catch (CalFacadeException cfe) {
            this.rollbackTransaction();
            cfe.printStackTrace();
            throw cfe;
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            t.printStackTrace();
            throw new CalFacadeException(t);
        }
        finally {
            try {
                this.endTransaction();
            }
            catch (Throwable throwable) {}
            try {
                this.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public BasicSystemProperties getBasicSystemProperties() {
        return configs.getBasicSystemProperties();
    }

    public AuthProperties getAuthProperties() {
        return configs.getAuthProperties(this.authenticated);
    }

    public AuthProperties getAuthProperties(boolean auth) {
        return configs.getAuthProperties(auth);
    }

    public SystemProperties getSystemProperties() {
        return configs.getSystemProperties();
    }

    public NotificationProperties getNotificationProperties() {
        return configs.getNotificationProps();
    }

    public IndexProperties getIndexProperties() {
        return configs.getIndexProperties();
    }

    public void setCalSuite(String name) throws CalFacadeException {
        BwCalSuiteWrapper cs = this.getCalSuitesHandler().get(name);
        if (cs == null) {
            this.error("******************************************************");
            this.error("Unable to fetch calendar suite " + name);
            this.error("Is the database correctly initialised?");
            this.error("******************************************************");
            throw new CalFacadeException("org.bedework.svci.unknown.calsuite", name);
        }
        this.getCalSuitesHandler().set(cs);
    }

    public PrincipalInfo getPrincipalInfo() {
        return this.principalInfo;
    }

    public boolean getSuperUser() {
        return this.principalInfo.getSuperUser();
    }

    public byte[] getPublicKey(String domain, String service) throws CalFacadeException {
        try {
            return this.getEncrypter().getPublicKey();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public BwStats getStats() throws CalFacadeException {
        BwStats stats = this.getCal().getStats();
        if (this.timezones != null) {
            BwStats.CacheStats cs = stats.getDateCacheStats();
            cs.setHits(this.timezones.getDateCacheHits());
            cs.setMisses(this.timezones.getDateCacheMisses());
            cs.setCached(this.timezones.getDatesCached());
        }
        stats.setAccessStats(Access.getStatistics());
        return stats;
    }

    public void setDbStatsEnabled(boolean enable) throws CalFacadeException {
        this.getCal().setDbStatsEnabled(enable);
    }

    public boolean getDbStatsEnabled() throws CalFacadeException {
        return this.getCal().getDbStatsEnabled();
    }

    public void dumpDbStats() throws CalFacadeException {
        this.trace(this.getStats().toString());
        this.getCal().dumpDbStats();
    }

    public Collection<BwStats.StatsEntry> getDbStats() throws CalFacadeException {
        return this.getCal().getDbStats();
    }

    public void logStats() throws CalFacadeException {
        this.logIt(this.getStats().toString());
    }

    public IfInfo getIfInfo() throws CalFacadeException {
        return this.getCal().getIfInfo();
    }

    public List<IfInfo> getActiveIfInfos() throws CalFacadeException {
        ArrayList<IfInfo> ifs = new ArrayList<IfInfo>();
        for (Calintf ci : this.getCal().active()) {
            ifs.add(ci.getIfInfo());
        }
        return ifs;
    }

    public void kill(IfInfo ifInfo) {
        try {
            for (Calintf ci : this.getCal().active()) {
                IfInfo calIfInfo = ci.getIfInfo();
                if (!calIfInfo.getId().equals(ifInfo.getId())) continue;
                this.warn("Stopping interface with id " + ifInfo.getId());
                ci.kill();
                break;
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    public void setState(String val) throws CalFacadeException {
        this.getCal().setState(val);
    }

    public void postNotification(SysEventBase ev) throws CalFacadeException {
        this.getCal().postNotification(ev);
    }

    public void flushAll() throws CalFacadeException {
        this.getCal().flush();
    }

    public void open() throws CalFacadeException {
        if (this.open) {
            return;
        }
        this.open = true;
        this.getCal().open(this.pars.getWebMode(), this.pars.getForRestore(), this.pars.getIndexRebuild());
        for (CalSvcDb handler : this.handlers) {
            handler.open();
        }
    }

    public boolean isOpen() {
        return this.open;
    }

    public boolean isRolledback() throws CalFacadeException {
        if (!this.open) {
            return false;
        }
        return this.getCal().isRolledback();
    }

    public void close() throws CalFacadeException {
        this.open = false;
        this.getCal().close();
        for (CalSvcDb handler : this.handlers) {
            handler.close();
        }
    }

    public void beginTransaction() throws CalFacadeException {
        this.getCal().beginTransaction();
    }

    public void endTransaction() throws CalFacadeException {
        this.getCal().endTransaction();
    }

    public void rollbackTransaction() throws CalFacadeException {
        this.getCal().rollbackTransaction();
    }

    public Timestamp getCurrentTimestamp() throws CalFacadeException {
        return this.getCal().getCurrentTimestamp();
    }

    public Blob getBlob(byte[] val) throws CalFacadeException {
        return this.getCal().getBlob(val);
    }

    public void reAttach(BwDbentity val) throws CalFacadeException {
        this.getCal().reAttach(val);
    }

    public BwUnversionedDbentity merge(BwUnversionedDbentity val) throws CalFacadeException {
        return this.getCal().merge(val);
    }

    public IcalCallback getIcalCallback() {
        if (this.icalcb == null) {
            this.icalcb = new IcalCallbackcb(null);
        }
        return this.icalcb;
    }

    public IcalCallback getIcalCallback(Boolean timezonesByReference) {
        if (this.icalcb == null) {
            this.icalcb = new IcalCallbackcb(timezonesByReference);
        }
        return this.icalcb;
    }

    public DumpIntf getDumpHandler() throws CalFacadeException {
        return new DumpImpl(this);
    }

    public RestoreIntf getRestoreHandler() throws CalFacadeException {
        return new RestoreImpl(this);
    }

    public SimpleFilterParser getFilterParser() {
        return new SvcSimpleFilterParser();
    }

    public SysparsI getSysparsHandler() throws CalFacadeException {
        if (this.sysparsHandler == null) {
            this.sysparsHandler = new Syspars(this);
            this.handlers.add((CalSvcDb)this.sysparsHandler);
        }
        return this.sysparsHandler;
    }

    public MailerIntf getMailer() throws CalFacadeException {
        try {
            MailerIntf mailer = (MailerIntf)CalFacadeUtil.getObject((String)this.getSystemProperties().getMailerClass(), MailerIntf.class);
            mailer.init(configs.getMailConfigProperties());
            return mailer;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public PreferencesI getPrefsHandler() throws CalFacadeException {
        if (this.prefsHandler == null) {
            this.prefsHandler = new Preferences(this);
            this.handlers.add((CalSvcDb)this.prefsHandler);
        }
        return this.prefsHandler;
    }

    public AdminI getAdminHandler() throws CalFacadeException {
        if (!this.isPublicAdmin()) {
            throw new CalFacadeAccessException();
        }
        if (this.adminHandler == null) {
            this.adminHandler = new Admin(this);
            this.handlers.add((CalSvcDb)this.adminHandler);
        }
        return this.adminHandler;
    }

    public EventsI getEventsHandler() {
        if (this.eventsHandler == null) {
            this.eventsHandler = new Events(this);
            this.handlers.add((CalSvcDb)this.eventsHandler);
        }
        return this.eventsHandler;
    }

    public FiltersI getFiltersHandler() {
        if (this.filtersHandler == null) {
            this.filtersHandler = new Filters(this);
            this.handlers.add((CalSvcDb)this.filtersHandler);
        }
        return this.filtersHandler;
    }

    public CalendarsI getCalendarsHandler() throws CalFacadeException {
        if (this.calendarsHandler == null) {
            this.calendarsHandler = new Calendars(this);
            this.handlers.add((CalSvcDb)this.calendarsHandler);
        }
        return this.calendarsHandler;
    }

    public CalSuitesI getCalSuitesHandler() throws CalFacadeException {
        if (this.calSuitesHandler == null) {
            this.calSuitesHandler = new CalSuites(this);
            this.handlers.add((CalSvcDb)this.calSuitesHandler);
        }
        return this.calSuitesHandler;
    }

    public BwIndexer getIndexer() {
        return this.getIndexer(this.getPars().getPublicAdmin() || this.getPars().isGuest());
    }

    public BwIndexer getIndexer(boolean publick) {
        try {
            if (publick) {
                return this.getCal().getPublicIndexer();
            }
            return this.getCal().getIndexer(this.getPrincipal());
        }
        catch (CalFacadeException cfe) {
            throw new RuntimeException(cfe);
        }
    }

    public BwIndexer getIndexer(String principal) {
        try {
            BwPrincipal pr = principal == null ? this.getPrincipal() : this.getPrincipal(principal);
            return this.getCal().getIndexer(pr);
        }
        catch (CalFacadeException cfe) {
            throw new RuntimeException(cfe);
        }
    }

    public BwIndexer getIndexer(String principal, String indexRoot) {
        try {
            BwPrincipal pr = principal == null ? this.getPrincipal() : this.getPrincipal(principal);
            return this.getCal().getIndexer(pr, indexRoot);
        }
        catch (CalFacadeException cfe) {
            throw new RuntimeException(cfe);
        }
    }

    public NotificationsI getNotificationsHandler() throws CalFacadeException {
        if (this.notificationsHandler == null) {
            this.notificationsHandler = new Notifications(this);
            this.handlers.add((CalSvcDb)this.notificationsHandler);
        }
        return this.notificationsHandler;
    }

    public ResourcesI getResourcesHandler() throws CalFacadeException {
        if (this.resourcesHandler == null) {
            this.resourcesHandler = new ResourcesImpl(this);
            this.handlers.add((CalSvcDb)this.resourcesHandler);
        }
        return this.resourcesHandler;
    }

    public SchedulingI getScheduler() throws CalFacadeException {
        if (this.sched == null) {
            this.sched = new Scheduling(this);
            this.handlers.add((CalSvcDb)((Object)this.sched));
        }
        return this.sched;
    }

    public SharingI getSharingHandler() throws CalFacadeException {
        if (this.sharingHandler == null) {
            this.sharingHandler = new Sharing(this);
            this.handlers.add((CalSvcDb)this.sharingHandler);
        }
        return this.sharingHandler;
    }

    public SynchI getSynch() throws CalFacadeException {
        if (this.synch == null) {
            try {
                this.synch = new Synch(this, configs.getSynchConfig());
                this.handlers.add((CalSvcDb)this.synch);
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        }
        return this.synch;
    }

    public UsersI getUsersHandler() {
        if (this.usersHandler == null) {
            this.usersHandler = new Users(this);
            this.handlers.add((CalSvcDb)this.usersHandler);
        }
        return this.usersHandler;
    }

    public ViewsI getViewsHandler() throws CalFacadeException {
        if (this.viewsHandler == null) {
            this.viewsHandler = new Views(this);
            this.handlers.add((CalSvcDb)this.viewsHandler);
        }
        return this.viewsHandler;
    }

    public Directories getDirectories() throws CalFacadeException {
        if (this.isPublicAdmin()) {
            return this.getAdminDirectories();
        }
        return this.getUserDirectories();
    }

    public Directories getUserDirectories() throws CalFacadeException {
        if (this.userGroups != null) {
            return this.userGroups;
        }
        try {
            this.userGroups = (Directories)CalFacadeUtil.getObject((String)this.getSystemProperties().getUsergroupsClass(), Directories.class);
            this.userGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return this.userGroups;
    }

    public Directories getAdminDirectories() throws CalFacadeException {
        if (this.adminGroups != null) {
            return this.adminGroups;
        }
        try {
            this.adminGroups = (Directories)CalFacadeUtil.getObject((String)this.getSystemProperties().getAdmingroupsClass(), Directories.class);
            this.adminGroups.init((Directories.CallBack)this.getGroupsCallBack(), configs);
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return this.adminGroups;
    }

    public Categories getCategoriesHandler() {
        if (this.categoriesHandler == null) {
            this.categoriesHandler = new CategoriesImpl(this);
            this.categoriesHandler.init(this.pars.getAdminCanEditAllPublicCategories());
            this.handlers.add((CalSvcDb)this.categoriesHandler);
        }
        return this.categoriesHandler;
    }

    public Locations getLocationsHandler() {
        if (this.locationsHandler == null) {
            this.locationsHandler = new LocationsImpl(this);
            this.locationsHandler.init(this.pars.getAdminCanEditAllPublicLocations());
            this.handlers.add((CalSvcDb)this.locationsHandler);
        }
        return this.locationsHandler;
    }

    public Contacts getContactsHandler() {
        if (this.contactsHandler == null) {
            this.contactsHandler = new ContactsImpl(this);
            this.contactsHandler.init(this.pars.getAdminCanEditAllPublicContacts());
            this.handlers.add((CalSvcDb)this.contactsHandler);
        }
        return this.contactsHandler;
    }

    public BwPrincipal getPrincipal() {
        return this.principalInfo.getPrincipal();
    }

    public BwPrincipal getPrincipal(String href) throws CalFacadeException {
        return this.getCal().getPrincipal(href);
    }

    public UserAuth getUserAuth() throws CalFacadeException {
        if (this.userAuth != null) {
            return this.userAuth;
        }
        this.userAuth = (UserAuth)CalFacadeUtil.getObject((String)this.getSystemProperties().getUserauthClass(), UserAuth.class);
        this.userAuth.initialise((UserAuth.CallBack)this.getUserAuthCallBack());
        return this.userAuth;
    }

    public long getUserMaxEntitySize() throws CalFacadeException {
        long max = this.getPrefsHandler().get().getMaxEntitySize();
        if (max != 0L) {
            return max;
        }
        return this.getAuthProperties().getMaxUserEntitySize().intValue();
    }

    public BwPreferences getPreferences(String principalHref) throws CalFacadeException {
        return this.getCal().getPreferences(principalHref);
    }

    public void removeFromAllPrefs(BwShareableDbentity val) throws CalFacadeException {
        this.getCal().removeFromAllPrefs(val);
    }

    public BwGroup findGroup(String account, boolean admin) throws CalFacadeException {
        return this.getCal().findGroup(account, admin);
    }

    public void changeAccess(BwShareableDbentity ent, Collection<Ace> aces, boolean replaceAll) throws CalFacadeException {
        if (ent instanceof BwCalSuiteWrapper) {
            ent = ((BwCalSuiteWrapper)ent).fetchEntity();
        }
        this.getCal().changeAccess(ent, aces, replaceAll);
        if (ent instanceof BwCalendar) {
            BwCalendar col = (BwCalendar)ent;
            if (col.getCalType() == 5) {
                BwCalendar pendingInbox = this.getCalendarsHandler().getSpecial(13, true);
                if (pendingInbox == null) {
                    this.warn("Unable to update pending inbox access");
                } else {
                    this.getCal().changeAccess(pendingInbox, aces, replaceAll);
                }
            }
            ((Preferences)this.getPrefsHandler()).updateAdminPrefs(false, col, null, null, null);
        } else if (ent instanceof BwEventProperty) {
            ((Preferences)this.getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty)ent);
        }
    }

    public void defaultAccess(BwShareableDbentity ent, AceWho who) throws CalFacadeException {
        if (ent instanceof BwCalSuiteWrapper) {
            ent = ((BwCalSuiteWrapper)ent).fetchEntity();
        }
        this.getCal().defaultAccess(ent, who);
    }

    public Acl.CurrentAccess checkAccess(BwShareableDbentity ent, int desiredAccess, boolean returnResult) throws CalFacadeException {
        return this.getCal().checkAccess(ent, desiredAccess, returnResult);
    }

    public SynchReport getSynchReport(String path, String token, int limit, boolean recurse) throws CalFacadeException {
        BwCalendar col = this.getCalendarsHandler().get(path);
        if (col == null) {
            return null;
        }
        TreeSet<Object> items = new TreeSet<SynchReportItem>();
        String resToken = this.getSynchItems(col, path, token, items, recurse);
        SynchReport res = new SynchReport(items, resToken);
        if (limit > 0 && res.size() >= limit) {
            if (res.size() == limit) {
                return res;
            }
            items = new TreeSet();
            resToken = "";
            for (SynchReportItem item : res.getItems()) {
                if (item.getToken().compareTo(resToken) > 0) {
                    resToken = item.getToken();
                }
                items.add(item);
                if (items.size() != limit) continue;
                break;
            }
        }
        if (resToken.length() == 0) {
            resToken = Util.icalUTCTimestamp() + "-0000";
        }
        return new SynchReport(items, resToken);
    }

    private boolean canSync(BwCalendar col) {
        return col.getCalType() != 8;
    }

    public UpdateFromTimeZonesInfo updateFromTimeZones(String colHref, int limit, boolean checkOnly, UpdateFromTimeZonesInfo info) throws CalFacadeException {
        return this.tzstore.updateFromTimeZones(colHref, limit, checkOnly, info);
    }

    Calintf getCal(BwCalendar cal) throws CalFacadeException {
        return this.getCal();
    }

    Calintf getCal() throws CalFacadeException {
        if (this.cali != null) {
            return this.cali;
        }
        long start = System.currentTimeMillis();
        try {
            BwPrincipal authPrincipal;
            BwPrincipal currentPrincipal;
            long beforeGetIntf = System.currentTimeMillis() - start;
            this.cali = CalintfFactory.getIntf((Class)CalintfFactory.hibernateClass);
            long afterGetIntf = System.currentTimeMillis() - start;
            this.cali.open(this.pars.getWebMode(), this.pars.getForRestore(), this.pars.getIndexRebuild());
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: about to obtain calintf", (long)beforeGetIntf));
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: calintf obtained", (long)afterGetIntf));
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: intf opened", (long)(System.currentTimeMillis() - start)));
            this.cali.beginTransaction();
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: transaction started", (long)(System.currentTimeMillis() - start)));
            String runAsUser = this.pars.getUser();
            if (this.pars.getCalSuite() != null) {
                BwCalSuite cs = this.cali.getCalSuite(this.pars.getCalSuite());
                if (cs == null) {
                    this.error("******************************************************");
                    this.error("Unable to fetch calendar suite " + this.pars.getCalSuite());
                    this.error("Is the database correctly initialised?");
                    this.error("******************************************************");
                    throw new CalFacadeException("org.bedework.svci.unknown.calsuite", this.pars.getCalSuite());
                }
                this.getCalSuitesHandler().set(new BwCalSuiteWrapper(cs));
                if (!this.pars.getPublicAdmin()) {
                    runAsUser = cs.getGroup().getOwnerHref();
                }
            }
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: before get dirs", (long)(System.currentTimeMillis() - start)));
            Directories dir = this.getDirectories();
            String authenticatedUser = this.pars.getAuthUser();
            if (authenticatedUser != null) {
                String sv = authenticatedUser;
                if (dir.isPrincipal(authenticatedUser)) {
                    authenticatedUser = dir.accountFromPrincipal(authenticatedUser);
                }
                if (authenticatedUser == null) {
                    this.error("Failed with Authenticated user " + sv);
                    Calintf calintf = null;
                    return calintf;
                }
                if (authenticatedUser.endsWith("/")) {
                    this.getLogger().warn((Object)("Authenticated user " + authenticatedUser + " ends with \"/\""));
                }
            }
            this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: before user fetch", (long)(System.currentTimeMillis() - start)));
            Users users = (Users)this.getUsersHandler();
            if (runAsUser == null) {
                runAsUser = authenticatedUser;
            }
            PrivilegeSet maxAllowedPrivs = null;
            boolean subscriptionsOnly = this.getSystemProperties().getUserSubscriptionsOnly();
            boolean userMapHit = false;
            boolean addingUser = false;
            boolean addingRunAsUser = false;
            if (this.pars.getForRestore()) {
                this.authenticated = true;
                authPrincipal = currentPrincipal = dir.caladdrToPrincipal(this.pars.getAuthUser());
                subscriptionsOnly = false;
            } else if (authenticatedUser == null) {
                this.authenticated = false;
                currentPrincipal = unauthUsers.get(runAsUser);
                if (currentPrincipal == null) {
                    currentPrincipal = users.getUser(runAsUser);
                } else {
                    userMapHit = true;
                }
                if (currentPrincipal == null) {
                    currentPrincipal = BwPrincipal.makeUserPrincipal();
                }
                currentPrincipal.setUnauthenticated(true);
                if (!userMapHit) {
                    unauthUsers.put(runAsUser, currentPrincipal);
                }
                authPrincipal = currentPrincipal;
                maxAllowedPrivs = PrivilegeSet.readOnlyPrivileges;
            } else {
                this.authenticated = true;
                currentPrincipal = unauthUsers.get(authenticatedUser);
                if (currentPrincipal == null) {
                    currentPrincipal = users.getUser(authenticatedUser);
                } else {
                    userMapHit = true;
                }
                if (currentPrincipal == null) {
                    this.getLogger().debug((Object)("Add new user " + authenticatedUser));
                    currentPrincipal = this.getFakeUser(authenticatedUser);
                    addingUser = true;
                }
                authPrincipal = currentPrincipal;
                if (authenticatedUser.equals(runAsUser)) {
                    this.getLogger().debug((Object)("Authenticated user " + authenticatedUser + " logged on"));
                } else {
                    currentPrincipal = unauthUsers.get(runAsUser);
                    if (currentPrincipal == null) {
                        currentPrincipal = users.getUser(runAsUser);
                    } else {
                        userMapHit = true;
                    }
                    if (currentPrincipal == null) {
                        this.getLogger().debug((Object)("Add new run-as-user " + runAsUser));
                        currentPrincipal = this.getFakeUser(runAsUser);
                        addingRunAsUser = true;
                    }
                    this.getLogger().debug((Object)("Authenticated user " + authenticatedUser + " logged on - running as " + runAsUser));
                }
                if (!userMapHit && currentPrincipal != null) {
                    currentPrincipal.setGroups(dir.getAllGroups(currentPrincipal));
                    authUsers.put(currentPrincipal.getAccount(), currentPrincipal);
                }
                this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: after get Groups", (long)(System.currentTimeMillis() - start)));
                if (this.pars.getService()) {
                    subscriptionsOnly = false;
                } else {
                    BwPrincipalInfo bwpi = dir.getDirInfo(currentPrincipal);
                    currentPrincipal.setPrincipalInfo(bwpi);
                    if (this.pars.getPublicAdmin() || bwpi != null && bwpi.getHasFullAccess()) {
                        subscriptionsOnly = false;
                    }
                    this.postNotification((SysEventBase)SysEvent.makeTimedEvent((String)"Login: got Dirinfo", (long)(System.currentTimeMillis() - start)));
                }
            }
            this.principalInfo = new SvciPrincipalInfo(this, currentPrincipal, authPrincipal, maxAllowedPrivs, subscriptionsOnly);
            this.cali.init(this.pars.getLogId(), configs, this.principalInfo, null, this.pars.getPublicAdmin(), this.pars.getPublicSubmission(), this.pars.getSessionsless(), this.pars.getDontKill());
            if (addingUser) {
                this.addUser(authenticatedUser);
            }
            if (addingRunAsUser) {
                this.addUser(runAsUser);
            }
            if (!currentPrincipal.getUnauthenticated()) {
                if (this.pars.getService()) {
                    this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.SERVICE_USER_LOGIN, (AccessPrincipal)currentPrincipal, (long)(System.currentTimeMillis() - start)));
                } else if (!this.creating) {
                    users.logon(currentPrincipal);
                    this.postNotification((SysEventBase)SysEvent.makePrincipalEvent((SysEventBase.SysCode)SysEventBase.SysCode.USER_LOGIN, (AccessPrincipal)currentPrincipal, (long)(System.currentTimeMillis() - start)));
                }
            }
            if ((this.pars.getPublicAdmin() || this.pars.isGuest()) && this.debug) {
                this.trace("PublicAdmin: " + this.pars.getPublicAdmin() + " user: " + runAsUser);
            }
            Calintf calintf = this.cali;
            return calintf;
        }
        catch (CalFacadeException cfe) {
            this.error(cfe);
            throw cfe;
        }
        catch (Throwable t) {
            this.error(t);
            throw new CalFacadeException(t);
        }
        finally {
            if (this.cali != null) {
                this.cali.endTransaction();
                this.cali.close();
            }
        }
    }

    void initPrincipal(BwPrincipal p) throws CalFacadeException {
        this.getCal().addNewCalendars(p);
    }

    void pushPrincipal(BwPrincipal principal) throws CalFacadeException {
        BwPrincipal pr = this.getUsersHandler().getUser(principal.getPrincipalRef());
        if (pr == null) {
            pr = this.addUser(principal.getPrincipalRef());
        }
        ((SvciPrincipalInfo)this.principalInfo).pushPrincipal(pr);
        this.getCal().principalChanged();
    }

    void popPrincipal() throws CalFacadeException {
        ((SvciPrincipalInfo)this.principalInfo).popPrincipal();
        this.getCal().principalChanged();
    }

    BwPrincipal getFakeUser(String account) throws CalFacadeException {
        Users users = (Users)this.getUsersHandler();
        return users.initUserObject(account);
    }

    BwPrincipal addUser(String val) throws CalFacadeException {
        Users users = (Users)this.getUsersHandler();
        this.getCal().flush();
        try {
            users.createUser(val);
        }
        catch (CalFacadeException cfe) {
            if (cfe.getCause() instanceof ConstraintViolationException) {
                this.warn("ConstraintViolationException trying to create " + val);
            }
            this.rollbackTransaction();
            if (this.debug) {
                cfe.printStackTrace();
            }
            throw cfe;
        }
        catch (Throwable t) {
            this.rollbackTransaction();
            if (this.debug) {
                t.printStackTrace();
            }
            throw new CalFacadeException(t);
        }
        BwPrincipal principal = users.getUser(val);
        if (principal == null) {
            return null;
        }
        String caladdr = this.getDirectories().userToCaladdr(principal.getPrincipalRef());
        if (caladdr != null) {
            List<String> emails = Collections.singletonList(caladdr.substring("mailto:".length()));
            Notifications notify = (Notifications)this.getNotificationsHandler();
            notify.subscribe(principal, emails);
        }
        return principal;
    }

    private UserAuthCallBack getUserAuthCallBack() {
        if (this.uacb == null) {
            this.uacb = new UserAuthCallBack(this);
        }
        return (UserAuthCallBack)this.uacb;
    }

    private GroupsCallBack getGroupsCallBack() {
        if (this.gcb == null) {
            this.gcb = new GroupsCallBack(this);
        }
        return (GroupsCallBack)this.gcb;
    }

    private void fixUsers() {
        String auser;
        for (auser = this.pars.getAuthUser(); auser != null && auser.endsWith("/"); auser = auser.substring(0, auser.length() - 1)) {
        }
        this.pars.setAuthUser(auser);
    }

    private String getSynchItems(BwCalendar col, String vpath, String token, Set<SynchReportItem> items, boolean recurse) throws CalFacadeException {
        SynchReportItem sri;
        Events eventsH = (Events)this.getEventsHandler();
        ResourcesImpl resourcesH = (ResourcesImpl)this.getResourcesHandler();
        Calendars colsH = (Calendars)this.getCalendarsHandler();
        String newToken = "";
        BwCalendar resolvedCol = col;
        if (this.debug) {
            this.trace("sync token: " + token + " col: " + resolvedCol.getPath());
        }
        if (col.getTombstoned()) {
            return token;
        }
        if (col.getInternalAlias()) {
            resolvedCol = this.getCalendarsHandler().resolveAlias(col, true, false);
        }
        if (resolvedCol.getTombstoned()) {
            return token;
        }
        boolean eventsOnly = resolvedCol.getCollectionInfo().onlyCalEntities;
        Set<EventInfo> evs = eventsH.getSynchEvents(resolvedCol.getPath(), token);
        for (EventInfo eventInfo : evs) {
            if (!eventInfo.getEvent().getTombstoned().booleanValue() && !eventsH.isVisible(col, eventInfo.getEvent().getName())) continue;
            SynchReportItem sri2 = new SynchReportItem(vpath, eventInfo);
            items.add(sri2);
            if (sri2.getToken().compareTo(newToken) <= 0) continue;
            newToken = sri2.getToken();
        }
        if (!eventsOnly) {
            List<BwResource> ress = resourcesH.getSynchResources(resolvedCol.getPath(), token);
            for (BwResource r : ress) {
                SynchReportItem sri3 = new SynchReportItem(vpath, r);
                items.add(sri3);
                if (sri3.getToken().compareTo(newToken) <= 0) continue;
                newToken = sri3.getToken();
            }
        }
        TreeSet<SynchReportItem> colItems = new TreeSet<SynchReportItem>();
        Set<BwCalendar> set = colsH.getSynchCols(resolvedCol.getPath(), token);
        ArrayList<BwCalendar> aliases = new ArrayList<BwCalendar>();
        for (BwCalendar c : set) {
            int calType = c.getCalType();
            if (calType == 13) continue;
            if (token != null && calType == 7) {
                aliases.add(c);
                continue;
            }
            sri = new SynchReportItem(vpath, c, this.canSync(c));
            colItems.add(sri);
            items.add(sri);
            if (sri.getToken().compareTo(newToken) > 0) {
                newToken = sri.getToken();
            }
            if (!this.debug) continue;
            this.trace("     token=" + sri.getToken() + " for " + c.getPath());
        }
        if (!Util.isEmpty(aliases)) {
            for (BwCalendar c : aliases) {
                BwCalendar resolved = this.getCalendarsHandler().resolveAlias(c, true, false);
                if (resolved == null || c.getTombstoned() && !this.getCal().testSynchCol(c, token) || !this.getCal().testSynchCol(resolved, token)) continue;
                sri = new SynchReportItem(vpath, c, this.canSync(c), resolved.getLastmod().getTagValue());
                colItems.add(sri);
                items.add(sri);
                if (sri.getToken().compareTo(newToken) <= 0) continue;
                newToken = sri.getToken();
            }
        }
        if (!recurse) {
            return newToken;
        }
        if (Util.isEmpty(colItems)) {
            return newToken;
        }
        for (SynchReportItem sri4 : colItems) {
            if (!sri4.getCanSync()) continue;
            BwCalendar sricol = sri4.getCol();
            String t = this.getSynchItems(sricol, Util.buildPath((boolean)true, (String[])new String[]{vpath, "/", sricol.getName()}), token, items, true);
            if (t.compareTo(newToken) <= 0) continue;
            newToken = t;
        }
        return newToken;
    }

    void touchCalendar(BwCalendar col) throws CalFacadeException {
        this.getCal().touchCalendar(col);
    }

    PwEncryptionIntf getEncrypter() throws CalFacadeException {
        if (this.pwEncrypt != null) {
            return this.pwEncrypt;
        }
        try {
            String pwEncryptClass = "org.bedework.util.security.PwEncryptionDefault";
            this.pwEncrypt = (PwEncryptionIntf)CalFacadeUtil.getObject((String)pwEncryptClass, PwEncryptionIntf.class);
            String privKeys = null;
            String pubKeys = null;
            GenKeysMBean gk = (GenKeysMBean)MBeanUtil.getMBean(GenKeysMBean.class, (String)"org.bedework.util:service=BwGenKeys");
            if (gk != null) {
                privKeys = gk.getPrivKeyFileName();
                pubKeys = gk.getPublicKeyFileName();
            }
            if (privKeys == null) {
                throw new CalFacadeException("Unable to get keyfile locations. Is genkeys service installed?");
            }
            this.pwEncrypt.init(privKeys, pubKeys);
            return this.pwEncrypt;
        }
        catch (CalFacadeException cfe) {
            cfe.printStackTrace();
            throw cfe;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CalFacadeException(t);
        }
    }

    CalSvcIPars getPars() {
        return this.pars;
    }

    private boolean isPublicAdmin() throws CalFacadeException {
        return this.pars.getPublicAdmin();
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(((Object)((Object)this)).getClass());
        }
        return this.log;
    }

    private void logIt(String msg) {
        this.getLogger().info((Object)msg);
    }

    private void trace(String msg) {
        this.getLogger().debug((Object)msg);
    }

    private void warn(String msg) {
        this.getLogger().warn((Object)msg);
    }

    private void error(String msg) {
        this.getLogger().error((Object)msg);
    }

    private void error(Throwable t) {
        this.getLogger().error((Object)this, t);
    }

    static {
        try {
            configs = new CalSvcFactoryDefault().getSystemConfig();
            new SuggestParsers();
            new EventregParsers();
            new AdminNoteParsers();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        tzserverUri = null;
        synchlock = new Object();
        authUsers = new HashMap<String, BwPrincipal>();
        unauthUsers = new HashMap<String, BwPrincipal>();
    }

    private class IcalCallbackcb
    implements IcalCallback {
        private int strictness = 0;
        private final Boolean timezonesByReference;

        IcalCallbackcb(Boolean timezonesByReference) {
            this.timezonesByReference = timezonesByReference;
        }

        public void setStrictness(int val) throws CalFacadeException {
            this.strictness = val;
        }

        public int getStrictness() throws CalFacadeException {
            return this.strictness;
        }

        public BwPrincipal getPrincipal() throws CalFacadeException {
            return CalSvc.this.getPrincipal();
        }

        public BwPrincipal getOwner() throws CalFacadeException {
            if (CalSvc.this.isPublicAdmin()) {
                return CalSvc.this.getUsersHandler().getPublicUser();
            }
            return CalSvc.this.getPrincipal();
        }

        public String getCaladdr(String val) throws CalFacadeException {
            return CalSvc.this.getDirectories().userToCaladdr(val);
        }

        public BwCategory findCategory(BwString val) throws CalFacadeException {
            return (BwCategory)CalSvc.this.getCategoriesHandler().findPersistent(val);
        }

        public void addCategory(BwCategory val) throws CalFacadeException {
            CalSvc.this.getCategoriesHandler().add((BwEventProperty)val);
        }

        public BwContact getContact(String uid) throws CalFacadeException {
            return (BwContact)CalSvc.this.getContactsHandler().get(uid);
        }

        public BwContact findContact(BwString val) throws CalFacadeException {
            return (BwContact)CalSvc.this.getContactsHandler().findPersistent(val);
        }

        public void addContact(BwContact val) throws CalFacadeException {
            CalSvc.this.getContactsHandler().add((BwEventProperty)val);
        }

        public BwLocation getLocation(String uid) throws CalFacadeException {
            return (BwLocation)CalSvc.this.getLocationsHandler().get(uid);
        }

        public BwLocation getLocation(BwString address) throws CalFacadeException {
            return (BwLocation)CalSvc.this.getLocationsHandler().findPersistent(address);
        }

        public GetEntityResponse<BwLocation> fetchLocationByKey(String name, String val) {
            return CalSvc.this.getLocationsHandler().fetchLocationByKey(name, val);
        }

        public BwLocation findLocation(BwString address) throws CalFacadeException {
            BwLocation loc = BwLocation.makeLocation();
            loc.setAddress(address);
            return (BwLocation)CalSvc.this.getLocationsHandler().ensureExists((BwEventProperty)loc, (String)this.getOwner().getPrincipalRef()).entity;
        }

        public void addLocation(BwLocation val) throws CalFacadeException {
            CalSvc.this.getLocationsHandler().add((BwEventProperty)val);
        }

        public Collection getEvent(String colPath, String guid) throws CalFacadeException {
            return CalSvc.this.getEventsHandler().getByUid(colPath, guid, null, RecurringRetrievalMode.overrides);
        }

        public boolean getTimezonesByReference() throws CalFacadeException {
            if (this.timezonesByReference != null) {
                return this.timezonesByReference;
            }
            return CalSvc.this.getSystemProperties().getTimezonesByReference();
        }
    }

    class SvcSimpleFilterParser
    extends SimpleFilterParser {
        SvcSimpleFilterParser() {
        }

        public BwCalendar getCollection(String path) throws CalFacadeException {
            return CalSvc.this.getCalendarsHandler().get(path);
        }

        public BwCalendar resolveAlias(BwCalendar val, boolean resolveSubAlias) throws CalFacadeException {
            return CalSvc.this.getCalendarsHandler().resolveAlias(val, resolveSubAlias, false);
        }

        public Collection<BwCalendar> getChildren(BwCalendar col) throws CalFacadeException {
            return CalSvc.this.getCalendarsHandler().getChildren(col);
        }

        public BwCategory getCategoryByName(String name) throws CalFacadeException {
            return (BwCategory)CalSvc.this.getCategoriesHandler().find(new BwString(null, name));
        }

        public BwCategory getCategory(String uid) throws CalFacadeException {
            return (BwCategory)CalSvc.this.getCategoriesHandler().get(uid);
        }

        public BwView getView(String path) throws CalFacadeException {
            return CalSvc.this.getViewsHandler().find(path);
        }

        public Collection<BwCalendar> decomposeVirtualPath(String vpath) throws CalFacadeException {
            return CalSvc.this.getCalendarsHandler().decomposeVirtualPath(vpath);
        }

        public SimpleFilterParser getParser() throws CalFacadeException {
            return new SvcSimpleFilterParser();
        }
    }
}

