/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.bedework.access.Acl;
import org.bedework.calcorei.Calintf;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ical.BwIcalPropertyInfo;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calfacade.responses.Response;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calfacade.wrappers.CalendarWrapper;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvc.Events;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.UsersI;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Uid;
import org.bedework.util.security.PwEncryptionIntf;

public class CalSvcDb
extends Logged
implements Serializable {
    private CalSvc svci;
    private CalSvcIPars pars;

    public CalSvcDb(CalSvc svci) {
        this.setSvc(svci);
    }

    public void open() {
    }

    public void close() {
    }

    public static String getEncodedUuid() {
        return new String(Base64.encodeBase64((byte[])UUID.randomUUID().toString().getBytes()));
    }

    void touchCalendar(BwCalendar col) throws CalFacadeException {
        this.getSvc().touchCalendar(col);
    }

    protected Timestamp getCurrentTimestamp() throws CalFacadeException {
        return this.getSvc().getCurrentTimestamp();
    }

    protected BwPrincipal caladdrToPrincipal(String href) throws CalFacadeException {
        return this.getSvc().getDirectories().caladdrToPrincipal(href);
    }

    protected String principalToCaladdr(BwPrincipal p) throws CalFacadeException {
        return this.getSvc().getDirectories().principalToCaladdr(p);
    }

    protected void pushPrincipal(String href) throws CalFacadeException {
        BwPrincipal pr = this.caladdrToPrincipal(href);
        if (pr == null) {
            throw new CalFacadeException("org.bedework.exception.badrequest", "unknown principal");
        }
        this.getSvc().pushPrincipal(pr);
    }

    protected boolean pushPrincipalReturn(String href) throws CalFacadeException {
        BwPrincipal pr = this.caladdrToPrincipal(href);
        if (pr == null) {
            return false;
        }
        this.getSvc().pushPrincipal(pr);
        return true;
    }

    protected void pushPrincipal(BwPrincipal pr) throws CalFacadeException {
        this.getSvc().pushPrincipal(pr);
    }

    protected void popPrincipal() throws CalFacadeException {
        this.getSvc().popPrincipal();
    }

    protected PwEncryptionIntf getEncrypter() throws CalFacadeException {
        return this.getSvc().getEncrypter();
    }

    protected List<BwCalendar> findAlias(String val) throws CalFacadeException {
        return ((Calendars)this.getCols()).findUserAlias(val);
    }

    protected Collection<EventInfo> getEventsByUid(String colPath, String guid) throws CalFacadeException {
        Events events = (Events)this.getSvc().getEventsHandler();
        return events.getByUid(colPath, guid, null, RecurringRetrievalMode.overrides);
    }

    protected boolean deleteEvent(EventInfo ei, boolean scheduling, boolean sendSchedulingReply) throws CalFacadeException {
        Events events = (Events)this.getSvc().getEventsHandler();
        return events.delete(ei, scheduling, sendSchedulingReply);
    }

    protected BwCalendar getSpecialCalendar(BwPrincipal owner, int calType, boolean create, int access) throws CalFacadeException {
        return ((Calendars)this.getCols()).getSpecial(owner, calType, create, access);
    }

    public void postNotification(SysEvent ev) throws CalFacadeException {
        this.getSvc().postNotification((SysEventBase)ev);
    }

    protected Collection<EventInfo> getEvents(Collection<BwCalendar> cols, FilterBase filter, BwDateTime startDate, BwDateTime endDate, List<BwIcalPropertyInfo.BwIcalPropertyInfoEntry> retrieveList, RecurringRetrievalMode recurRetrieval, boolean freeBusy) throws CalFacadeException {
        Events events = (Events)this.getSvc().getEventsHandler();
        return events.getMatching(cols, filter, startDate, endDate, retrieveList, BwIndexer.DeletedState.noDeleted, recurRetrieval, freeBusy);
    }

    protected EventInfo getEvent(BwCalendar col, String name, String recurrenceId) throws CalFacadeException {
        return this.getSvc().getEventsHandler().get(col, name, recurrenceId, null);
    }

    protected CollectionAndName getCollectionAndName(String path) throws CalFacadeException {
        int end = path.endsWith("/") ? path.length() - 1 : path.length();
        int pos = path.substring(0, end).lastIndexOf("/");
        if (pos < 0) {
            throw new CalFacadeException("org.bedework.exception.badrequest");
        }
        CollectionAndName res = new CollectionAndName();
        res.name = path.substring(pos + 1, end);
        if (pos == 0) {
            res.coll = null;
        } else {
            res.coll = this.getCols().get(path.substring(0, pos));
            if (res.coll == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound");
            }
        }
        return res;
    }

    protected CalSvcIPars getPars() {
        return this.pars;
    }

    protected boolean isSuper() throws CalFacadeException {
        return this.pars.getPublicAdmin() && this.svci.getSuperUser();
    }

    protected boolean isGuest() {
        return this.pars.isGuest();
    }

    protected boolean isPublicAdmin() {
        return this.pars.getPublicAdmin();
    }

    protected BwPrincipal getPrincipal() {
        return this.svci.getPrincipal();
    }

    protected String getPrincipalHref() {
        return this.svci.getPrincipal().getPrincipalRef();
    }

    protected String getOwnerHref() throws CalFacadeException {
        if (this.getSvc().getPars().getPublicAdmin() || this.getPrincipal().getUnauthenticated()) {
            return this.getUsers().getPublicUser().getPrincipalRef();
        }
        return this.getPrincipal().getPrincipalRef();
    }

    public BwIndexer getIndexer() {
        return this.svci.getIndexer();
    }

    public BwIndexer getIndexer(boolean publick) {
        return this.svci.getIndexer(publick);
    }

    public BwIndexer getPublicIndexer() {
        return this.svci.getIndexer(true);
    }

    protected BwPrincipal getPrincipal(String href) throws CalFacadeException {
        return this.svci.getUsersHandler().getPrincipal(href);
    }

    protected PrincipalInfo getPrincipalInfo() throws CalFacadeException {
        return this.svci.getPrincipalInfo();
    }

    public void setSvc(CalSvcI svci) {
        this.svci = (CalSvc)svci;
        if (svci != null) {
            this.pars = this.svci.getPars();
        }
    }

    protected CalSvc getSvc() {
        return this.svci;
    }

    protected CalendarsI getCols() throws CalFacadeException {
        return this.svci.getCalendarsHandler();
    }

    protected NotificationsI getNotes() throws CalFacadeException {
        return this.svci.getNotificationsHandler();
    }

    protected ResourcesI getRess() throws CalFacadeException {
        return this.svci.getResourcesHandler();
    }

    protected UsersI getUsers() throws CalFacadeException {
        return this.svci.getUsersHandler();
    }

    protected Calintf getCal() throws CalFacadeException {
        return this.svci.getCal();
    }

    protected Calintf getCal(BwCalendar cal) throws CalFacadeException {
        return this.svci.getCal(cal);
    }

    protected BwPrincipal getPublicUser() {
        return this.getSvc().getUsersHandler().getPublicUser();
    }

    protected Acl.CurrentAccess checkAccess(BwShareableDbentity ent, int desiredAccess, boolean returnResult) throws CalFacadeException {
        return this.svci.checkAccess(ent, desiredAccess, returnResult);
    }

    protected void trace(String msg) {
        this.getLogger().debug((Object)("trace: " + msg));
    }

    protected void info(String msg) {
        this.getLogger().info((Object)msg);
    }

    protected void warn(String msg) {
        this.getLogger().warn((Object)msg);
    }

    protected void error(Throwable t) {
        this.getLogger().error((Object)this, t);
    }

    protected void error(String msg) {
        this.getLogger().error((Object)msg);
    }

    protected void assignGuid(BwEvent val) throws CalFacadeException {
        if (val == null) {
            return;
        }
        if (val.getName() != null && val.getUid() != null) {
            return;
        }
        String guidPrefix = "CAL-" + Uid.getUid();
        if (val.getName() == null) {
            val.setName(guidPrefix + ".ics");
        }
        if (val.getUid() != null) {
            return;
        }
        val.setUid(guidPrefix + this.getSvc().getSystemProperties().getSystemid());
    }

    protected void checkOwnerOrSuper(Object o) throws CalFacadeException {
        if (this.isGuest()) {
            throw new CalFacadeAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwOwnedDbentity)) {
            throw new CalFacadeAccessException();
        }
        BwOwnedDbentity ent = (BwOwnedDbentity)o;
        if (this.getPrincipal().getPrincipalRef().equals(ent.getOwnerHref())) {
            return;
        }
        throw new CalFacadeAccessException();
    }

    protected void setupSharableEntity(BwShareableDbentity entity, String ownerHref) throws CalFacadeException {
        if (entity.getCreatorHref() == null) {
            entity.setCreatorHref(ownerHref);
        }
        this.setupOwnedEntity((BwOwnedDbentity)entity, ownerHref);
    }

    protected void setupOwnedEntity(BwOwnedDbentity entity, String ownerHref) throws CalFacadeException {
        entity.setPublick(Boolean.valueOf(this.isPublicAdmin()));
        if (entity.getOwnerHref() == null) {
            if (entity.getPublick().booleanValue()) {
                entity.setOwnerHref(this.getPublicUser().getPrincipalRef());
            } else {
                entity.setOwnerHref(ownerHref);
            }
        }
    }

    protected BwPrincipal getEntityOwner(BwPrincipal owner) {
        if (this.isPublicAdmin()) {
            return this.getPublicUser();
        }
        return owner;
    }

    protected BasicSystemProperties getBasicSyspars() {
        return this.getSvc().getBasicSystemProperties();
    }

    protected AuthProperties getAuthpars() {
        return this.getSvc().getAuthProperties();
    }

    protected SystemProperties getSyspars() {
        return this.getSvc().getSystemProperties();
    }

    protected BwCalendar unwrap(BwCalendar val) throws CalFacadeException {
        if (val == null) {
            return null;
        }
        if (!(val instanceof CalendarWrapper)) {
            return val;
        }
        return ((CalendarWrapper)val).fetchEntity();
    }

    static boolean appendPublicOrOwnerTerm(StringBuilder sb, String entName, boolean publicEvents, boolean ignoreCreator) throws CalFacadeException {
        boolean all = publicEvents || ignoreCreator;
        boolean setUser = false;
        sb.append("(");
        if (!all) {
            sb.append("(");
        }
        sb.append(entName);
        sb.append(".publick=");
        sb.append(String.valueOf(publicEvents));
        if (!all) {
            sb.append(") and (");
            sb.append(entName);
            sb.append(".owner=:user");
            sb.append(")");
            setUser = true;
        }
        sb.append(")");
        return setUser;
    }

    private <T extends Response> T errorReturn(T resp, Throwable t) {
        return this.errorReturn(resp, t, Response.Status.failed);
    }

    private <T extends Response> T errorReturn(T resp, Throwable t, Response.Status st) {
        if (this.debug) {
            this.error(t);
        }
        return this.errorReturn(resp, t.getLocalizedMessage(), st);
    }

    private <T extends Response> T errorReturn(T resp, String msg, Response.Status st) {
        resp.setMessage(msg);
        resp.setStatus(st);
        return resp;
    }

    protected static class CollectionAndName {
        public BwCalendar coll;
        public String name;

        protected CollectionAndName() {
        }
    }
}

