/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.EventPropertiesImpl;
import org.bedework.calsvci.Contacts;
import org.bedework.util.calendar.PropertyIndex;

public class ContactsImpl
extends EventPropertiesImpl<BwContact>
implements Contacts {
    public ContactsImpl(CalSvc svci) {
        super(svci);
    }

    public void init(boolean adminCanEditAllPublic) {
        super.init(BwContact.class.getCanonicalName(), adminCanEditAllPublic);
    }

    @Override
    Collection<BwContact> fetchAllIndexed(boolean publick, String ownerHref) throws CalFacadeException {
        return this.filterDeleted(this.getIndexer(publick, ownerHref).fetchAllContacts());
    }

    @Override
    BwContact fetchIndexedByUid(String uid) throws CalFacadeException {
        return this.getIndexer().fetchContact(uid, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.UID});
    }

    @Override
    BwContact findPersistent(BwContact val, String ownerHref) throws CalFacadeException {
        return (BwContact)this.findPersistent(val.getFinderKeyValue(), ownerHref);
    }

    @Override
    public boolean exists(BwContact val) throws CalFacadeException {
        return this.findPersistent(val.getFinderKeyValue(), val.getOwnerHref()) != null;
    }

    public BwContact find(BwString val) throws CalFacadeException {
        return this.getIndexer().fetchContact(val.getValue(), new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.CN, PropertyIndex.PropertyInfoIndex.VALUE});
    }
}

