/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.bedework.access.PrivilegeDefs;
import org.bedework.calcorei.CoreEventPropertiesI;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.EventPropertiesReference;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.indexing.BwIndexer;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvci.EventProperties;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.misc.Util;

public abstract class EventPropertiesImpl<T extends BwEventProperty>
extends CalSvcDb
implements EventProperties<T>,
PrivilegeDefs {
    private static final FlushMap<String, BwIndexer> userIndexers = new FlushMap(300000L, 200);
    private final FlushMap<String, Collection<T>> cached = new FlushMap(300000L, 2000);
    private final FlushMap<String, T> cachedByUid = new FlushMap(300000L, 2000);
    private static BwIndexer publicIndexer;
    private Class<T> ourClass;
    private CoreEventPropertiesI<T> coreHdlr;
    private boolean adminCanEditAllPublic;
    private String lastChangeToken;

    abstract Collection<T> fetchAllIndexed(boolean var1, String var2) throws CalFacadeException;

    abstract T fetchIndexedByUid(String var1) throws CalFacadeException;

    abstract T findPersistent(T var1, String var2) throws CalFacadeException;

    abstract boolean exists(T var1) throws CalFacadeException;

    public EventPropertiesImpl(CalSvc svci) {
        super(svci);
    }

    public void init(String className, boolean adminCanEditAllPublic) {
        this.adminCanEditAllPublic = adminCanEditAllPublic;
        try {
            this.ourClass = Class.forName(className);
            this.coreHdlr = this.getCal().getEvPropsHandler(this.ourClass);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public Collection<T> getPublic() throws CalFacadeException {
        return this.get(true, null);
    }

    Collection<T> filterDeleted(Collection<T> ents) throws CalFacadeException {
        if (this.isSuper()) {
            return ents;
        }
        return ents.stream().filter(ent -> !"deleted".equals(ent.getStatus())).collect(Collectors.toList());
    }

    public Collection<T> get() throws CalFacadeException {
        return this.get(this.isPublicAdmin(), null);
    }

    public Collection<T> getEditable() throws CalFacadeException {
        if (!this.isPublicAdmin()) {
            return this.get(false, null);
        }
        if (this.isSuper() || this.adminCanEditAllPublic) {
            return this.getPublic();
        }
        return this.get(true, this.getPrincipal().getPrincipalRef());
    }

    public T get(String uid) throws CalFacadeException {
        T ent = this.getCachedByUid(uid);
        if (ent != null) {
            return ent;
        }
        ent = this.fetchIndexedByUid(uid);
        if (ent == null) {
            return null;
        }
        this.putCachedByUid(uid, ent);
        return ent;
    }

    public Collection<T> get(Collection<String> uids) throws CalFacadeException {
        ArrayList<T> ents = new ArrayList<T>();
        if (Util.isEmpty(uids)) {
            return ents;
        }
        for (String uid : uids) {
            T ent = this.get(uid);
            if (ent == null) continue;
            ents.add(this.get(uid));
        }
        return ents;
    }

    public T getPersistent(String uid) throws CalFacadeException {
        return (T)this.coreHdlr.get(uid);
    }

    public T findPersistent(BwString val) throws CalFacadeException {
        BwPrincipal owner = !this.isPublicAdmin() ? this.getPrincipal() : this.getPublicUser();
        return (T)this.coreHdlr.find(val, owner.getPrincipalRef());
    }

    public boolean add(T val) throws CalFacadeException {
        this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
        this.updateOK(val);
        if (this.exists(val)) {
            return false;
        }
        if (this.debug) {
            this.trace("Add " + val);
        }
        if (val.getCreatorHref() == null || val.getOwnerHref() == null) {
            throw new CalFacadeException("Owner and creator must be set");
        }
        this.getCal().saveOrUpdate(val);
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty)val);
        this.coreHdlr.checkUnique(val.getFinderKeyValue(), val.getOwnerHref());
        this.getIndexer(val.getPublick(), val.getOwnerHref()).indexEntity(val);
        Collection<T> ents = this.get();
        if (ents != null) {
            ents.add(val);
        }
        this.putCachedByUid(val.getUid(), val);
        return true;
    }

    public void update(T val) throws CalFacadeException {
        if (val.getCreatorHref() == null || val.getOwnerHref() == null) {
            throw new CalFacadeException("Owner and creator must be set");
        }
        if (this.check(val) == null) {
            throw new CalFacadeAccessException();
        }
        this.getCal().saveOrUpdate(val);
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(false, (BwEventProperty)val);
        this.coreHdlr.checkUnique(val.getFinderKeyValue(), val.getOwnerHref());
        this.getIndexer(val.getPublick(), val.getOwnerHref()).indexEntity(val);
        Collection<T> ents = this.get();
        if (ents != null) {
            ents.remove(val);
            ents.add(val);
        }
        this.putCachedByUid(val.getUid(), val);
    }

    public int delete(T val) throws CalFacadeException {
        T ent = val;
        if (val.unsaved()) {
            ent = this.getPersistent(val.getUid());
        }
        this.deleteOK(ent);
        if (this.coreHdlr.getRefsCount(ent) != 0L) {
            return 2;
        }
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(true, (BwEventProperty)ent);
        this.coreHdlr.deleteProp(ent);
        this.getIndexer(ent.getPublick(), ent.getOwnerHref()).unindexEntity(ent);
        Collection<T> ents = this.get();
        if (ents != null) {
            ents.remove(ent);
        }
        this.removeCachedByUid(ent.getUid());
        return 0;
    }

    public Collection<EventPropertiesReference> getRefs(T val) throws CalFacadeException {
        T persistent = this.getPersistent(val.getUid());
        if (persistent == null) {
            return null;
        }
        return this.coreHdlr.getRefs(persistent);
    }

    public EventProperties.EnsureEntityExistsResult<T> ensureExists(T val, String ownerHref) throws CalFacadeException {
        EventProperties.EnsureEntityExistsResult eeer = new EventProperties.EnsureEntityExistsResult();
        if (!val.unsaved()) {
            eeer.entity = val;
            return eeer;
        }
        String oh = ownerHref == null ? this.getPrincipal().getPrincipalRef() : ownerHref;
        eeer.entity = this.findPersistent(val, oh);
        if (eeer.entity != null) {
            return eeer;
        }
        this.setupSharableEntity((BwShareableDbentity)val, ownerHref);
        eeer.added = this.add(val);
        eeer.entity = val;
        return eeer;
    }

    public int reindex(BwIndexer indexer) throws CalFacadeException {
        BwPrincipal owner = !this.isPublicAdmin() ? this.getPrincipal() : this.getPublicUser();
        Collection ents = this.coreHdlr.getAll(owner.getPrincipalRef());
        if (Util.isEmpty((Collection)ents)) {
            return 0;
        }
        for (BwEventProperty ent : ents) {
            indexer.indexEntity((Object)ent);
        }
        return ents.size();
    }

    protected BwIndexer getIndexer(boolean getPublic, String ownerHref) throws CalFacadeException {
        boolean publick;
        String href = this.checkHref(ownerHref);
        boolean bl = publick = getPublic || this.isGuest() || this.isPublicAdmin();
        if (publick) {
            if (publicIndexer == null) {
                publicIndexer = this.getSvc().getIndexer(true);
            }
            return publicIndexer;
        }
        BwIndexer idx = (BwIndexer)userIndexers.get((Object)href);
        if (idx != null) {
            return idx;
        }
        idx = this.getSvc().getIndexer(href);
        userIndexers.put((Object)href, (Object)idx);
        return idx;
    }

    protected boolean indexChanged() throws CalFacadeException {
        String token = this.getIndexer().currentChangeToken();
        boolean changed = this.lastChangeToken == null || !this.lastChangeToken.equals(token);
        this.lastChangeToken = token;
        return changed;
    }

    protected Collection<T> getCached(String ownerHref) throws CalFacadeException {
        this.checkChache();
        return (Collection)this.cached.get((Object)ownerHref);
    }

    protected void putCached(String ownerHref, Collection<T> vals) throws CalFacadeException {
        this.cached.put((Object)ownerHref, vals);
    }

    protected void removeCached(String ownerHref) throws CalFacadeException {
        this.cached.remove((Object)ownerHref);
    }

    protected T getCachedByUid(String uid) throws CalFacadeException {
        this.checkChache();
        return (T)((BwEventProperty)this.cachedByUid.get((Object)uid));
    }

    protected void putCachedByUid(String uid, T val) throws CalFacadeException {
        this.cachedByUid.put((Object)uid, val);
    }

    protected void removeCachedByUid(String uid) throws CalFacadeException {
        this.cachedByUid.remove((Object)uid);
    }

    protected T findPersistent(BwString val, String ownerHref) throws CalFacadeException {
        return (T)this.coreHdlr.find(val, ownerHref);
    }

    private void checkChache() throws CalFacadeException {
        if (this.indexChanged()) {
            this.cached.clear();
            this.cachedByUid.clear();
        }
    }

    private Collection<T> get(boolean publick, String creatorHref) throws CalFacadeException {
        String ownerHref = publick ? this.getPublicUser().getPrincipalRef() : this.getPrincipal().getPrincipalRef();
        Collection<T> ents = this.getCached(ownerHref);
        if (ents == null) {
            ents = this.fetchAllIndexed(publick, ownerHref);
            if (Util.isEmpty(ents)) {
                return new ArrayList();
            }
            this.putCached(ownerHref, ents);
        }
        for (BwEventProperty ent : ents) {
            this.putCachedByUid(ent.getUid(), ent);
        }
        if (creatorHref == null) {
            return this.filterDeleted(ents);
        }
        ArrayList<BwEventProperty> someEnts = new ArrayList<BwEventProperty>();
        for (BwEventProperty ent : ents) {
            if (!ent.getCreatorHref().equals(creatorHref)) continue;
            someEnts.add(ent);
        }
        return this.filterDeleted(someEnts);
    }

    private String checkHref(String ownerHref) throws CalFacadeException {
        if (ownerHref != null) {
            return ownerHref;
        }
        return this.getSvc().getUsersHandler().getPublicUser().getPrincipalRef();
    }

    private T check(T ent) throws CalFacadeException {
        if (ent == null) {
            return null;
        }
        return ent;
    }

    private void deleteOK(T o) throws CalFacadeException {
        if (o == null) {
            return;
        }
        if (this.isGuest()) {
            throw new CalFacadeAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwShareableDbentity)) {
            throw new CalFacadeAccessException();
        }
        if (!this.isPublicAdmin()) {
            this.getSvc().checkAccess((BwShareableDbentity)o, 14, false);
            return;
        }
        T ent = o;
        if (this.adminCanEditAllPublic || ent.getCreatorHref().equals(this.getPrincipal().getPrincipalRef())) {
            return;
        }
        throw new CalFacadeAccessException();
    }

    private void updateOK(Object o) throws CalFacadeException {
        if (this.isGuest()) {
            throw new CalFacadeAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwShareableDbentity)) {
            throw new CalFacadeAccessException();
        }
        if (!this.isPublicAdmin()) {
            return;
        }
        BwShareableDbentity ent = (BwShareableDbentity)o;
        if (this.adminCanEditAllPublic || ent.getCreatorHref().equals(this.getPrincipal().getPrincipalRef())) {
            return;
        }
        throw new CalFacadeAccessException();
    }
}

