/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.responses.GetEntityResponse;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.EventPropertiesImpl;
import org.bedework.calsvci.Locations;
import org.bedework.util.calendar.PropertyIndex;

public class LocationsImpl
extends EventPropertiesImpl<BwLocation>
implements Locations {
    public LocationsImpl(CalSvc svci) {
        super(svci);
    }

    public void init(boolean adminCanEditAllPublic) {
        super.init(BwLocation.class.getCanonicalName(), adminCanEditAllPublic);
    }

    public GetEntityResponse<BwLocation> fetchLocationByKey(String keyName, String keyVal) {
        return this.getIndexer().fetchLocationByKey(keyName, keyVal);
    }

    @Override
    Collection<BwLocation> fetchAllIndexed(boolean publick, String ownerHref) throws CalFacadeException {
        return this.filterDeleted(this.getIndexer(publick, ownerHref).fetchAllLocations());
    }

    @Override
    BwLocation fetchIndexedByUid(String uid) throws CalFacadeException {
        return this.getIndexer().fetchLocation(uid, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.UID});
    }

    @Override
    BwLocation findPersistent(BwLocation val, String ownerHref) throws CalFacadeException {
        return (BwLocation)this.findPersistent(val.getAddress(), ownerHref);
    }

    @Override
    public boolean exists(BwLocation val) throws CalFacadeException {
        return this.findPersistent(val.getFinderKeyValue(), val.getOwnerHref()) != null;
    }

    public BwLocation find(BwString val) throws CalFacadeException {
        return this.getIndexer().fetchLocation(val.getValue(), new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.ADDRESS, PropertyIndex.PropertyInfoIndex.VALUE});
    }
}

