/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.Collections;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwContact;
import org.bedework.calfacade.BwEventProperty;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.prefs.BwAuthUserPrefs;
import org.bedework.calfacade.svc.prefs.CalendarPref;
import org.bedework.calfacade.svc.prefs.CategoryPref;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.PreferencesI;
import org.bedework.util.misc.Util;

class Preferences
extends CalSvcDb
implements PreferencesI {
    private BwPreferences prefs;

    Preferences(CalSvc svci) {
        super(svci);
    }

    @Override
    public void open() {
        super.open();
        this.prefs = null;
    }

    @Override
    public void close() {
        super.close();
        this.prefs = null;
    }

    public BwPreferences get() throws CalFacadeException {
        if (this.prefs != null && (this.prefs.getOwnerHref() == null ? this.getPrincipal().getUnauthenticated() : this.prefs.getOwnerHref().equals(this.getPrincipal().getPrincipalRef()))) {
            return this.prefs;
        }
        this.prefs = this.fetch();
        if (this.prefs == null) {
            if (this.getPrincipal().getUnauthenticated()) {
                this.prefs = new BwPreferences();
                return this.prefs;
            }
            this.getSvc().getUsersHandler().initPrincipal(this.getPrincipal());
            this.prefs = this.fetch();
        }
        if (this.prefs == null) {
            throw new CalFacadeException("org.bedework.unable.to.initialise", this.getPrincipal().getAccount());
        }
        return this.prefs;
    }

    public BwPreferences get(BwPrincipal principal) throws CalFacadeException {
        return this.fetch(principal);
    }

    public void update(BwPreferences val) throws CalFacadeException {
        this.getCal().saveOrUpdate((BwUnversionedDbentity)val);
    }

    public void delete(BwPreferences val) throws CalFacadeException {
        this.getCal().delete((BwUnversionedDbentity)val);
    }

    public void updateAdminPrefs(boolean remove, BwEventProperty ent) throws CalFacadeException {
        if (ent instanceof BwCategory) {
            this.updateAdminPrefs(remove, null, Collections.singletonList((BwCategory)ent), null, null);
        } else if (ent instanceof BwLocation) {
            this.updateAdminPrefs(remove, null, null, (BwLocation)ent, null);
        } else if (ent instanceof BwContact) {
            this.updateAdminPrefs(remove, null, null, null, (BwContact)ent);
        }
    }

    public void updateAdminPrefs(boolean remove, BwCalendar cal, Collection<BwCategory> cats, BwLocation loc, BwContact ctct) throws CalFacadeException {
        CalendarPref p;
        BwAuthUserPrefs prefs = null;
        boolean update = false;
        BwAuthUser au = null;
        if (this.getPars().getPublicAdmin() && (au = this.getSvc().getUserAuth().getUser(this.getPars().getAuthUser())) != null) {
            prefs = au.getPrefs();
        }
        if (prefs == null) {
            return;
        }
        if (cal != null) {
            if (!remove) {
                if (cal.getCalendarCollection() && (p = prefs.getCalendarPrefs()).getAutoAdd() && p.add((Object)cal)) {
                    update = true;
                }
            } else {
                this.getSvc().removeFromAllPrefs((BwShareableDbentity)cal);
            }
        }
        if (!Util.isEmpty(cats)) {
            for (BwCategory cat : cats) {
                if (!remove) {
                    CategoryPref p2 = prefs.getCategoryPrefs();
                    if (!p2.getAutoAdd() || !p2.add((Object)cat)) continue;
                    update = true;
                    continue;
                }
                this.getSvc().removeFromAllPrefs((BwShareableDbentity)cat);
            }
        }
        if (loc != null) {
            if (!remove) {
                p = prefs.getLocationPrefs();
                if (p.getAutoAdd() && p.add((Object)loc)) {
                    update = true;
                }
            } else {
                this.getSvc().removeFromAllPrefs((BwShareableDbentity)loc);
            }
        }
        if (ctct != null) {
            if (!remove) {
                p = prefs.getContactPrefs();
                if (p.getAutoAdd() && p.add((Object)ctct)) {
                    update = true;
                }
            } else {
                this.getSvc().removeFromAllPrefs((BwShareableDbentity)ctct);
            }
        }
        if (update && this.getPars().getPublicAdmin()) {
            this.getSvc().getUserAuth().updateUser(au);
        }
    }

    public String getAttachmentsPath() throws CalFacadeException {
        String path = this.get().getAttachmentsPath();
        if (path == null) {
            path = Util.buildPath((boolean)false, (String[])new String[]{this.getSvc().getCalendarsHandler().getHomePath(), "/", "attachments"});
            this.get().setAttachmentsPath(path);
            this.update(this.get());
        }
        return path;
    }

    public void setAttachmentsPath(String val) throws CalFacadeException {
        if (val == null) {
            return;
        }
        this.get().setAttachmentsPath(val);
        this.update(this.get());
    }

    private BwPreferences fetch() throws CalFacadeException {
        return this.fetch(this.getPrincipal());
    }

    private BwPreferences fetch(BwPrincipal principal) throws CalFacadeException {
        BwPreferences prefs = this.getSvc().getPreferences(principal.getPrincipalRef());
        BwPrincipalInfo pinfo = principal.getPrincipalInfo();
        if (pinfo == null) {
            return prefs;
        }
        if (this.getSvc().getDirectories().mergePreferences(prefs, pinfo)) {
            this.update(prefs);
        }
        return prefs;
    }
}

