/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.List;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.BwResourceContent;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeForbidden;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.ResourcesI;

class ResourcesImpl
extends CalSvcDb
implements ResourcesI {
    ResourcesImpl(CalSvc svci) {
        super(svci);
    }

    public boolean saveNotification(String path, BwResource val) throws CalFacadeException {
        return this.save(path, val, true, true);
    }

    public boolean save(String path, BwResource val, boolean returnIfExists) throws CalFacadeException {
        return this.save(path, val, false, returnIfExists);
    }

    public BwResource get(String path) throws CalFacadeException {
        CalSvcDb.CollectionAndName cn = this.getCollectionAndName(path);
        return this.getCal().getResource(cn.name, cn.coll, 1);
    }

    public void getContent(BwResource val) throws CalFacadeException {
        this.getCal().getResourceContent(val);
    }

    public List<BwResource> getAll(String path) throws CalFacadeException {
        return this.getCal().getAllResources(path, false, null);
    }

    public List<BwResource> get(String path, int start, int count) throws CalFacadeException {
        return this.getCal().getNResources(path, start, count);
    }

    public void update(BwResource val, boolean updateContent) throws CalFacadeException {
        this.checkAccess((BwShareableDbentity)val, 5, false);
        try {
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().saveOrUpdate((BwUnversionedDbentity)val);
            if (updateContent && val.getContent() != null) {
                BwResourceContent rc = val.getContent();
                rc.setColPath(val.getColPath());
                rc.setName(val.getName());
                this.getCal().saveOrUpdate((BwUnversionedDbentity)rc);
            }
            this.touchCalendar(this.getCols().get(val.getColPath()));
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
    }

    public void delete(String path) throws CalFacadeException {
        BwResource r;
        CalSvcDb.CollectionAndName cn;
        block5: {
            cn = this.getCollectionAndName(path);
            r = this.getCal().getResource(cn.name, cn.coll, 14);
            if (r == null) {
                throw new CalFacadeException("org.bedework.exception.unknown.resource", path);
            }
            try {
                this.getContent(r);
            }
            catch (CalFacadeException cfe) {
                if (cfe.getMessage().equals("org.bedework.exception.missing.resource.content")) break block5;
                this.getSvc().rollbackTransaction();
                throw cfe;
            }
        }
        BwResource tr = this.getCal().getResource(cn.name + "(--TOMBSTONED--)", cn.coll, 14);
        if (tr != null) {
            this.getCal().delete((BwUnversionedDbentity)tr);
        }
        BwResourceContent rc = r.getContent();
        r.setContent(null);
        r.tombstone();
        r.updateLastmod(this.getCurrentTimestamp());
        this.getCal().saveOrUpdate((BwUnversionedDbentity)r);
        if (rc != null) {
            this.getCal().delete((BwUnversionedDbentity)rc);
        }
        this.touchCalendar(cn.coll);
    }

    public boolean copyMove(BwResource val, String to, String name, boolean copy, boolean overwrite) throws CalFacadeException {
        try {
            BwResourceContent rc;
            this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
            BwCalendar collTo = this.getCols().get(to);
            if (collTo == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound", to);
            }
            if (collTo.getCalType() != 0) {
                throw new CalFacadeException("org.bedework.exception.badrequest", to);
            }
            int access = copy ? 5 : 9;
            this.checkAccess((BwShareableDbentity)collTo, access, false);
            BwResource r = this.getCal().getResource(val.getName(), collTo, access);
            boolean createdNew = false;
            this.getContent(val);
            if (r != null) {
                if (!overwrite) {
                    throw new CalFacadeException("org.bedework.exception.targetexists", val.getName());
                }
                this.getContent(r);
                r.setContentType(val.getContentType());
                BwResourceContent rc2 = r.getContent();
                BwResourceContent toRc = val.getContent();
                r.setContentLength(toRc.getValue().length());
                r.updateLastmod(this.getCurrentTimestamp());
                rc2.setValue(val.getContent().getValue());
                this.getCal().saveOrUpdate((BwUnversionedDbentity)r);
                this.getCal().saveOrUpdate((BwUnversionedDbentity)rc2);
            } else {
                r = new BwResource();
                this.setupSharableEntity((BwShareableDbentity)r, this.getPrincipal().getPrincipalRef());
                r.setName(name);
                r.setColPath(collTo.getPath());
                r.setContentType(val.getContentType());
                r.setContentLength(val.getContentLength());
                r.updateLastmod(this.getCurrentTimestamp());
                this.getCal().saveOrUpdate((BwUnversionedDbentity)r);
                BwResourceContent fromRc = val.getContent();
                rc = new BwResourceContent();
                rc.setColPath(collTo.getPath());
                rc.setName(val.getName());
                rc.setValue(fromRc.getValue());
                this.getCal().saveOrUpdate((BwUnversionedDbentity)rc);
                createdNew = true;
            }
            if (!copy) {
                BwCalendar collFrom = this.getCols().get(val.getColPath());
                this.checkAccess((BwShareableDbentity)collFrom, 14, false);
                rc = val.getContent();
                this.getCal().delete((BwUnversionedDbentity)rc);
                BwResource tr = this.getCal().getResource(val.getName() + "(--TOMBSTONED--)", collFrom, 14);
                if (tr != null) {
                    this.getCal().delete((BwUnversionedDbentity)tr);
                }
                val.setContent(null);
                val.tombstone();
                val.updateLastmod(this.getCurrentTimestamp());
                this.getCal().saveOrUpdate((BwUnversionedDbentity)val);
                this.touchCalendar(collFrom);
            }
            this.touchCalendar(collTo);
            return createdNew;
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            throw new CalFacadeException(t);
        }
    }

    List<BwResource> getSynchResources(String path, String lastmod) throws CalFacadeException {
        return this.getCal().getAllResources(path, true, lastmod);
    }

    private boolean save(String path, BwResource val, boolean forNotification, boolean returnIfExists) throws CalFacadeException {
        try {
            BwResource r;
            BwCalendar coll = this.getCols().get(path);
            if (coll == null) {
                throw new CalFacadeException("org.bedework.exception.calendarnotfound", path);
            }
            if (forNotification) {
                if (coll.getCalType() != 10) {
                    throw new CalFacadeException("org.bedework.exception.badrequest", path);
                }
            } else if (this.getPrincipalInfo().getSubscriptionsOnly()) {
                throw new CalFacadeForbidden("User has read only access");
            }
            if ((r = this.getCal().getResource(val.getName(), coll, 25)) != null) {
                if (returnIfExists) {
                    return false;
                }
                throw new CalFacadeException("org.bedework.exception.duplicate.resource", val.getName());
            }
            BwResourceContent rc = val.getContent();
            if (rc == null) {
                throw new CalFacadeException("org.bedework.exception.missing.resource.content");
            }
            this.setupSharableEntity((BwShareableDbentity)val, this.getPrincipal().getPrincipalRef());
            val.setColPath(path);
            if (coll.getCalType() == 1 || coll.getCalType() == 8) {
                throw new CalFacadeException("org.bedework.exception.badrequest", path);
            }
            this.checkAccess((BwShareableDbentity)coll, 9, false);
            val.updateLastmod(this.getCurrentTimestamp());
            this.getCal().add((BwUnversionedDbentity)val);
            rc.setColPath(val.getColPath());
            rc.setName(val.getName());
            this.getCal().add((BwUnversionedDbentity)rc);
            this.touchCalendar(coll);
            return true;
        }
        catch (CalFacadeException cfe) {
            this.getSvc().rollbackTransaction();
            throw cfe;
        }
    }
}

