/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.DtStamp;
import org.bedework.access.AccessException;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.Acl;
import org.bedework.access.Privilege;
import org.bedework.access.Privileges;
import org.bedework.caldav.util.notifications.BaseNotificationType;
import org.bedework.caldav.util.notifications.NotificationType;
import org.bedework.caldav.util.sharing.AccessType;
import org.bedework.caldav.util.sharing.InviteNotificationType;
import org.bedework.caldav.util.sharing.InviteReplyType;
import org.bedework.caldav.util.sharing.InviteType;
import org.bedework.caldav.util.sharing.OrganizerType;
import org.bedework.caldav.util.sharing.RemoveType;
import org.bedework.caldav.util.sharing.SetType;
import org.bedework.caldav.util.sharing.ShareResultType;
import org.bedework.caldav.util.sharing.ShareType;
import org.bedework.caldav.util.sharing.UserType;
import org.bedework.caldav.util.sharing.parse.Parser;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.exc.CalFacadeForbidden;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Calendars;
import org.bedework.calsvc.Notifications;
import org.bedework.calsvci.NotificationsI;
import org.bedework.calsvci.SharingI;
import org.bedework.util.misc.Uid;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.tagdefs.AppleServerTags;
import org.bedework.util.xml.tagdefs.NamespaceAbbrevs;
import org.bedework.webdav.servlet.shared.WebdavException;

public class Sharing
extends CalSvcDb
implements SharingI {
    private static final QName removeStatus = Parser.inviteDeletedTag;
    private static final QName declineStatus = Parser.inviteDeclinedTag;
    private static final QName noresponseStatus = Parser.inviteNoresponseTag;
    private static final Privilege allPriv = Privileges.makePriv((int)0);
    private static final Privilege bindPriv = Privileges.makePriv((int)9);
    private static final Privilege readPriv = Privileges.makePriv((int)1);
    private static final Privilege unbindPriv = Privileges.makePriv((int)14);
    private static final Privilege write = Privileges.makePriv((int)5);
    private static final Privilege readFreeBusyPriv = Privileges.makePriv((int)4);
    private static final Privilege schedulePriv = Privileges.makePriv((int)10);
    private static final Privilege scheduleDeliverPriv = Privileges.makePriv((int)16);
    private static final Collection<Privilege> allPrivs = new ArrayList<Privilege>();
    private static final Collection<Privilege> readPrivs = new ArrayList<Privilege>();
    private static final Collection<Privilege> readWritePrivs = new ArrayList<Privilege>();

    Sharing(CalSvc svci) {
        super(svci);
    }

    public ShareResultType share(String principalHref, BwCalendar col, ShareType share) throws CalFacadeException {
        this.pushPrincipal(principalHref);
        try {
            ShareResultType shareResultType = this.getSvc().getSharingHandler().share(col, share);
            return shareResultType;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            this.popPrincipal();
        }
    }

    public ShareResultType share(BwCalendar col, ShareType share) throws CalFacadeException {
        InviteNotificationType n;
        if (!col.getCanAlias()) {
            throw new CalFacadeForbidden("Cannot share");
        }
        ShareResultType sr = new ShareResultType();
        ArrayList<String> removePrincipalHrefs = new ArrayList<String>();
        ArrayList<AddPrincipal> addPrincipals = new ArrayList<AddPrincipal>();
        String calAddr = this.principalToCaladdr(this.getPrincipal());
        InviteType invite = this.getInviteStatus(col);
        if (invite.getOrganizer() == null) {
            OrganizerType org = new OrganizerType();
            org.setHref(calAddr);
            invite.setOrganizer(org);
        }
        ArrayList<InviteNotificationType> notifications = new ArrayList<InviteNotificationType>();
        boolean addedSharee = false;
        boolean removedSharee = false;
        for (RemoveType rem : share.getRemove()) {
            n = this.doRemove(col, rem, calAddr, invite);
            if (n != null) {
                removedSharee = true;
                if (n.getPreviousStatus() != null && !n.getPreviousStatus().equals(declineStatus)) {
                    notifications.add(n);
                }
                sr.addGood(rem.getHref());
                removePrincipalHrefs.add(rem.getHref());
                continue;
            }
            sr.addBad(rem.getHref());
        }
        for (Object set : share.getSet()) {
            n = this.doSet(col, (SetType)set, addPrincipals, calAddr, invite);
            if (n != null) {
                addedSharee = true;
                notifications.add(n);
                sr.addGood(set.getHref());
                continue;
            }
            sr.addBad(set.getHref());
        }
        if (!addedSharee && !removedSharee) {
            return sr;
        }
        Notifications notify = (Notifications)this.getSvc().getNotificationsHandler();
        block8: for (InviteNotificationType in : notifications) {
            Sharee sh = this.getSharee(in.getHref());
            boolean remove = in.getInviteStatus().equals(removeStatus);
            List<NotificationType> notes = notify.getMatching(in.getHref(), AppleServerTags.inviteNotification);
            if (!Util.isEmpty(notes)) {
                for (NotificationType n2 : notes) {
                    InviteNotificationType nin = (InviteNotificationType)n2.getNotification();
                    if (!nin.getHostUrl().equals(in.getHostUrl())) continue;
                    if (remove) {
                        if (!nin.getInviteStatus().equals(noresponseStatus)) continue;
                        notify.remove(sh.pr, n2);
                        continue block8;
                    }
                    notify.remove(sh.pr, n2);
                }
            }
            NotificationType note = new NotificationType();
            note.setDtstamp(new DtStamp(new DateTime(true)).getValue());
            note.setNotification((BaseNotificationType)in);
            notify.send(sh.pr, note);
            QName qn = new QName(AppleServerTags.inviteNotification.getNamespaceURI(), AppleServerTags.inviteNotification.getLocalPart() + in.getUid());
            try {
                col.setProperty(NamespaceAbbrevs.prefixed((QName)qn), in.toXml());
            }
            catch (CalFacadeException cfe) {
                throw cfe;
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        }
        if (addedSharee && !col.getShared()) {
            col.setShared(true);
        }
        try {
            col.setQproperty(AppleServerTags.invite, invite.toXml());
            this.getCols().update(col);
            for (String principalHref : removePrincipalHrefs) {
                this.removeAccess(col, principalHref);
            }
            for (AddPrincipal ap : addPrincipals) {
                this.setAccess(col, ap);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        return sr;
    }

    public SharingI.ReplyResult reply(BwCalendar col, InviteReplyType reply) throws CalFacadeException {
        BwCalendar home = this.getCols().getHome();
        if (!home.getPath().equals(col.getPath())) {
            throw new CalFacadeForbidden("Not calendar home");
        }
        BwCalendar sharerCol = this.getCols().get(Util.buildPath((boolean)false, (String[])new String[]{reply.getHostUrl()}));
        if (sharerCol == null) {
            throw new CalFacadeForbidden("Bad hosturl or no access");
        }
        Holder access = new Holder();
        if (!this.updateSharingStatus(sharerCol.getOwnerHref(), sharerCol.getPath(), reply, (Holder<AccessType>)access)) {
            return null;
        }
        AccessType at = (AccessType)access.value;
        boolean sharedWritable = at != null && at.testReadWrite();
        List<BwCalendar> aliases = this.findAlias(sharerCol.getPath());
        if (!Util.isEmpty(aliases)) {
            BwCalendar alias = aliases.get(0);
            alias.setSharedWritable(sharedWritable);
            this.getCols().update(alias);
            return SharingI.ReplyResult.success((String)alias.getPath());
        }
        BwCalendar alias = new BwCalendar();
        String summary = reply.getSummary();
        if (summary == null || summary.length() == 0) {
            summary = "Shared Calendar";
        }
        alias.setName(reply.getInReplyTo());
        alias.setSummary(summary);
        alias.setCalType(7);
        alias.setAliasUri("bwcal://" + sharerCol.getPath());
        alias.setShared(true);
        alias.setSharedWritable(sharedWritable);
        BwCalendar createdAlias = this.getCols().add(alias, home.getPath());
        return SharingI.ReplyResult.success((String)createdAlias.getPath());
    }

    public InviteType getInviteStatus(BwCalendar col) throws CalFacadeException {
        String inviteStr = col.getProperty(NamespaceAbbrevs.prefixed((QName)AppleServerTags.invite));
        if (inviteStr == null) {
            return new InviteType();
        }
        try {
            return new Parser().parseInvite(inviteStr);
        }
        catch (WebdavException we) {
            throw new CalFacadeException((Throwable)we);
        }
    }

    public void delete(BwCalendar col) throws CalFacadeException {
        InviteType invite = this.getInviteStatus(col);
        for (UserType u : invite.getUsers()) {
            if (u.getInviteStatus().equals(Parser.inviteNoresponseTag)) {
                NotificationType n;
                BwPrincipal pr = this.caladdrToPrincipal(u.getHref());
                if (pr != null && (n = this.findInvite(pr, col.getPath())) != null) {
                    this.deleteInvite(pr, n);
                }
            } else if (u.getInviteStatus().equals(Parser.inviteAcceptedTag)) {
                String calAddr = this.principalToCaladdr(this.getPrincipal());
                InviteNotificationType in = this.deletedNotification(col.getPath(), u.getHref(), calAddr, col.getSummary(), u.getAccess());
                NotificationType note = new NotificationType();
                note.setDtstamp(new DtStamp(new DateTime(true)).getValue());
                note.setNotification((BaseNotificationType)in);
                NotificationsI notify = this.getSvc().getNotificationsHandler();
                BwPrincipal pr = this.caladdrToPrincipal(u.getHref());
                notify.send(pr, note);
            }
            this.removeAlias(col, u.getHref(), true);
        }
    }

    public void publish(BwCalendar col) throws CalFacadeException {
        if (!col.getCanAlias()) {
            throw new CalFacadeForbidden("Cannot publish");
        }
        col.setQproperty(AppleServerTags.publishUrl, col.getPath());
        try {
            this.getCols().update(col);
            this.setAccess(col, new AddPrincipal(null, true));
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void unpublish(BwCalendar col) throws CalFacadeException {
        if (col.getPublick().booleanValue() || col.getQproperty(AppleServerTags.publishUrl) == null) {
            throw new CalFacadeForbidden("Not published");
        }
        Acl acl = this.removeAccess(col.getCurrentAccess().getAcl(), null, 10);
        col.removeQproperty(AppleServerTags.publishUrl);
        try {
            this.getCols().update(col);
            if (acl != null) {
                this.getSvc().changeAccess((BwShareableDbentity)col, acl.getAces(), true);
            }
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public SharingI.SubscribeResult subscribe(String colPath, String subscribedName) throws CalFacadeException {
        BwCalendar publishedCol = this.getCols().get(colPath);
        SharingI.SubscribeResult sr = new SharingI.SubscribeResult();
        if (publishedCol == null) {
            throw new CalFacadeForbidden("Bad url or no access");
        }
        if (!publishedCol.getPublick().booleanValue() && publishedCol.getQproperty(AppleServerTags.publishUrl) == null) {
            throw new CalFacadeForbidden("Not published");
        }
        List<BwCalendar> aliases = this.findAlias(colPath);
        if (!Util.isEmpty(aliases)) {
            sr.path = aliases.get(0).getPath();
            sr.alreadySubscribed = true;
            return sr;
        }
        BwCalendar alias = new BwCalendar();
        String summary = subscribedName;
        if (summary == null || summary.length() == 0) {
            summary = "Published Calendar";
        }
        alias.setName(Sharing.getEncodedUuid());
        alias.setSummary(summary);
        alias.setCalType(7);
        alias.setAliasUri("bwcal://" + colPath);
        alias.setShared(true);
        alias.setSharedWritable(false);
        sr.path = this.getCols().add(alias, this.getCols().getHome().getPath()).getPath();
        return sr;
    }

    public SharingI.SubscribeResult subscribeExternal(String extUrl, String subscribedName, int refresh, String remoteId, String remotePw) throws CalFacadeException {
        BwCalendar alias = new BwCalendar();
        SharingI.SubscribeResult sr = new SharingI.SubscribeResult();
        String summary = subscribedName;
        if (summary == null || summary.length() == 0) {
            summary = "Published Calendar";
        }
        alias.setName(Sharing.getEncodedUuid());
        alias.setSummary(summary);
        alias.setCalType(8);
        alias.setAliasUri(extUrl);
        alias.setSharedWritable(false);
        int refreshRate = 5;
        if (refresh > refreshRate) {
            refreshRate = refresh;
        }
        refreshRate *= 60;
        alias.setRemoteId(remoteId);
        if (remotePw != null) {
            try {
                String pw = this.getSvc().getEncrypter().encrypt(remotePw);
                alias.setRemotePw(pw);
                alias.setPwNeedsEncrypt(false);
            }
            catch (CalFacadeException cfe) {
                throw cfe;
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
        }
        sr.path = this.getCols().add(alias, this.getCols().getHome().getPath()).getPath();
        return sr;
    }

    public void unsubscribe(BwCalendar col) throws CalFacadeException {
        if (!col.getInternalAlias()) {
            return;
        }
        BwCalendar shared = this.getCols().resolveAlias(col, true, false);
        if (shared == null) {
            return;
        }
        String sharerHref = shared.getOwnerHref();
        BwPrincipal sharee = this.getSvc().getPrincipal();
        this.pushPrincipal(sharerHref);
        try {
            InviteType invite = this.getInviteStatus(shared);
            UserType uentry = null;
            String invitee = this.principalToCaladdr(sharee);
            if (invite != null) {
                uentry = invite.finduser(invitee);
            }
            if (uentry == null) {
                if (this.debug) {
                    this.trace("Cannot find invitee: " + invitee);
                }
                return;
            }
            uentry.setInviteStatus(AppleServerTags.inviteDeclined);
            shared.setProperty(NamespaceAbbrevs.prefixed((QName)AppleServerTags.invite), invite.toXml());
            this.getCols().update(shared);
            NotificationType note = new NotificationType();
            note.setDtstamp(new DtStamp(new DateTime(true)).getValue());
            InviteReplyType reply = new InviteReplyType();
            reply.setHref(this.principalToCaladdr(sharee));
            reply.setAccepted(Boolean.valueOf(false));
            reply.setHostUrl(shared.getPath());
            reply.setInReplyTo(col.getName());
            reply.setSummary(col.getSummary());
            note.setNotification((BaseNotificationType)reply);
            this.getSvc().getNotificationsHandler().add(note);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            this.popPrincipal();
        }
    }

    private boolean updateSharingStatus(String sharerHref, String path, InviteReplyType reply, Holder<AccessType> access) throws CalFacadeException {
        this.pushPrincipal(sharerHref);
        try {
            BwCalendar col = this.getCols().get(path);
            if (col == null) {
                throw new CalFacadeForbidden("org.bedework.notification.sharetargetnotfound");
            }
            QName qn = new QName(AppleServerTags.inviteNotification.getNamespaceURI(), AppleServerTags.inviteNotification.getLocalPart() + reply.getInReplyTo());
            String pname = NamespaceAbbrevs.prefixed((QName)qn);
            String xmlInvite = col.getProperty(pname);
            if (xmlInvite == null) {
                if (this.debug) {
                    this.trace("No invite notification on collection with name: " + pname);
                }
                throw new CalFacadeForbidden("org.bedework.notification.noinvite");
            }
            col.setProperty(pname, null);
            InviteType invite = this.getInviteStatus(col);
            UserType uentry = null;
            String invitee = this.getSvc().getDirectories().normalizeCua(reply.getHref());
            if (invite != null) {
                uentry = invite.finduser(invitee);
            }
            if (uentry == null) {
                if (this.debug) {
                    this.trace("Cannot find invitee: " + invitee);
                }
                throw new CalFacadeForbidden("org.bedework.notification.noinviteeinusers");
            }
            if (reply.testAccepted()) {
                uentry.setInviteStatus(AppleServerTags.inviteAccepted);
            } else {
                uentry.setInviteStatus(AppleServerTags.inviteDeclined);
            }
            access.value = uentry.getAccess();
            col.setProperty(NamespaceAbbrevs.prefixed((QName)AppleServerTags.invite), invite.toXml());
            this.getCols().update(col);
            NotificationType note = new NotificationType();
            note.setDtstamp(new DtStamp(new DateTime(true)).getValue());
            InviteReplyType irt = (InviteReplyType)reply.clone();
            note.setNotification((BaseNotificationType)irt);
            irt.setSummary(reply.getSummary());
            this.getSvc().getNotificationsHandler().add(note);
            boolean bl = irt.testAccepted();
            return bl;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            this.popPrincipal();
        }
    }

    private InviteNotificationType doRemove(BwCalendar col, RemoveType rem, String calAddr, InviteType invite) throws CalFacadeException {
        String href = this.getSvc().getDirectories().normalizeCua(rem.getHref());
        UserType uentry = invite.finduser(href);
        if (uentry == null) {
            return null;
        }
        invite.getUsers().remove(uentry);
        InviteNotificationType note = this.deletedNotification(col.getPath(), href, calAddr, col.getSummary(), uentry.getAccess());
        note.setPreviousStatus(uentry.getInviteStatus());
        this.removeAlias(col, uentry.getHref(), false);
        return note;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeAccess(BwCalendar col, String principalHref) throws CalFacadeException {
        Acl acl = col.getCurrentAccess().getAcl();
        try {
            if (Util.isEmpty((Collection)acl.getAces())) {
                return false;
            }
            BwPrincipal pr = this.caladdrToPrincipal(principalHref);
            if ((acl = this.removeAccess(acl, pr.getAccount(), pr.getKind())) == null) {
                return false;
            }
            this.getSvc().changeAccess((BwShareableDbentity)col, acl.getAces(), true);
            if (!col.getInternalAlias()) {
                return true;
            }
            BwCalendar target = this.getSvc().getCalendarsHandler().resolveAlias(col, false, false);
            if (target == null) {
                return false;
            }
            this.pushPrincipal(target.getOwnerHref());
            try {
                boolean bl = this.removeAccess(target, principalHref);
                return bl;
            }
            catch (CalFacadeException cfe) {
                throw cfe;
            }
            catch (Throwable t) {
                throw new CalFacadeException(t);
            }
            finally {
                this.popPrincipal();
            }
        }
        catch (AccessException ae) {
            throw new CalFacadeException((Throwable)ae);
        }
    }

    private InviteNotificationType deletedNotification(String colPath, String shareeHref, String sharerHref, String summary, AccessType access) throws CalFacadeException {
        InviteNotificationType in = new InviteNotificationType();
        in.setUid(Uid.getUid());
        in.setHref(shareeHref);
        in.setInviteStatus(removeStatus);
        in.setAccess(access);
        in.setHostUrl(colPath);
        OrganizerType org = new OrganizerType();
        org.setHref(sharerHref);
        in.setOrganizer(org);
        in.setSummary(summary);
        return in;
    }

    private NotificationProperties getNoteProps() throws CalFacadeException {
        return this.getSvc().getNotificationProperties();
    }

    private Sharee getSharee(String cua) throws CalFacadeException {
        Sharee sh = new Sharee();
        sh.href = this.getSvc().getDirectories().normalizeCua(cua);
        sh.pr = this.caladdrToPrincipal(sh.href);
        if (sh.pr != null && this.getUsers().getPrincipal(sh.pr.getPrincipalRef()) == null) {
            sh.pr = this.getUsers().getAlways(sh.pr.getAccount());
        } else if (sh.pr == null && this.getNoteProps().getOutboundEnabled()) {
            sh.external = true;
            sh.pr = this.getUsers().getAlways(this.getNoteProps().getNotifierId());
        }
        return sh;
    }

    private InviteNotificationType doSet(BwCalendar col, SetType s, List<AddPrincipal> addPrincipals, String calAddr, InviteType invite) throws CalFacadeException {
        NotificationType n;
        Sharee sh = this.getSharee(s.getHref());
        if (sh.pr != null && sh.pr.equals((Object)this.getPrincipal())) {
            return null;
        }
        UserType uentry = invite.finduser(sh.href);
        if (uentry != null && uentry.getInviteStatus().equals(Parser.inviteNoresponseTag) && (n = this.findInvite(sh.pr, col.getPath())) != null) {
            InviteNotificationType in = (InviteNotificationType)n.getNotification();
            if (in.getAccess().equals((Object)s.getAccess())) {
                return null;
            }
            this.deleteInvite(sh.pr, n);
        }
        InviteNotificationType in = new InviteNotificationType();
        in.setSharedType("calendar");
        in.setUid(Uid.getUid());
        in.setHref(sh.href);
        in.setInviteStatus(Parser.inviteNoresponseTag);
        in.setAccess(s.getAccess());
        in.setHostUrl(col.getPath());
        in.setSummary(s.getSummary());
        OrganizerType org = new OrganizerType();
        org.setHref(calAddr);
        in.setOrganizer(org);
        in.getSupportedComponents().addAll(col.getSupportedComponents());
        if (uentry != null) {
            uentry.setInviteStatus(in.getInviteStatus());
            uentry.setAccess(in.getAccess());
        } else {
            uentry = new UserType();
            uentry.setHref(sh.href);
            uentry.setInviteStatus(in.getInviteStatus());
            uentry.setCommonName(s.getCommonName());
            uentry.setAccess(in.getAccess());
            uentry.setSummary(s.getSummary());
            invite.getUsers().add(uentry);
        }
        uentry.setExternalUser(!sh.external);
        if (!sh.external) {
            addPrincipals.add(new AddPrincipal(sh.pr, s.getAccess().testRead()));
        }
        return in;
    }

    private void setAccess(BwCalendar col, AddPrincipal ap) throws CalFacadeException {
        block13: {
            try {
                BwPrincipal owner;
                AceWho ownerWho;
                int whoKind;
                String whoHref;
                if (ap.pr != null) {
                    whoHref = ap.pr.getPrincipalRef();
                    whoKind = ap.pr.getKind();
                } else {
                    whoHref = null;
                    whoKind = 10;
                }
                Acl acl = col.getCurrentAccess().getAcl();
                AceWho who = AceWho.getAceWho((String)whoHref, (int)whoKind, (boolean)false);
                Collection<Privilege> desiredPriv = ap.forRead ? readPrivs : readWritePrivs;
                Acl removed = acl.removeWho(who);
                if (removed != null) {
                    acl = removed;
                }
                if ((removed = acl.removeWho(ownerWho = AceWho.getAceWho((String)(owner = this.getUsers().getPrincipal(col.getOwnerHref())).getAccount(), (int)owner.getKind(), (boolean)false))) != null) {
                    acl = removed;
                }
                ArrayList<Ace> aces = new ArrayList<Ace>();
                aces.addAll(acl.getAces());
                aces.add(Ace.makeAce((AceWho)who, desiredPriv, null));
                aces.add(Ace.makeAce((AceWho)ownerWho, allPrivs, null));
                this.getSvc().changeAccess((BwShareableDbentity)col, aces, true);
                if (!col.getInternalAlias()) {
                    return;
                }
                BwCalendar target = this.getSvc().getCalendarsHandler().resolveAlias(col, false, false);
                if (target == null) break block13;
                this.pushPrincipal(target.getOwnerHref());
                try {
                    this.setAccess(target, ap);
                }
                catch (CalFacadeException cfe) {
                    throw cfe;
                }
                catch (Throwable t) {
                    throw new CalFacadeException(t);
                }
                finally {
                    this.popPrincipal();
                }
            }
            catch (AccessException ae) {
                throw new CalFacadeException((Throwable)ae);
            }
        }
    }

    private Acl removeAccess(Acl acl, String href, int whoKind) throws CalFacadeException {
        try {
            AceWho who = AceWho.getAceWho((String)href, (int)whoKind, (boolean)false);
            return acl.removeWho(who);
        }
        catch (AccessException ae) {
            throw new CalFacadeException((Throwable)ae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAlias(BwCalendar col, String shareeHref, boolean unsubscribe) throws CalFacadeException {
        if (!this.pushPrincipalReturn(shareeHref)) {
            return;
        }
        try {
            List<BwCalendar> cols = this.findAlias(col.getPath());
            if (!Util.isEmpty(cols)) {
                for (BwCalendar alias : cols) {
                    ((Calendars)this.getCols()).delete(alias, false, false, true, unsubscribe);
                }
            }
        }
        finally {
            this.popPrincipal();
        }
    }

    private NotificationType findInvite(BwPrincipal pr, String href) throws CalFacadeException {
        List ns = this.getSvc().getNotificationsHandler().getMatching(pr, Parser.inviteNotificationTag);
        for (NotificationType n : ns) {
            InviteNotificationType in = (InviteNotificationType)n.getNotification();
            if (!in.getHostUrl().equals(href)) continue;
            return n;
        }
        return null;
    }

    private void deleteInvite(BwPrincipal pr, NotificationType n) throws CalFacadeException {
        ((Notifications)this.getSvc().getNotificationsHandler()).remove(pr, n);
    }

    static {
        allPrivs.add(allPriv);
        readPrivs.add(readPriv);
        readPrivs.add(readFreeBusyPriv);
        readPrivs.add(schedulePriv);
        readPrivs.add(scheduleDeliverPriv);
        readWritePrivs.add(bindPriv);
        readWritePrivs.add(readPriv);
        readWritePrivs.add(unbindPriv);
        readWritePrivs.add(write);
        readWritePrivs.add(readFreeBusyPriv);
        readWritePrivs.add(schedulePriv);
        readWritePrivs.add(scheduleDeliverPriv);
    }

    private static class Sharee {
        String href;
        BwPrincipal pr;
        boolean external;

        private Sharee() {
        }
    }

    private static final class AddPrincipal {
        final BwPrincipal pr;
        final boolean forRead;

        private AddPrincipal(BwPrincipal pr, boolean forRead) {
            this.pr = pr;
            this.forRead = forRead;
        }
    }
}

