/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayDeque;
import java.util.Deque;
import org.bedework.access.AccessException;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.PrivilegeSet;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.PrincipalInfo;
import org.bedework.calsvc.CalSvc;

final class SvciPrincipalInfo
extends PrincipalInfo {
    private final CalSvc svci;
    private final Deque<StackedState> stack = new ArrayDeque<StackedState>();

    SvciPrincipalInfo(CalSvc svci, BwPrincipal principal, BwPrincipal authPrincipal, PrivilegeSet maxAllowedPrivs, boolean subscriptionsOnly) {
        super(principal, authPrincipal, maxAllowedPrivs, subscriptionsOnly);
        this.svci = svci;
    }

    void setSuperUser(boolean val) {
        this.superUser = val;
        this.subscriptionsOnly = false;
    }

    public AccessPrincipal getPrincipal(String href) throws CalFacadeException {
        return this.svci.getUsersHandler().getPrincipal(href);
    }

    public BasicSystemProperties getSyspars() {
        return this.svci.getBasicSystemProperties();
    }

    void setPrincipal(BwPrincipal principal) {
        this.principal = principal;
        this.calendarHomePath = null;
    }

    void pushPrincipal(BwPrincipal principal) {
        StackedState ss = new StackedState();
        ss.principal = this.principal;
        ss.superUser = this.superUser;
        ss.calendarHomePath = this.calendarHomePath;
        ss.maxAllowedPrivs = this.maxAllowedPrivs;
        this.stack.push(ss);
        this.setPrincipal(principal);
        this.superUser = false;
        this.maxAllowedPrivs = null;
    }

    void popPrincipal() throws CalFacadeException {
        StackedState ss = this.stack.pop();
        if (ss == null) {
            throw new CalFacadeException("Nothing to pop");
        }
        this.setPrincipal(ss.principal);
        this.calendarHomePath = ss.calendarHomePath;
        this.superUser = ss.superUser;
        this.maxAllowedPrivs = ss.maxAllowedPrivs;
    }

    public String makeHref(String id, int whoType) throws AccessException {
        try {
            return this.svci.getDirectories().makePrincipalUri(id, whoType);
        }
        catch (Throwable t) {
            throw new AccessException(t);
        }
    }

    private static class StackedState {
        BwPrincipal principal;
        boolean superUser;
        String calendarHomePath;
        PrivilegeSet maxAllowedPrivs;

        private StackedState() {
        }
    }
}

