/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.net.URL;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import org.bedework.caldav.server.soap.synch.SynchConnection;
import org.bedework.caldav.server.soap.synch.SynchConnectionsMBean;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.configs.SynchConfig;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.synch.BwSynchInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.SynchI;
import org.bedework.synch.wsmessages.ActiveSubscriptionRequestType;
import org.bedework.synch.wsmessages.ArrayOfSynchProperties;
import org.bedework.synch.wsmessages.ConnectorInfoType;
import org.bedework.synch.wsmessages.GetInfoRequestType;
import org.bedework.synch.wsmessages.GetInfoResponseType;
import org.bedework.synch.wsmessages.SubscribeRequestType;
import org.bedework.synch.wsmessages.SubscribeResponseType;
import org.bedework.synch.wsmessages.SubscriptionStatusRequestType;
import org.bedework.synch.wsmessages.SynchDirectionType;
import org.bedework.synch.wsmessages.SynchEndType;
import org.bedework.synch.wsmessages.SynchIdTokenType;
import org.bedework.synch.wsmessages.SynchInfoType;
import org.bedework.synch.wsmessages.SynchMasterType;
import org.bedework.synch.wsmessages.SynchPropertyType;
import org.bedework.synch.wsmessages.SynchRemoteService;
import org.bedework.synch.wsmessages.SynchRemoteServicePortType;
import org.bedework.synch.wsmessages.UnsubscribeRequestType;
import org.bedework.synch.wsmessages.UnsubscribeResponseType;
import org.bedework.util.jmx.MBeanUtil;
import org.oasis_open.docs.ws_calendar.ns.soap.StatusType;

class Synch
extends CalSvcDb
implements SynchI {
    private SynchConnectionsMBean conns;
    private final SynchConfig synchConf;
    static final String synchConnectionsMBeanName = "org.bedework.caldav:service=SynchConnections";
    static final String synchNamespace = "http://www.bedework.org/synch/wsmessages";
    static final QName synchServicename = new QName("http://www.bedework.org/synch/wsmessages", "SynchRemoteService");
    private static volatile BwSynchInfo synchInfo;
    private static final long synchInfoRefreshPeriod = 300000L;
    private static volatile long lastSynchInfoRefresh;

    Synch(CalSvc svci, SynchConfig synchConf) {
        super(svci);
        this.synchConf = synchConf;
    }

    public boolean getActive() throws CalFacadeException {
        return this.getSynchConnection() != null;
    }

    public SynchI.Connection getSynchConnection() throws CalFacadeException {
        try {
            return new SConnection(this.getActiveSynchConnections().getConnectionById(this.synchConf.getConnectorId()));
        }
        catch (Throwable t) {
            this.warn("Exception getting synch connection: is the synch engine installed and running?");
            if (this.debug) {
                this.error(t);
            }
            return null;
        }
    }

    public boolean subscribe(BwCalendar val) throws CalFacadeException {
        SubscribeResponseType sresp;
        int refreshRate;
        SConnection sconn = (SConnection)this.getSynchConnection();
        if (sconn == null || sconn.sc == null) {
            throw new CalFacadeException("No active synch connection");
        }
        SynchConnection sc = sconn.sc;
        SubscribeRequestType subreq = new SubscribeRequestType();
        subreq.setToken(sc.getSynchToken());
        subreq.setPrincipalHref(val.getOwnerHref());
        subreq.setDirection(SynchDirectionType.B_TO_A);
        subreq.setMaster(SynchMasterType.B);
        ConnectorInfoType ciA = new ConnectorInfoType();
        ciA.setConnectorId(this.synchConf.getConnectorId());
        ArrayOfSynchProperties aosA = new ArrayOfSynchProperties();
        ciA.setProperties(aosA);
        aosA.getProperty().add(this.makeSynchProperty("uri", val.getPath()));
        aosA.getProperty().add(this.makeSynchProperty("principal", this.getPrincipal().getPrincipalRef()));
        aosA.getProperty().add(this.makeSynchProperty("opaque-data", this.makeOpaqueData(val)));
        subreq.setEndAConnector(ciA);
        ConnectorInfoType ciB = new ConnectorInfoType();
        String aliasUri = val.getAliasUri();
        String subType = null;
        int pos = aliasUri.indexOf("+http");
        if (pos > 0) {
            subType = aliasUri.substring(0, pos);
            aliasUri = aliasUri.substring(pos + 1);
        }
        if (subType == null) {
            subType = val.getSubscriptionTargetType();
        }
        if (subType == null || subType.equals("file")) {
            ciB.setConnectorId("read-only-file");
        } else {
            ciB.setConnectorId(subType);
        }
        ArrayOfSynchProperties aosB = new ArrayOfSynchProperties();
        ciB.setProperties(aosB);
        aosB.getProperty().add(this.makeSynchProperty("uri", aliasUri));
        if (val.getRemoteId() != null) {
            aosB.getProperty().add(this.makeSynchProperty("principal", val.getRemoteId()));
        }
        if (val.getRemotePw() != null) {
            aosB.getProperty().add(this.makeSynchProperty("password", val.getRemotePw()));
        }
        aosB.getProperty().add(this.makeSynchProperty("orgsync-publicOnly", String.valueOf(val.getOrgSyncPublicOnly())));
        if (val.getLocationKey() != null) {
            aosB.getProperty().add(this.makeSynchProperty("locKey", val.getLocationKey()));
        }
        if ((refreshRate = val.getRefreshRate()) == 0) {
            refreshRate = 60;
        }
        aosB.getProperty().add(this.makeSynchProperty("refreshDelay", String.valueOf(refreshRate * 1000)));
        subreq.setEndBConnector(ciB);
        ArrayOfSynchProperties aos = new ArrayOfSynchProperties();
        subreq.setInfo(aos);
        aos.getProperty().add(this.makeSynchProperty("alarm-processing", "REMOVE"));
        aos.getProperty().add(this.makeSynchProperty("scheduling-processing", "REMOVE"));
        if (val.getSynchXlocXcontacts()) {
            aos.getProperty().add(this.makeSynchProperty("xlocxcontacts", "true"));
        }
        if (val.getSynchXcategories()) {
            aos.getProperty().add(this.makeSynchProperty("xcategories", "true"));
        }
        if (val.getSynchDeleteSuppressed()) {
            aos.getProperty().add(this.makeSynchProperty("delete-suppressed", "true"));
        }
        if ((sresp = this.getPort(this.synchConf.getManagerUri()).subscribe(this.getIdToken(this.getPrincipal().getPrincipalRef(), sc), subreq)).getStatus() != StatusType.OK) {
            return false;
        }
        val.setSubscriptionId(sresp.getSubscriptionId());
        return true;
    }

    public boolean unsubscribe(BwCalendar val, boolean forDelete) throws CalFacadeException {
        if (val.getSubscriptionId() == null) {
            return true;
        }
        SConnection sconn = (SConnection)this.getSynchConnection();
        if (sconn == null || sconn.sc == null) {
            throw new CalFacadeException("No active synch connection");
        }
        SynchConnection sc = sconn.sc;
        UnsubscribeRequestType usreq = (UnsubscribeRequestType)this.makeAsr(val, (ActiveSubscriptionRequestType)new UnsubscribeRequestType(), sc.getSynchToken());
        UnsubscribeResponseType usresp = this.getPort(this.synchConf.getManagerUri()).unsubscribe(this.getIdToken(this.getPrincipal().getPrincipalRef(), sc), usreq);
        if (usresp.getStatus() != StatusType.OK) {
            return false;
        }
        if (!forDelete) {
            val.setSubscriptionId(null);
        }
        return true;
    }

    public CalendarsI.SynchStatusResponse getSynchStatus(BwCalendar val) throws CalFacadeException {
        CalendarsI.SynchStatusResponse ssr = new CalendarsI.SynchStatusResponse();
        if (val == null) {
            ssr.requestStatus = CalendarsI.CheckSubscriptionResult.notFound;
            return ssr;
        }
        if (!val.getExternalSub()) {
            ssr.requestStatus = CalendarsI.CheckSubscriptionResult.notExternal;
            return ssr;
        }
        if (val.getSubscriptionId() == null) {
            ssr.requestStatus = CalendarsI.CheckSubscriptionResult.notsubscribed;
            return ssr;
        }
        SConnection sconn = (SConnection)this.getSynchConnection();
        if (sconn == null || sconn.sc == null) {
            ssr.requestStatus = CalendarsI.CheckSubscriptionResult.noSynchService;
            return ssr;
        }
        SynchConnection sc = sconn.sc;
        SubscriptionStatusRequestType ssreq = (SubscriptionStatusRequestType)this.makeAsr(val, (ActiveSubscriptionRequestType)new SubscriptionStatusRequestType(), sc.getSynchToken());
        ssr.subscriptionStatus = this.getPort(this.synchConf.getManagerUri()).subscriptionStatus(this.getIdToken(this.getPrincipal().getPrincipalRef(), sc), ssreq);
        ssr.requestStatus = ssr.subscriptionStatus.getStatus() == StatusType.NOT_FOUND ? CalendarsI.CheckSubscriptionResult.notsubscribed : CalendarsI.CheckSubscriptionResult.ok;
        return ssr;
    }

    public CalendarsI.CheckSubscriptionResult checkSubscription(BwCalendar val) throws CalFacadeException {
        CalendarsI.SynchStatusResponse ssr = this.getSynchStatus(val);
        if (ssr.requestStatus == CalendarsI.CheckSubscriptionResult.notsubscribed) {
            if (this.subscribe(val)) {
                return CalendarsI.CheckSubscriptionResult.resubscribed;
            }
            return CalendarsI.CheckSubscriptionResult.failed;
        }
        if (ssr.requestStatus != CalendarsI.CheckSubscriptionResult.ok) {
            return ssr.requestStatus;
        }
        if (ssr.subscriptionStatus.getStatus() == StatusType.OK) {
            return CalendarsI.CheckSubscriptionResult.ok;
        }
        return CalendarsI.CheckSubscriptionResult.failed;
    }

    public BwSynchInfo getSynchInfo() throws CalFacadeException {
        GetInfoResponseType girt;
        if (synchInfo != null && System.currentTimeMillis() - lastSynchInfoRefresh < 300000L) {
            return synchInfo;
        }
        lastSynchInfoRefresh = System.currentTimeMillis();
        SConnection sconn = (SConnection)this.getSynchConnection();
        if (sconn == null || sconn.sc == null) {
            this.warn("No active synch connection");
            return null;
        }
        SynchConnection sc = sconn.sc;
        try {
            girt = this.getPort(this.synchConf.getManagerUri()).getInfo(this.getIdToken(this.getPrincipal().getPrincipalRef(), sc), new GetInfoRequestType());
        }
        catch (Throwable t) {
            this.error(t);
            this.warn("Unable to fetch synch info");
            return null;
        }
        if (girt == null || girt.getInfo() == null) {
            this.warn("Unable to fetch synch info");
            return null;
        }
        synchInfo = BwSynchInfo.copy((SynchInfoType)girt.getInfo());
        return synchInfo;
    }

    private SynchConnectionsMBean getActiveSynchConnections() throws CalFacadeException {
        try {
            if (this.conns == null) {
                this.conns = (SynchConnectionsMBean)MBeanUtil.getMBean(SynchConnectionsMBean.class, (String)synchConnectionsMBeanName);
            }
            return this.conns;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private ActiveSubscriptionRequestType makeAsr(BwCalendar val, ActiveSubscriptionRequestType asr, String synchToken) throws CalFacadeException {
        if (val.getSubscriptionId() == null) {
            return null;
        }
        asr.setToken(synchToken);
        asr.setPrincipalHref(val.getOwnerHref());
        asr.setSubscriptionId(val.getSubscriptionId());
        asr.setEnd(SynchEndType.A);
        asr.setConnectorInfo(this.makeCi(val));
        return asr;
    }

    private ConnectorInfoType makeCi(BwCalendar val) throws CalFacadeException {
        ConnectorInfoType ci = new ConnectorInfoType();
        ci.setConnectorId(this.synchConf.getConnectorId());
        ArrayOfSynchProperties aosA = new ArrayOfSynchProperties();
        ci.setProperties(aosA);
        aosA.getProperty().add(this.makeSynchProperty("uri", val.getPath()));
        aosA.getProperty().add(this.makeSynchProperty("principal", this.getPrincipal().getPrincipalRef()));
        return ci;
    }

    private SynchPropertyType makeSynchProperty(String name, String value) {
        SynchPropertyType sp = new SynchPropertyType();
        sp.setName(name);
        sp.setValue(value);
        return sp;
    }

    SynchIdTokenType getIdToken(String principal, SynchConnection sc) throws CalFacadeException {
        SynchIdTokenType idToken = new SynchIdTokenType();
        idToken.setPrincipalHref(principal);
        idToken.setSubscribeUrl(sc.getSubscribeUrl());
        idToken.setSynchToken(sc.getSynchToken());
        return idToken;
    }

    private String makeOpaqueData(BwCalendar col) throws CalFacadeException {
        return "public-admin=" + this.isPublicAdmin() + "\tadminCreateEprops=" + col.getSynchAdminCreateEprops();
    }

    SynchRemoteServicePortType getPort(String uri) throws CalFacadeException {
        try {
            URL wsURL = new URL(this.synchConf.getWsdlUri());
            SynchRemoteService ers = new SynchRemoteService(wsURL, synchServicename);
            SynchRemoteServicePortType port = ers.getSynchRSPort();
            ((BindingProvider)port).getRequestContext().put("javax.xml.ws.service.endpoint.address", uri);
            return port;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static class SConnection
    implements SynchI.Connection {
        private final SynchConnection sc;

        SConnection(SynchConnection sc) {
            this.sc = sc;
        }
    }
}

