/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwSystem;
import org.bedework.calfacade.base.BwUnversionedDbentity;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.SysparsI;

class Syspars
extends CalSvcDb
implements SysparsI {
    private static BwSystem syspars;
    private static boolean restoring;
    private static long lastRefresh;
    private static final long refreshInterval = 300000L;
    private static final String sysparsName = "bedework";
    private Collection<String> rootUsers;

    Syspars(CalSvc svci) {
        super(svci);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BwSystem get() throws CalFacadeException {
        if (restoring) {
            return syspars;
        }
        Syspars syspars = this;
        synchronized (syspars) {
            if (System.currentTimeMillis() > lastRefresh + 300000L) {
                Syspars.syspars = null;
                lastRefresh = System.currentTimeMillis();
            }
            if (Syspars.syspars == null) {
                Syspars.syspars = this.get(sysparsName);
            }
            return Syspars.syspars;
        }
    }

    public BwSystem get(String name) throws CalFacadeException {
        BwSystem sys = this.getCal().getSyspars(name);
        if (sys == null) {
            throw new CalFacadeException("No system parameters with name " + name);
        }
        if (this.debug) {
            this.trace("Read system parameters: " + sys);
        }
        return sys;
    }

    public void update(BwSystem val) throws CalFacadeException {
        if (!this.isSuper()) {
            throw new CalFacadeAccessException();
        }
        this.getCal().saveOrUpdate((BwUnversionedDbentity)val);
        syspars = null;
        restoring = false;
    }

    public Collection<String> getRootUsers() throws CalFacadeException {
        if (this.rootUsers != null) {
            return this.rootUsers;
        }
        this.rootUsers = new ArrayList<String>();
        String rus = this.getSvc().getSystemProperties().getRootUsers();
        if (rus == null) {
            return this.rootUsers;
        }
        try {
            int pos = 0;
            while (pos < rus.length()) {
                int nextPos = rus.indexOf(",", pos);
                if (nextPos < 0) {
                    this.rootUsers.add(rus.substring(pos));
                    break;
                }
                this.rootUsers.add(rus.substring(pos, nextPos));
                pos = nextPos + 1;
            }
        }
        catch (Throwable t) {
            throw new CalFacadeException("org.bedework.exception.badrootuserslist", rus);
        }
        return this.rootUsers;
    }

    public boolean isRootUser(BwPrincipal val) throws CalFacadeException {
        if (val == null || val.getUnauthenticated()) {
            return false;
        }
        if (val.getKind() != 1) {
            return false;
        }
        Collection<String> rus = this.getRootUsers();
        return rus.contains(val.getAccount());
    }

    void setForRestore(BwSystem val) {
        restoring = true;
        syspars = val;
    }

    public boolean present() throws CalFacadeException {
        BwSystem sys = this.getCal().getSyspars(sysparsName);
        return sys != null;
    }
}

