/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.property.LastModified;
import org.apache.log4j.Logger;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.BwEventKey;
import org.bedework.calfacade.base.UpdateFromTimeZonesInfo;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.util.BwDateTimeUtil;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvci.TimeZonesStoreI;
import org.bedework.util.misc.ToString;

public class TimeZonesStoreImpl
implements TimeZonesStoreI {
    protected boolean debug;
    private final CalSvc svci;
    private transient Logger log;

    TimeZonesStoreImpl(CalSvc svci) {
        this.svci = svci;
        this.debug = this.getLogger().isDebugEnabled();
    }

    public UpdateFromTimeZonesInfo updateFromTimeZones(String colHref, int limit, boolean checkOnly, UpdateFromTimeZonesInfo info) throws CalFacadeException {
        UpdateFromTimeZonesInfoInternal iinfo;
        if (info != null && !(info instanceof UpdateFromTimeZonesInfoInternal)) {
            throw new CalFacadeException("org.bedework.exception.illegalobjectclass");
        }
        boolean redo = false;
        if (info != null) {
            if (info.getTotalEventsToCheck() == info.getTotalEventsChecked()) {
                redo = true;
            }
            iinfo = (UpdateFromTimeZonesInfoInternal)info;
        } else {
            iinfo = new UpdateFromTimeZonesInfoInternal();
        }
        if (redo || iinfo.names == null) {
            String lastmod = null;
            if (redo) {
                lastmod = new LastModified(new DateTime(iinfo.lastmod - 5000L)).getValue();
            }
            iinfo.lastmod = System.currentTimeMillis();
            if (iinfo.names == null) {
                iinfo.names = new ArrayList<String>();
            }
            iinfo.totalEventsChecked = 0;
            iinfo.totalEventsUpdated = 0;
            iinfo.iterator = iinfo.names.iterator();
        }
        for (int i = 0; i < limit && iinfo.iterator.hasNext(); ++i) {
            String name = iinfo.iterator.next();
            ++iinfo.totalEventsChecked;
        }
        if (this.debug) {
            this.trace(iinfo.toString());
        }
        return iinfo;
    }

    private BwDateTime checkDateTimeForTZ(BwDateTime val, BwPrincipal owner, UpdateFromTimeZonesInfoInternal iinfo) throws CalFacadeException {
        if (val.getDateType()) {
            return null;
        }
        if (val.isUTC()) {
            return null;
        }
        if (val.getFloating()) {
            return null;
        }
        try {
            BwDateTime newVal = BwDateTimeUtil.getDateTime((String)val.getDtval(), (boolean)false, (boolean)false, (String)val.getTzid());
            if (newVal.getDate().equals(val.getDate())) {
                return null;
            }
            return newVal;
        }
        catch (CalFacadeException cfe) {
            if (cfe.getMessage().equals("org.bedework.error.unknown.timezone")) {
                iinfo.unknownTzids.add(new UpdateFromTimeZonesInfo.UnknownTimezoneInfo(owner, val.getTzid()));
                return null;
            }
            throw cfe;
        }
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }

    private void trace(String msg) {
        this.getLogger().debug((Object)("trace: " + msg));
    }

    private static class UpdateFromTimeZonesInfoInternal
    implements UpdateFromTimeZonesInfo {
        Collection<String> names;
        Iterator<String> iterator;
        long lastmod = 0L;
        int totalEventsChecked;
        int totalEventsUpdated;
        Collection<UpdateFromTimeZonesInfo.UnknownTimezoneInfo> unknownTzids = new TreeSet<UpdateFromTimeZonesInfo.UnknownTimezoneInfo>();
        Collection<BwEventKey> updatedList = new ArrayList<BwEventKey>();

        private UpdateFromTimeZonesInfoInternal() {
        }

        public int getTotalEventsToCheck() {
            return this.names.size();
        }

        public int getTotalEventsChecked() {
            return this.totalEventsChecked;
        }

        public int getTotalEventsUpdated() {
            return this.totalEventsUpdated;
        }

        public Collection<UpdateFromTimeZonesInfo.UnknownTimezoneInfo> getUnknownTzids() {
            return this.unknownTzids;
        }

        public Collection<BwEventKey> getUpdatedList() {
            return this.updatedList;
        }

        public String toString() {
            ToString ts = new ToString((Object)this);
            ts.append("------------------------------------------");
            ts.newLine();
            ts.append("totalEventsToCheck", this.getTotalEventsToCheck());
            ts.newLine();
            ts.append("totalEventsChecked", this.totalEventsChecked);
            ts.newLine();
            ts.append("totalEventsUpdated", this.totalEventsUpdated);
            ts.newLine();
            ts.append("------------------------------------------");
            return ts.toString();
        }
    }
}

