/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.ViewsI;

class Views
extends CalSvcDb
implements ViewsI {
    Views(CalSvc svci) {
        super(svci);
    }

    public boolean add(BwView val, boolean makeDefault) throws CalFacadeException {
        if (val == null) {
            return false;
        }
        BwPreferences prefs = this.getSvc().getPrefsHandler().get();
        this.checkOwnerOrSuper(prefs);
        if (!prefs.addView(val)) {
            return false;
        }
        if (makeDefault) {
            prefs.setPreferredView(val.getName());
        }
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public boolean remove(BwView val) throws CalFacadeException {
        if (val == null) {
            return false;
        }
        BwPreferences prefs = this.getSvc().getPrefsHandler().get();
        this.checkOwnerOrSuper(prefs);
        Collection views = prefs.getViews();
        if (views == null || !views.contains(val)) {
            return false;
        }
        String name = val.getName();
        views.remove(val);
        if (name.equals(prefs.getPreferredView())) {
            prefs.setPreferredView(null);
        }
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public BwView find(String val) throws CalFacadeException {
        BwPreferences prefs;
        if (val == null && (val = (prefs = this.getSvc().getPrefsHandler().get()).getPreferredView()) == null) {
            return null;
        }
        if (!val.startsWith("/")) {
            Collection<BwView> views = this.getAll();
            for (BwView view : views) {
                if (!view.getName().equals(val)) continue;
                return view;
            }
            return null;
        }
        String[] pathEls = val.split("/");
        BasicSystemProperties bsp = this.getBasicSyspars();
        if (pathEls.length != 5 || !bsp.getBedeworkResourceDirectory().equals(pathEls[2]) || !"views".equals(pathEls[3])) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!bsp.getUserCalendarRoot().equals(pathEls[0])) {
            return null;
        }
        sb.append("/principals/users/");
        sb.append(pathEls[1]);
        BwPrincipal pr = this.getPrincipal(sb.toString());
        if (pr == null) {
            return null;
        }
        Collection<BwView> views = this.getAll(pr);
        String viewName = pathEls[4];
        for (BwView view : views) {
            if (!view.getName().equals(viewName)) continue;
            return view;
        }
        return null;
    }

    public boolean addCollection(String name, String path) throws CalFacadeException {
        BwPreferences prefs = this.getSvc().getPrefsHandler().get();
        this.checkOwnerOrSuper(prefs);
        BwView view = this.find(name);
        if (view == null) {
            return false;
        }
        view.addCollectionPath(path);
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public boolean removeCollection(String name, String path) throws CalFacadeException {
        BwPreferences prefs = this.getSvc().getPrefsHandler().get(this.getPrincipal());
        this.checkOwnerOrSuper(prefs);
        BwView view = this.find(name);
        if (view == null) {
            return false;
        }
        view.removeCollectionPath(path);
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public Collection<BwView> getAll() throws CalFacadeException {
        TreeSet c = this.getSvc().getPrefsHandler().get().getViews();
        if (c == null) {
            c = new TreeSet();
        }
        return c;
    }

    public Collection<BwView> getAll(BwPrincipal pr) throws CalFacadeException {
        TreeSet c = this.getSvc().getPrefsHandler().get(pr).getViews();
        if (c == null) {
            c = new TreeSet();
        }
        return c;
    }
}

