/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.ws.Holder;
import net.fortuna.ical4j.model.parameter.CuType;
import net.fortuna.ical4j.vcard.Property;
import net.fortuna.ical4j.vcard.VCard;
import net.fortuna.ical4j.vcard.property.Kind;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.bedework.access.AccessPrincipal;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwPrincipalInfo;
import org.bedework.calfacade.BwProperty;
import org.bedework.calfacade.DirectoryInfo;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.configs.CalAddrPrefixes;
import org.bedework.calfacade.configs.CardDavInfo;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.DirConfigProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.Directories;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.dav.DavUtil;
import org.bedework.util.http.BasicHttpClient;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlEmit;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.BedeworkServerTags;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.CarddavTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.shared.WebdavProperty;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractDirImpl
extends Logged
implements Directories {
    private static BasicSystemProperties sysRoots;
    private CalAddrPrefixes caPrefixes;
    private CardDavInfo authCdinfo;
    private CardDavInfo unauthCdinfo;
    private DirConfigProperties dirProps;
    private static Collection<CAPrefixInfo> caPrefixInfo;
    private DomainMatcher onlyDomain;
    private boolean anyDomain;
    private String defaultDomain;
    private Collection<DomainMatcher> domains;
    protected Directories.CallBack cb;
    private final HashMap<String, Integer> toWho = new HashMap();
    private final HashMap<Integer, String> fromWho = new HashMap();
    private static final FlushMap<String, String> validPrincipals;
    private static final FlushMap<String, BwPrincipalInfo> principalInfoMap;
    private static final CutypeMap cutypeMap;
    private static final int maxCaMapSize = 3000;
    private static final long maxCaRefreshTime = 300000L;
    protected static Map<String, String> userToCalAddrMap;
    protected static Map<String, BwPrincipal> calAddrToPrincipalMap;

    public void init(Directories.CallBack cb, Configurations configs) throws CalFacadeException {
        this.cb = cb;
        this.caPrefixes = configs.getBasicSystemProperties().getCalAddrPrefixes();
        this.authCdinfo = configs.getCardDavInfo(true);
        this.unauthCdinfo = configs.getCardDavInfo(false);
        this.dirProps = configs.getDirConfig(this.getConfigName());
        this.debug = this.getLogger().isDebugEnabled();
        this.setDomains();
        this.initWhoMaps("/principals/users/", 1);
        this.initWhoMaps("/principals/groups/", 2);
        this.initWhoMaps("/principals/tickets/", 4);
        this.initWhoMaps("/principals/resources/", 5);
        this.initWhoMaps("/principals/locations/", 6);
        this.initWhoMaps("/principals/hosts/", 3);
    }

    public DirectoryInfo getDirectoryInfo() throws CalFacadeException {
        DirectoryInfo info = new DirectoryInfo();
        info.setPrincipalRoot("/principals/");
        info.setUserPrincipalRoot("/principals/users/");
        info.setGroupPrincipalRoot("/principals/groups/");
        info.setBwadmingroupPrincipalRoot("/principals/groups/bwadmin/");
        info.setTicketPrincipalRoot("/principals/tickets/");
        info.setResourcePrincipalRoot("/principals/resources/");
        info.setVenuePrincipalRoot("/principals/locations/");
        info.setHostPrincipalRoot("/principals/hosts/");
        return info;
    }

    public synchronized boolean validPrincipal(String href) throws CalFacadeException {
        if (href == null) {
            return false;
        }
        if (this.lookupValidPrincipal(href)) {
            return true;
        }
        boolean valid = !href.startsWith("invalid");
        try {
            new URI(href);
        }
        catch (Throwable t) {
            valid = false;
        }
        if (valid) {
            this.addValidPrincipal(href);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BwPrincipalInfo getDirInfo(BwPrincipal p) throws CalFacadeException {
        BwPrincipalInfo pi = (BwPrincipalInfo)principalInfoMap.get((Object)p.getPrincipalRef());
        if (pi != null) {
            return pi;
        }
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getHost() == null) {
            return null;
        }
        pi = new BwPrincipalInfo();
        try (BasicHttpClient cdc = null;){
            cdc = new BasicHttpClient(cdi.getHost(), cdi.getPort(), null, 15000);
            pi.setPropertiesFromVCard(this.getCard(cdc, cdi.getContextPath(), (AccessPrincipal)p), "text/vcard");
        }
        principalInfoMap.put((Object)p.getPrincipalRef(), (Object)pi);
        return pi;
    }

    public List<BwPrincipalInfo> find(List<WebdavProperty> props, List<WebdavProperty> returnProps, String cutype, Holder<Boolean> truncated) throws CalFacadeException {
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getHost() == null) {
            return null;
        }
        BasicHttpClient cdc = null;
        String path = this.getCutypePath(cutype, cdi);
        String addrCtype = null;
        for (WebdavProperty wd : returnProps) {
            if (!wd.getTag().equals(CarddavTags.addressData)) continue;
            addrCtype = wd.getAttr("content-type");
            break;
        }
        try {
            cdc = new BasicHttpClient(cdi.getHost(), cdi.getPort(), null, 15000);
            List<MatchResult> mrs = this.matching(cdc, cdi.getContextPath() + path, addrCtype, props);
            ArrayList<BwPrincipalInfo> pis = new ArrayList<BwPrincipalInfo>();
            if (mrs == null) {
                ArrayList<BwPrincipalInfo> arrayList = pis;
                return arrayList;
            }
            for (MatchResult mr : mrs) {
                BwPrincipalInfo pi = new BwPrincipalInfo();
                pi.setPropertiesFromVCard(mr.card, addrCtype);
                pis.add(pi);
            }
            ArrayList<BwPrincipalInfo> arrayList = pis;
            return arrayList;
        }
        catch (Throwable t) {
            if (this.getLogger().isDebugEnabled()) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
        finally {
            if (cdc != null) {
                cdc.close();
            }
        }
    }

    public List<BwPrincipalInfo> find(String cua, String cutype, boolean expand, Holder<Boolean> truncated) throws CalFacadeException {
        List<BwPrincipalInfo> list;
        CardDavInfo cdi = this.getCardDavInfo(false);
        if (cdi == null || cdi.getHost() == null) {
            return null;
        }
        BasicHttpClient cdc = null;
        try {
            cdc = new BasicHttpClient(cdi.getHost(), cdi.getPort(), null, 15000);
            List<BwPrincipalInfo> pis = this.find(cdc, cdi, cua, cutype);
            if (!expand) {
                List<BwPrincipalInfo> list2 = pis;
                return list2;
            }
            for (BwPrincipalInfo pi : pis) {
                if (!Kind.GROUP.getValue().equalsIgnoreCase(pi.getKind())) continue;
                ArrayList<BwPrincipalInfo> memberPis = new ArrayList<BwPrincipalInfo>();
                VCard card = pi.getCard();
                List members = card.getProperties(Property.Id.MEMBER);
                if (members == null) continue;
                for (Property p : members) {
                    BwPrincipalInfo memberPi = this.fetch(cdc, cdi, p.getValue());
                    if (memberPi == null) continue;
                    memberPis.add(memberPi);
                }
                pi.setMembers(memberPis);
            }
            list = pis;
        }
        catch (Throwable t) {
            if (this.getLogger().isDebugEnabled()) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
        finally {
            if (cdc != null) {
                try {
                    cdc.release();
                }
                catch (Throwable throwable) {}
            }
        }
        return list;
    }

    private BwPrincipalInfo fetch(BasicHttpClient cdc, CardDavInfo cdi, String uri) throws CalFacadeException {
        List<BwPrincipalInfo> pis = this.find(cdc, cdi, uri, CuType.INDIVIDUAL.getValue());
        if (pis == null || pis.size() != 1) {
            return null;
        }
        return pis.get(0);
    }

    private List<BwPrincipalInfo> find(BasicHttpClient cdc, CardDavInfo cdi, String cua, String cutype) throws CalFacadeException {
        ArrayList<WebdavProperty> props = new ArrayList<WebdavProperty>();
        CalAddr ca = new CalAddr(cua);
        if (cutype != null && cutype.equalsIgnoreCase(CuType.GROUP.getValue())) {
            WebdavProperty fnProp = new WebdavProperty(WebdavTags.displayname, ca.getId());
            props.add(fnProp);
        }
        WebdavProperty emailProp = new WebdavProperty(BedeworkServerTags.emailProp, ca.getNoScheme());
        props.add(emailProp);
        ArrayList<BwPrincipalInfo> pis = new ArrayList<BwPrincipalInfo>();
        List<MatchResult> mrs = this.matching(cdc, cdi.getContextPath() + this.getCutypePath(cutype, cdi), null, props);
        if (mrs == null) {
            return pis;
        }
        for (MatchResult mr : mrs) {
            BwPrincipalInfo pi = new BwPrincipalInfo();
            pi.setPropertiesFromVCard(mr.card, null);
            pis.add(pi);
        }
        return pis;
    }

    private String getCutypePath(String cutype, CardDavInfo cdi) {
        String msg = cutypeMap.init(cdi.getCutypeMapping());
        if (msg.length() > 0) {
            this.warn(msg);
        }
        if (cutype == null) {
            return cutypeMap.getDefaultPath();
        }
        String cutypePath = (String)cutypeMap.get(cutype.toLowerCase());
        if (cutypePath != null) {
            return cutypePath;
        }
        return cutypeMap.getDefaultPath();
    }

    private Set<String> getCutypes(CardDavInfo cdi) {
        cutypeMap.init(cdi.getCutypeMapping());
        return cutypeMap.getCutypes();
    }

    public boolean mergePreferences(BwPreferences prefs, BwPrincipalInfo pinfo) throws CalFacadeException {
        BwPrincipalInfo.IntPrincipalProperty pschedMaxInstances;
        boolean changed = false;
        BwPrincipalInfo.BooleanPrincipalProperty pautoSched = (BwPrincipalInfo.BooleanPrincipalProperty)pinfo.findProperty("auto-schedule");
        if (pautoSched != null && ((Boolean)pautoSched.getVal()).booleanValue() != prefs.getScheduleAutoRespond()) {
            prefs.setScheduleAutoRespond(((Boolean)pautoSched.getVal()).booleanValue());
            if (((Boolean)pautoSched.getVal()).booleanValue()) {
                prefs.setScheduleAutoCancelAction(BwPreferences.scheduleAutoCancelDelete);
            }
            changed = true;
        }
        if ((pschedMaxInstances = (BwPrincipalInfo.IntPrincipalProperty)pinfo.findProperty("max-instances")) != null) {
            int mi = (Integer)pschedMaxInstances.getVal();
            String strMi = String.valueOf(mi);
            BwProperty pmi = prefs.findProperty("userpref:schedule-max-instances");
            if (pmi == null) {
                prefs.addProperty(new BwProperty("userpref:schedule-max-instances", strMi));
            } else if (!pmi.getValue().equals(strMi)) {
                pmi.setValue(strMi);
            }
            changed = true;
        }
        return changed;
    }

    public boolean isPrincipal(String val) throws CalFacadeException {
        return BwPrincipal.isPrincipal((String)val);
    }

    public String accountFromPrincipal(String val) throws CalFacadeException {
        String userProot = this.fromWho.get(1);
        if (!val.startsWith(userProot)) {
            return null;
        }
        String acc = val.substring(userProot.length());
        if (acc.endsWith("/")) {
            acc = acc.substring(0, acc.length() - 1);
        }
        if (acc.indexOf("/") > 0) {
            return null;
        }
        return acc;
    }

    public BwPrincipal getPrincipal(String href) throws CalFacadeException {
        return BwPrincipal.makePrincipal((String)href);
    }

    public String makePrincipalUri(String id, int whoType) throws CalFacadeException {
        if (this.isPrincipal(id)) {
            return id;
        }
        String root = this.fromWho.get(whoType);
        if (root == null) {
            throw new CalFacadeException("org.bedework.exception.unknownprincipaltype");
        }
        return Util.buildPath((boolean)false, (String[])new String[]{root, "/", id});
    }

    public Collection<String> getGroups(String rootUrl, String principalUrl) throws CalFacadeException {
        TreeSet<String> urls = new TreeSet<String>();
        if (principalUrl == null) {
            String r = Util.buildPath((boolean)true, (String[])new String[]{rootUrl});
            if (!r.equals("/principals/") && !r.equals("/principals/users/")) {
                return urls;
            }
            urls.add(Util.buildPath((boolean)false, (String[])new String[]{"/principals/users/", "/", this.cb.getCurrentUser().getAccount()}));
        }
        return urls;
    }

    public String uriToCaladdr(String val) throws CalFacadeException {
        if (this.isPrincipal(val)) {
            return this.userToCaladdr(val);
        }
        boolean isAccount = true;
        int colonPos = val.indexOf(":");
        int atPos = val.indexOf("@");
        String uri = val;
        if (colonPos > 0) {
            if (atPos < colonPos) {
                return null;
            }
            isAccount = false;
        } else if (atPos > 0) {
            uri = "mailto:" + val;
        }
        BwPrincipal possibleAccount = this.caladdrToPrincipal(uri);
        if (possibleAccount != null && !this.validPrincipal(possibleAccount.getPrincipalRef())) {
            return null;
        }
        if (isAccount) {
            uri = this.userToCaladdr(uri);
        }
        return uri;
    }

    public String principalToCaladdr(BwPrincipal val) throws CalFacadeException {
        return this.userToCaladdr(val.getAccount());
    }

    public String userToCaladdr(String val) throws CalFacadeException {
        String ca = userToCalAddrMap.get(val);
        if (ca != null) {
            return ca;
        }
        if (this.isPrincipal(val)) {
            BwPrincipal p = this.getPrincipal(val);
            ca = p.getKind() == 1 ? this.userToCaladdr(p.getAccount()) : val;
            userToCalAddrMap.put(val, ca);
            return ca;
        }
        this.getProps();
        try {
            int atPos = val.indexOf("@");
            boolean hasMailto = val.toLowerCase().startsWith("mailto:");
            if (atPos > 0) {
                if (hasMailto) {
                    return "mailto:" + val.substring(7);
                }
                ca = "mailto:" + val;
                userToCalAddrMap.put(val, ca);
                return ca;
            }
            StringBuilder sb = new StringBuilder();
            if (!hasMailto) {
                sb.append("mailto:");
            }
            sb.append(val);
            sb.append("@");
            sb.append(this.getDefaultDomain());
            ca = sb.toString();
            userToCalAddrMap.put(val, ca);
            return ca;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public BwPrincipal caladdrToPrincipal(String caladdr) throws CalFacadeException {
        try {
            String acc;
            BwPrincipal p;
            block17: {
                int atPos;
                String ca;
                block16: {
                    if (caladdr == null) {
                        throw new CalFacadeException("org.bedework.caladdr.null");
                    }
                    p = calAddrToPrincipalMap.get(caladdr);
                    if (p != null) {
                        return p;
                    }
                    this.getProps();
                    if (this.isPrincipal(caladdr)) {
                        p = this.getPrincipal(caladdr);
                        calAddrToPrincipalMap.put(caladdr, p);
                        return p;
                    }
                    acc = null;
                    ca = caladdr;
                    atPos = ca.indexOf("@");
                    if (atPos > 0) {
                        ca = ca.toLowerCase();
                    }
                    if (this.onlyDomain == null) break block16;
                    if (atPos < 0) {
                        acc = ca;
                    }
                    if (!this.onlyDomain.matches(ca, atPos)) break block17;
                    acc = ca.substring(0, atPos);
                    break block17;
                }
                if (atPos < 0) {
                    acc = ca;
                } else if (this.anyDomain) {
                    acc = ca;
                } else {
                    for (DomainMatcher dm : this.domains) {
                        if (!dm.matches(ca, atPos)) continue;
                        acc = ca;
                        break;
                    }
                }
            }
            if (acc == null) {
                return null;
            }
            if (acc.toLowerCase().startsWith("mailto:")) {
                acc = acc.substring("mailto:".length());
            }
            int whoType = 1;
            for (CAPrefixInfo c : this.getCaPrefixInfo()) {
                if (!acc.startsWith(c.getPrefix())) continue;
                whoType = c.getType();
                break;
            }
            p = this.getPrincipal(this.makePrincipalUri(acc, whoType));
            calAddrToPrincipalMap.put(caladdr, p);
            return p;
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public String normalizeCua(String val) throws CalFacadeException {
        if (val == null) {
            throw new CalFacadeException("org.bedework.caladdr.bad");
        }
        if (val.startsWith("/")) {
            return val;
        }
        int colonPos = val.indexOf(":");
        int atPos = val.indexOf("@");
        if (colonPos > 0) {
            if (atPos < colonPos) {
                throw new CalFacadeException("org.bedework.caladdr.bad");
            }
            return "mailto:" + val.substring(colonPos + 1);
        }
        if (atPos > 0) {
            return "mailto:" + val;
        }
        return "mailto:" + val + "@" + this.getDefaultDomain();
    }

    public String getDefaultDomain() throws CalFacadeException {
        if (this.defaultDomain == null) {
            throw new CalFacadeException("org.bedework.domains.nodefault");
        }
        return this.defaultDomain;
    }

    public String getAdminGroupsIdPrefix() {
        return null;
    }

    protected synchronized boolean lookupValidPrincipal(String href) {
        return validPrincipals.containsKey((Object)href);
    }

    protected void addValidPrincipal(String href) {
        validPrincipals.put((Object)href, (Object)href);
    }

    protected DirConfigProperties getProps() throws CalFacadeException {
        return this.dirProps;
    }

    protected BasicSystemProperties getSystemRoots() throws CalFacadeException {
        if (sysRoots != null) {
            return sysRoots;
        }
        sysRoots = new CalSvcFactoryDefault().getSystemConfig().getBasicSystemProperties();
        return sysRoots;
    }

    protected CalAddrPrefixes getCaPrefixes() throws CalFacadeException {
        return this.caPrefixes;
    }

    protected Collection<CAPrefixInfo> getCaPrefixInfo() throws CalFacadeException {
        if (caPrefixInfo != null) {
            return caPrefixInfo;
        }
        CalAddrPrefixes cap = this.getCaPrefixes();
        ArrayList<CAPrefixInfo> capInfo = new ArrayList<CAPrefixInfo>();
        if (cap != null) {
            this.addCaPrefix(capInfo, cap.getUser(), 1);
            this.addCaPrefix(capInfo, cap.getGroup(), 2);
            this.addCaPrefix(capInfo, cap.getHost(), 3);
            this.addCaPrefix(capInfo, cap.getTicket(), 4);
            this.addCaPrefix(capInfo, cap.getResource(), 5);
            this.addCaPrefix(capInfo, cap.getLocation(), 6);
        }
        caPrefixInfo = Collections.unmodifiableList(capInfo);
        return caPrefixInfo;
    }

    private void addCaPrefix(List<CAPrefixInfo> capInfo, String prefix, int type) {
        if (prefix == null) {
            return;
        }
        capInfo.add(new CAPrefixInfo(prefix, type));
    }

    protected CardDavInfo getCardDavInfo(boolean auth) throws CalFacadeException {
        if (auth) {
            return this.authCdinfo;
        }
        return this.unauthCdinfo;
    }

    private void setDomains() {
        String prDomains = this.dirProps.getDomains();
        if (prDomains.equals("*")) {
            this.anyDomain = true;
        } else if (prDomains.indexOf(",") < 0 && !prDomains.startsWith("*")) {
            this.onlyDomain = new DomainMatcher(prDomains);
        } else {
            this.domains = new ArrayList<DomainMatcher>();
            for (String domain : this.dirProps.getDomains().split(",")) {
                this.domains.add(new DomainMatcher(domain));
            }
        }
        this.defaultDomain = this.dirProps.getDefaultDomain();
        if (this.defaultDomain == null && this.onlyDomain != null) {
            this.defaultDomain = prDomains;
        }
    }

    private List<MatchResult> matching(BasicHttpClient cl, String url, String addrDataCtype, List<WebdavProperty> props) throws CalFacadeException {
        ArrayList<MatchResult> arrayList;
        try {
            XmlEmit xml = new XmlEmit();
            xml.addNs(new XmlEmit.NameSpace("DAV:", "DAV"), true);
            xml.addNs(new XmlEmit.NameSpace("urn:ietf:params:xml:ns:carddav", "C"), false);
            StringWriter sw = new StringWriter();
            xml.startEmit((Writer)sw);
            xml.openTag(CarddavTags.addressbookQuery);
            xml.openTag(WebdavTags.prop);
            xml.emptyTag(WebdavTags.getetag);
            if (addrDataCtype == null) {
                xml.emptyTag(CarddavTags.addressData);
            } else {
                xml.emptyTag(CarddavTags.addressData, "content-type", addrDataCtype);
            }
            xml.closeTag(WebdavTags.prop);
            xml.openTag(CarddavTags.filter, "test", "anyof");
            for (WebdavProperty wd : props) {
                if (wd.getTag().equals(CaldavTags.calendarUserType)) continue;
                if (wd.getTag().equals(BedeworkServerTags.emailProp)) {
                    xml.openTag(CarddavTags.propFilter, "name", "EMAIL");
                    xml.startTagSameLine(CarddavTags.textMatch);
                    xml.attribute("collation", "i;unicode-casemap");
                    xml.attribute("match-type", "contains");
                    xml.endOpeningTag();
                    xml.value(wd.getPval());
                    xml.closeTagSameLine(CarddavTags.textMatch);
                    xml.closeTag(CarddavTags.propFilter);
                    continue;
                }
                if (!wd.getTag().equals(WebdavTags.displayname)) continue;
                xml.openTag(CarddavTags.propFilter, "name", "FN");
                xml.startTagSameLine(CarddavTags.textMatch);
                xml.attribute("collation", "i;unicode-casemap");
                xml.attribute("match-type", "contains");
                xml.endOpeningTag();
                xml.value(wd.getPval());
                xml.closeTagSameLine(CarddavTags.textMatch);
                xml.closeTag(CarddavTags.propFilter);
            }
            xml.closeTag(CarddavTags.filter);
            xml.closeTag(CarddavTags.addressbookQuery);
            DavUtil du = new DavUtil();
            byte[] content = sw.toString().getBytes();
            int res = du.sendRequest(cl, "REPORT", url, (Header)new BasicHeader("depth", "infinity"), "text/xml", content.length, content);
            int SC_MULTI_STATUS = 207;
            if (res != 207) {
                if (this.debug) {
                    this.debug("Got response " + res + " for path " + url);
                }
                List<MatchResult> list = null;
                return list;
            }
            ArrayList<MatchResult> mrs = new ArrayList<MatchResult>();
            DavUtil.MultiStatusResponse msr = du.getMultiStatusResponse(cl.getResponseBodyAsStream());
            for (DavUtil.MultiStatusResponseElement msre : msr.responses) {
                MatchResult mr = new MatchResult();
                mrs.add(mr);
                mr.href = msre.href;
                for (DavUtil.PropstatElement pe : msre.propstats) {
                    if (pe.status != 200) continue;
                    for (Element e : pe.props) {
                        if (XmlUtil.nodeMatches((Node)e, (QName)WebdavTags.getetag)) {
                            mr.etag = XmlUtil.getElementContent((Element)e);
                            continue;
                        }
                        if (!XmlUtil.nodeMatches((Node)e, (QName)CarddavTags.addressData)) continue;
                        mr.card = XmlUtil.getElementContent((Element)e);
                    }
                }
            }
            arrayList = mrs;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            try {
                cl.release();
            }
            catch (Throwable throwable) {}
        }
        return arrayList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getCard(BasicHttpClient cl, String context, AccessPrincipal p) throws CalFacadeException {
        try {
            String string;
            StringBuilder card;
            block49: {
                StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<D:propfind xmlns:D=\"DAV:\"\n            xmlns:C=\"urn:ietf:params:xml:ns:carddav\">\n  <D:prop>\n    <C:principal-address/>\n  </D:prop>\n</D:propfind>\n");
                byte[] content = sb.toString().getBytes();
                int res = cl.sendRequest("PROPFIND", context + p.getPrincipalRef(), Collections.singletonList(DavUtil.depth0), "text/xml", content.length, content);
                int SC_MULTI_STATUS = 207;
                if (res != SC_MULTI_STATUS) {
                    String string2 = null;
                    return string2;
                }
                DavUtil du = new DavUtil();
                DavUtil.MultiStatusResponse msr = du.getMultiStatusResponse(cl.getResponseBodyAsStream());
                if (msr.responses.size() != 1) {
                    throw new CalFacadeException("Bad response. Expected exactly 1 response element");
                }
                DavUtil.MultiStatusResponseElement msre = (DavUtil.MultiStatusResponseElement)msr.responses.get(0);
                if (msre.propstats.size() != 1) {
                    if (this.debug) {
                        this.debug("Found " + msre.propstats.size() + " propstat elements");
                    }
                    String string3 = null;
                    return string3;
                }
                DavUtil.PropstatElement pse = (DavUtil.PropstatElement)msre.propstats.get(0);
                if (pse.status != 200) {
                    if (this.debug) {
                        this.debug("propstat status was " + pse.status);
                    }
                    String string4 = null;
                    return string4;
                }
                if (pse.props.size() != 1) {
                    if (this.debug) {
                        this.debug("Found " + pse.props.size() + " prop elements");
                    }
                    String string5 = null;
                    return string5;
                }
                Element pr = (Element)pse.props.iterator().next();
                if (!XmlUtil.nodeMatches((Node)pr, (QName)CarddavTags.principalAddress)) {
                    if (this.debug) {
                        this.debug("Expected principal-address - found " + pr);
                    }
                    String string6 = null;
                    return string6;
                }
                Element hrefEl = DavUtil.getOnlyChild((Node)pr);
                if (!XmlUtil.nodeMatches((Node)hrefEl, (QName)WebdavTags.href)) {
                    if (this.debug) {
                        this.debug("Expected href element for principal-address - found " + hrefEl);
                    }
                    String string7 = null;
                    return string7;
                }
                String href = URLDecoder.decode(XmlUtil.getElementContent((Element)hrefEl), "UTF-8");
                InputStream is = cl.get(href);
                if (is == null) {
                    String string8 = null;
                    return string8;
                }
                LineNumberReader lnr = new LineNumberReader(new InputStreamReader(is));
                card = new StringBuilder();
                while (true) {
                    String ln;
                    if ((ln = lnr.readLine()) == null) {
                        if (card.length() == 0) {
                            break;
                        }
                        break block49;
                    }
                    card.append(ln);
                    card.append("\n");
                }
                string = null;
                return string;
            }
            string = card.toString();
            return string;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            try {
                cl.release();
            }
            catch (Throwable throwable) {}
        }
    }

    private void initWhoMaps(String prefix, int whoType) {
        this.toWho.put(prefix, whoType);
        this.fromWho.put(whoType, prefix);
    }

    static {
        validPrincipals = new FlushMap(300000L, 0);
        principalInfoMap = new FlushMap(300000L, 0);
        cutypeMap = new CutypeMap();
        userToCalAddrMap = new FlushMap(300000L, 3000);
        calAddrToPrincipalMap = new FlushMap(300000L, 3000);
    }

    private static class MatchResult {
        String href;
        String etag;
        String card;

        private MatchResult() {
        }
    }

    private static class CalAddr {
        private String scheme;
        private String id;
        private String domain;

        CalAddr(String val) {
            int atPos = val.indexOf("@");
            if (atPos > 0) {
                this.domain = val.substring(atPos + 1).toLowerCase();
                this.id = val.substring(0, atPos);
            } else {
                this.id = val;
            }
            int colonPos = this.id.indexOf(":");
            if (colonPos > 0) {
                this.scheme = this.id.substring(0, colonPos);
                this.id = this.id.substring(colonPos + 1);
            }
        }

        String getScheme() {
            return this.scheme;
        }

        String getId() {
            return this.id;
        }

        String getDomain() {
            return this.domain;
        }

        String getNoScheme() {
            if (this.domain == null) {
                return this.id;
            }
            return this.id + "@" + this.domain;
        }
    }

    private static class CutypeMap
    extends HashMap<String, String> {
        String configValue;
        String defaultPath;

        private CutypeMap() {
        }

        String init(String configValue) {
            if (configValue == null) {
                this.clear();
                this.defaultPath = "/directory/";
                return "No cutype mapping in carddav info";
            }
            if (configValue.equals(this.configValue)) {
                return "";
            }
            this.configValue = configValue;
            String[] split = configValue.split(",");
            String err = "";
            for (String s : split) {
                String[] keyVal = s.split(":");
                if (keyVal.length != 2) {
                    err = err + "\nBad value in cutype mapping: " + s;
                    continue;
                }
                if (keyVal[0].equals("*")) {
                    if (this.defaultPath != null) {
                        err = err + "\nMore than one default path in cutype mapping";
                        continue;
                    }
                    this.defaultPath = keyVal[1];
                    continue;
                }
                this.put(keyVal[0], keyVal[1]);
            }
            if (this.defaultPath == null) {
                err = err + "\nNo default path in cutype mapping";
                this.defaultPath = "/directory/";
            }
            return err;
        }

        String getDefaultPath() {
            return this.defaultPath;
        }

        Set<String> getCutypes() {
            return this.keySet();
        }
    }

    private static class DomainMatcher
    implements Serializable {
        String pattern;
        boolean exact;

        DomainMatcher(String pattern) {
            this.pattern = pattern;
            if (!pattern.startsWith("*")) {
                this.pattern = pattern;
                this.exact = true;
            } else {
                this.pattern = pattern.substring(1);
            }
        }

        boolean matches(String val, int atPos) {
            if (atPos < 0) {
                return false;
            }
            int start = atPos + 1;
            int domainLen = val.length() - start;
            if (this.exact ? domainLen != this.pattern.length() : domainLen < this.pattern.length()) {
                return false;
            }
            return val.endsWith(this.pattern);
        }

        boolean matches(String domain) {
            int domainLen = domain.length();
            if (this.exact ? domainLen != this.pattern.length() : domainLen < this.pattern.length()) {
                return false;
            }
            return domain.endsWith(this.pattern);
        }
    }

    public static class CAPrefixInfo {
        private String prefix;
        private int type;

        CAPrefixInfo(String prefix, int type) {
            this.prefix = prefix;
            this.type = type;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public int getType() {
            return this.type;
        }
    }
}

