/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.util.Collection;
import org.apache.log4j.Logger;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.UserAuth;

public class UserAuthUWDbImpl
implements UserAuth {
    private boolean debug;
    private transient Logger log;
    protected UserAuth.CallBack cb;

    public void initialise(UserAuth.CallBack cb) throws CalFacadeException {
        this.cb = cb;
        this.debug = this.getLogger().isDebugEnabled();
    }

    public void addUser(BwAuthUser val) throws CalFacadeException {
        if (val.isUnauthorized()) {
            return;
        }
        this.cb.add(val);
    }

    public boolean getUserMaintOK() {
        return true;
    }

    public void updateUser(BwAuthUser val) throws CalFacadeException {
        if (val.isUnauthorized()) {
            this.cb.delete(val);
            return;
        }
        this.cb.update(val);
    }

    public BwAuthUser getUser(String account) throws CalFacadeException {
        BwPrincipal p;
        if (this.debug) {
            this.trace("getUserEntry for " + account);
        }
        if ((p = this.cb.getPrincipal(account)) == null) {
            return null;
        }
        return this.cb.getAuthUser(p.getPrincipalRef());
    }

    public Collection<BwAuthUser> getAll() throws CalFacadeException {
        return this.cb.getAll();
    }

    private Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }

    private void trace(String msg) {
        this.getLogger().debug((Object)("trace: " + msg));
    }
}

