/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.jmx;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import org.bedework.calfacade.configs.AuthProperties;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.configs.CardDavInfo;
import org.bedework.calfacade.configs.CmdUtilProperties;
import org.bedework.calfacade.configs.Configurations;
import org.bedework.calfacade.configs.DirConfigProperties;
import org.bedework.calfacade.configs.DumpRestoreProperties;
import org.bedework.calfacade.configs.IndexProperties;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calfacade.configs.SynchConfig;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.mail.MailConfigProperties;
import org.bedework.calsvc.jmx.AuthConf;
import org.bedework.calsvc.jmx.BasicSystemPropertiesImpl;
import org.bedework.calsvc.jmx.CardDavInfoConf;
import org.bedework.calsvc.jmx.DirConf;
import org.bedework.calsvc.jmx.DirConfigPropertiesImpl;
import org.bedework.calsvc.jmx.MailerConf;
import org.bedework.calsvc.jmx.NotificationConf;
import org.bedework.calsvc.jmx.ROAuthProperties;
import org.bedework.calsvc.jmx.ROBasicSystemProperties;
import org.bedework.calsvc.jmx.ROSystemProperties;
import org.bedework.calsvc.jmx.SynchConf;
import org.bedework.calsvc.jmx.SystemConf;
import org.bedework.calsvc.sysmon.BwSysMonitor;
import org.bedework.indexer.BwIndexCtlMBean;
import org.bedework.sysevents.listeners.BwSysevLogger;
import org.bedework.util.config.ConfigBase;
import org.bedework.util.config.ConfigurationStore;
import org.bedework.util.http.service.HttpConfig;
import org.bedework.util.http.service.HttpOut;
import org.bedework.util.jmx.BaseMBean;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.security.keys.GenKeys;
import org.bedework.util.servlet.io.PooledBuffers;

public final class ConfigurationsImpl
extends ConfBase<BasicSystemPropertiesImpl>
implements Configurations {
    private static boolean configured;
    private static BasicSystemProperties basicProps;
    private static AuthProperties authProperties;
    private static AuthProperties unAuthProperties;
    private static SystemProperties sysProperties;
    private static MailConfigProperties mailProps;
    private static NotificationProperties notificationProps;
    private static SynchConfig synchProps;
    private static CardDavInfo unauthCardDavInfo;
    private static CardDavInfo authCardDavInfo;
    private static HttpConfig httpConfig;
    private static PooledBuffers pooledBuffers;
    private final Map<String, DirConfigProperties> dirConfigs = new HashMap<String, DirConfigProperties>();
    private static final String cmdUtilClass = "org.bedework.tools.cmdutil.CmdUtil";
    private static final String dumpRestoreClass = "org.bedework.dumprestore.BwDumpRestore";
    private static ConfBase dumpRestore;
    private static CmdUtilProperties cmdUtilProperties;
    private static DumpRestoreProperties dumpRestoreProperties;
    private static final String indexerCtlClass = "org.bedework.indexer.BwIndexCtl";
    private static BwIndexCtlMBean indexCtl;
    private static IndexProperties indexProperties;
    private static final String chgnoteClass = "org.bedework.chgnote.BwChgNote";
    private static final String inoutClass = "org.bedework.inoutsched.BwInoutSched";

    public ConfigurationsImpl() throws CalFacadeException {
        super("org.bedework.bwengine:service=Conf");
        this.setConfigName("basicSystem");
        this.setConfigPname("org.bedework.bwengine.confuri");
        try {
            this.checkMbeansInstalled();
            authProperties = new ROAuthProperties(this.getAuthProps(true));
            unAuthProperties = new ROAuthProperties(this.getAuthProps(false));
            sysProperties = new ROSystemProperties(this.getSystemProps());
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public String loadConfig() {
        return null;
    }

    public BasicSystemProperties getBasicSystemProperties() {
        return basicProps;
    }

    public AuthProperties getAuthProperties(boolean auth) {
        if (auth) {
            return authProperties;
        }
        return unAuthProperties;
    }

    public SystemProperties getSystemProperties() {
        return sysProperties;
    }

    public HttpConfig getHttpConfig() {
        return httpConfig;
    }

    public DumpRestoreProperties getDumpRestoreProperties() {
        return dumpRestoreProperties;
    }

    public IndexProperties getIndexProperties() {
        return indexProperties;
    }

    public MailConfigProperties getMailConfigProperties() {
        return mailProps;
    }

    public NotificationProperties getNotificationProps() {
        return notificationProps;
    }

    public SynchConfig getSynchConfig() {
        return synchProps;
    }

    public DirConfigProperties getDirConfig(String name) {
        return this.dirConfigs.get(name);
    }

    public CardDavInfo getCardDavInfo(boolean auth) {
        if (auth) {
            return authCardDavInfo;
        }
        return unauthCardDavInfo;
    }

    public static ObjectName getUnauthpropsName() throws CalFacadeException {
        try {
            return new ObjectName(SystemConf.getServiceName("unauthSystem"));
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static ObjectName getAuthpropsName() throws CalFacadeException {
        try {
            return new ObjectName(SystemConf.getServiceName("authSystem"));
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public static ObjectName getSyspropsName() throws CalFacadeException {
        try {
            return new ObjectName(SystemConf.getServiceName("system"));
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private synchronized void checkMbeansInstalled() throws CalFacadeException {
        if (configured) {
            return;
        }
        try {
            ConfigurationsImpl.getManagementContext().start();
            this.loadConfig(BasicSystemPropertiesImpl.class);
            ((BasicSystemPropertiesImpl)this.cfg).setTestMode(Boolean.getBoolean("org.bedework.testmode"));
            basicProps = new ROBasicSystemProperties((BasicSystemProperties)this.cfg);
            AuthConf conf = new AuthConf("unauthSystem");
            this.register(ConfigurationsImpl.getUnauthpropsName(), conf);
            conf.loadConfig();
            conf = new AuthConf("authSystem");
            this.register(ConfigurationsImpl.getAuthpropsName(), conf);
            conf.loadConfig();
            SystemConf sconf = new SystemConf("system");
            this.register(ConfigurationsImpl.getSyspropsName(), sconf);
            sconf.loadConfig();
            NotificationConf nc = new NotificationConf();
            this.register(new ObjectName(nc.getServiceName()), nc);
            nc.loadConfig();
            notificationProps = (NotificationProperties)nc.getConfig();
            MailerConf mc = new MailerConf();
            this.register(new ObjectName(mc.getServiceName()), mc);
            mc.loadConfig();
            mailProps = (MailConfigProperties)mc.getConfig();
            HttpOut ho = new HttpOut("org.bedework.bwengine.confuri", "org.bedework.bwengine", "httpConfig");
            this.register(new ObjectName(ho.getServiceName()), ho);
            ho.loadConfig();
            httpConfig = (HttpConfig)ho.getConfig();
            BwSysevLogger sysev = new BwSysevLogger();
            this.register(new ObjectName("org.bedework.bwengine:service=BwSysevLogger"), sysev);
            sysev.start();
            BwSysMonitor sysmon = new BwSysMonitor();
            this.register(new ObjectName("org.bedework.bwengine:service=BwSysMonitor"), (Object)sysmon);
            sysmon.start();
            GenKeys gk = new GenKeys("org.bedework.bwengine.confuri");
            this.register(new ObjectName("org.bedework.util:service=BwGenKeys"), gk);
            gk.loadConfig();
            PooledBuffers pb = new PooledBuffers();
            this.register(new ObjectName(pb.getServiceName()), pb);
            SynchConf sc = new SynchConf();
            this.register(new ObjectName(sc.getServiceName()), sc);
            sc.loadConfig();
            synchProps = (SynchConfig)sc.getConfig();
            this.loadDirConfigs();
            configured = true;
            this.startChgNote();
            this.loadCardDav();
            this.loadCmdUtil();
            this.loadDumpRestore();
            this.startIndexing();
            this.startScheduling();
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
        finally {
            if (!configured) {
                this.stop();
            }
        }
    }

    private void startChgNote() throws Throwable {
        ConfBase cb = ConfigurationsImpl.loadInstance(chgnoteClass);
        this.register(new ObjectName(cb.getServiceName()), cb);
        cb.start();
    }

    private void loadCardDav() throws Throwable {
        unauthCardDavInfo = (CardDavInfo)this.load(new CardDavInfoConf("unauthCardDav"), false);
        authCardDavInfo = (CardDavInfo)this.load(new CardDavInfoConf("authCardDav"), false);
    }

    private void loadCmdUtil() throws Throwable {
        cmdUtilProperties = (CmdUtilProperties)this.load(ConfigurationsImpl.loadInstance(cmdUtilClass), false);
    }

    private void loadDumpRestore() throws Throwable {
        dumpRestoreProperties = (DumpRestoreProperties)this.load(ConfigurationsImpl.loadInstance(dumpRestoreClass), false);
    }

    private void startIndexing() throws Throwable {
        indexProperties = (IndexProperties)this.load(ConfigurationsImpl.loadInstance(indexerCtlClass), true);
    }

    private void startScheduling() throws Throwable {
        this.load(ConfigurationsImpl.loadInstance(inoutClass), true);
    }

    private ConfigBase load(ConfBase cb, boolean start) throws Throwable {
        this.register(new ObjectName(cb.getServiceName()), cb);
        cb.loadConfig();
        if (start) {
            cb.start();
        }
        return cb.getConfig();
    }

    private void loadDirConfigs() throws Throwable {
        ConfigurationStore cs = this.getStore().getStore("dirconfigs");
        List names = cs.getConfigs();
        for (String dn : names) {
            ObjectName objectName = this.createObjectName("dirconfig", dn);
            DirConfigPropertiesImpl dCfg = (DirConfigPropertiesImpl)cs.getConfig(dn);
            if (dCfg == null) {
                this.error("Unable to read directory configuration " + dn);
                continue;
            }
            String mbeanClassName = dCfg.getMbeanClassName();
            if (mbeanClassName == null) {
                this.error("Must set the mbean class name for connector " + dn);
                this.error("Falling back to base class for " + dn);
                mbeanClassName = DirConf.class.getCanonicalName();
            }
            DirConf dc = (DirConf)ConfigurationsImpl.makeObject((String)mbeanClassName);
            dc.init(cs, objectName.toString(), dCfg, dn);
            this.dirConfigs.put(dn, dc);
            this.register(new ObjectName(dc.getServiceName()), dc);
        }
    }

    private AuthProperties getAuthProps(boolean auth) throws CalFacadeException {
        try {
            ObjectName mbeanName = !auth ? ConfigurationsImpl.getUnauthpropsName() : ConfigurationsImpl.getAuthpropsName();
            return (AuthProperties)ConfigurationsImpl.getManagementContext().getAttribute(mbeanName, "Config");
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private static ConfBase loadInstance(String cname) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> cl = loader.loadClass(cname);
            if (cl == null) {
                throw new CalFacadeException("Class " + cname + " not found");
            }
            Object o = cl.newInstance();
            if (o == null) {
                throw new CalFacadeException("Unable to instantiate class " + cname);
            }
            return (ConfBase)o;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private SystemProperties getSystemProps() throws CalFacadeException {
        try {
            ObjectName mbeanName = ConfigurationsImpl.getSyspropsName();
            return (SystemProperties)ConfigurationsImpl.getManagementContext().getAttribute(mbeanName, "Config");
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    public void stop() {
        for (Object o : this.getRegisteredMBeans()) {
            if (!(o instanceof BaseMBean)) continue;
            try {
                ((BaseMBean)o).stop();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            ConfigurationsImpl.getManagementContext().stop();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

