/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.jmx;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.calfacade.BwStats;
import org.bedework.calfacade.configs.SystemProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.ifs.IfInfo;
import org.bedework.calsvc.jmx.SystemConfMBean;
import org.bedework.calsvc.jmx.SystemPropertiesImpl;
import org.bedework.calsvci.CalSvcFactoryDefault;
import org.bedework.calsvci.CalSvcI;
import org.bedework.calsvci.CalSvcIPars;
import org.bedework.util.config.ConfInfo;
import org.bedework.util.jmx.ConfBase;
import org.bedework.util.jmx.ConfigHolder;

public class SystemConf
extends ConfBase<SystemPropertiesImpl>
implements SystemConfMBean,
ConfigHolder<SystemPropertiesImpl> {
    public static final String confuriPname = "org.bedework.bwengine.confuri";
    private CalSvcI svci;
    private boolean running;
    private static final Set<String> dontKill = new TreeSet<String>();
    private AutoKillThread autoKiller;

    public SystemConf(String name) {
        super(SystemConf.getServiceName(name));
        this.setConfigName(name);
        this.setConfigPname(confuriPname);
    }

    public static String getServiceName(String name) {
        return "org.bedework.bwengine:service=" + name;
    }

    public void setTzid(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setTzid(val);
    }

    public String getTzid() {
        return ((SystemPropertiesImpl)this.getConfig()).getTzid();
    }

    public void setTzServeruri(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setTzServeruri(val);
    }

    public String getTzServeruri() {
        return ((SystemPropertiesImpl)this.getConfig()).getTzServeruri();
    }

    public void setSystemid(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setSystemid(val);
    }

    public String getSystemid() {
        return ((SystemPropertiesImpl)this.getConfig()).getSystemid();
    }

    public void setRootUsers(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setRootUsers(val);
    }

    public String getRootUsers() {
        return ((SystemPropertiesImpl)this.getConfig()).getRootUsers();
    }

    public void setFeatureFlags(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setFeatureFlags(val);
    }

    public String getFeatureFlags() {
        return ((SystemPropertiesImpl)this.getConfig()).getFeatureFlags();
    }

    public void setAdminContact(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setAdminContact(val);
    }

    public String getAdminContact() {
        return ((SystemPropertiesImpl)this.getConfig()).getAdminContact();
    }

    public void setIscheduleURI(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setIscheduleURI(val);
    }

    public String getIscheduleURI() {
        return ((SystemPropertiesImpl)this.getConfig()).getIscheduleURI();
    }

    public void setFburlServiceURI(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setFburlServiceURI(val);
    }

    public String getFburlServiceURI() {
        return ((SystemPropertiesImpl)this.getConfig()).getFburlServiceURI();
    }

    public void setWebcalServiceURI(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setWebcalServiceURI(val);
    }

    public String getWebcalServiceURI() {
        return ((SystemPropertiesImpl)this.getConfig()).getWebcalServiceURI();
    }

    public void setCalSoapWsURI(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setCalSoapWsURI(val);
    }

    public String getCalSoapWsURI() {
        return ((SystemPropertiesImpl)this.getConfig()).getCalSoapWsURI();
    }

    public void setCalSoapWsWSDLURI(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setCalSoapWsWSDLURI(val);
    }

    public String getCalSoapWsWSDLURI() {
        return ((SystemPropertiesImpl)this.getConfig()).getCalSoapWsWSDLURI();
    }

    public void setTimezonesByReference(boolean val) {
        ((SystemPropertiesImpl)this.getConfig()).setTimezonesByReference(val);
    }

    public boolean getTimezonesByReference() {
        return ((SystemPropertiesImpl)this.getConfig()).getTimezonesByReference();
    }

    public void setUserauthClass(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setUserauthClass(val);
    }

    public String getUserauthClass() {
        return ((SystemPropertiesImpl)this.getConfig()).getUserauthClass();
    }

    public void setMailerClass(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setMailerClass(val);
    }

    public String getMailerClass() {
        return ((SystemPropertiesImpl)this.getConfig()).getMailerClass();
    }

    public void setAdmingroupsClass(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setAdmingroupsClass(val);
    }

    public String getAdmingroupsClass() {
        return ((SystemPropertiesImpl)this.getConfig()).getAdmingroupsClass();
    }

    public void setUsergroupsClass(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setUsergroupsClass(val);
    }

    public String getUsergroupsClass() {
        return ((SystemPropertiesImpl)this.getConfig()).getUsergroupsClass();
    }

    public void setLocaleList(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setLocaleList(val);
    }

    public String getLocaleList() {
        return ((SystemPropertiesImpl)this.getConfig()).getLocaleList();
    }

    public void setSocketToken(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setSocketToken(val);
    }

    public String getSocketToken() {
        return ((SystemPropertiesImpl)this.getConfig()).getSocketToken();
    }

    public void setEventregAdminToken(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setEventregAdminToken(val);
    }

    public String getEventregAdminToken() {
        return ((SystemPropertiesImpl)this.getConfig()).getEventregAdminToken();
    }

    public void setEventregUrl(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setEventregUrl(val);
    }

    public String getEventregUrl() {
        return ((SystemPropertiesImpl)this.getConfig()).getEventregUrl();
    }

    public void setCacheUrlPrefix(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setCacheUrlPrefix(val);
    }

    public String getCacheUrlPrefix() {
        return ((SystemPropertiesImpl)this.getConfig()).getCacheUrlPrefix();
    }

    public void setAutoKillMinutes(int val) {
        ((SystemPropertiesImpl)this.getConfig()).setAutoKillMinutes(val);
    }

    public int getAutoKillMinutes() {
        return ((SystemPropertiesImpl)this.getConfig()).getAutoKillMinutes();
    }

    public void setSuggestionEnabled(boolean val) {
        ((SystemPropertiesImpl)this.getConfig()).setSuggestionEnabled(val);
    }

    public boolean getSuggestionEnabled() {
        return ((SystemPropertiesImpl)this.getConfig()).getSuggestionEnabled();
    }

    public void setWorkflowEnabled(boolean val) {
        ((SystemPropertiesImpl)this.getConfig()).setWorkflowEnabled(val);
    }

    public boolean getWorkflowEnabled() {
        return ((SystemPropertiesImpl)this.getConfig()).getWorkflowEnabled();
    }

    public void setWorkflowRoot(String val) {
        ((SystemPropertiesImpl)this.getConfig()).setWorkflowRoot(val);
    }

    public String getWorkflowRoot() {
        return ((SystemPropertiesImpl)this.getConfig()).getWorkflowRoot();
    }

    public void setUserSubscriptionsOnly(boolean val) {
        ((SystemPropertiesImpl)this.getConfig()).setUserSubscriptionsOnly(val);
    }

    public boolean getUserSubscriptionsOnly() {
        return ((SystemPropertiesImpl)this.getConfig()).getUserSubscriptionsOnly();
    }

    @Override
    public int getAutoKillTerminated() {
        return this.autoKiller.terminated;
    }

    @Override
    public int getAutoKillFailedTerminations() {
        return this.autoKiller.failedTerminations;
    }

    public void setVpollMaxItems(Integer val) {
        ((SystemPropertiesImpl)this.getConfig()).setVpollMaxItems(val);
    }

    public Integer getVpollMaxItems() {
        return ((SystemPropertiesImpl)this.getConfig()).getVpollMaxItems();
    }

    public void setVpollMaxActive(Integer val) {
        ((SystemPropertiesImpl)this.getConfig()).setVpollMaxActive(val);
    }

    public Integer getVpollMaxActive() {
        return ((SystemPropertiesImpl)this.getConfig()).getVpollMaxActive();
    }

    public void setVpollMaxVoters(Integer val) {
        ((SystemPropertiesImpl)this.getConfig()).setVpollMaxVoters(val);
    }

    public Integer getVpollMaxVoters() {
        return ((SystemPropertiesImpl)this.getConfig()).getVpollMaxVoters();
    }

    public void setSyseventsProperties(List<String> val) {
        ((SystemPropertiesImpl)this.getConfig()).setSyseventsProperties(val);
    }

    @ConfInfo(collectionElementName="syseventsProperty", elementType="java.lang.String")
    public List<String> getSyseventsProperties() {
        return ((SystemPropertiesImpl)this.getConfig()).getSyseventsProperties();
    }

    public void addSyseventsProperty(String name, String val) {
        ((SystemPropertiesImpl)this.getConfig()).addSyseventsProperty(name, val);
    }

    public String getSyseventsProperty(String name) {
        return ((SystemPropertiesImpl)this.getConfig()).getSyseventsProperty(name);
    }

    public void removeSyseventsProperty(String name) {
        ((SystemPropertiesImpl)this.getConfig()).removeSyseventsProperty(name);
    }

    public void setSyseventsProperty(String name, String val) {
        ((SystemPropertiesImpl)this.getConfig()).setSyseventsProperty(name, val);
    }

    @Override
    public void setDbStatsEnabled(boolean enable) {
        try {
            this.getSvci();
            if (this.svci != null) {
                this.svci.setDbStatsEnabled(enable);
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
        finally {
            this.closeSvci();
        }
    }

    @Override
    public boolean getDbStatsEnabled() {
        try {
            this.getSvci();
            boolean bl = this.svci != null && this.svci.getDbStatsEnabled();
            return bl;
        }
        catch (Throwable t) {
            this.error(t);
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSvci();
        }
    }

    @Override
    public BwStats getStats() {
        try {
            this.getSvci();
            if (this.svci == null) {
                BwStats bwStats = null;
                return bwStats;
            }
            BwStats bwStats = this.svci.getStats();
            return bwStats;
        }
        catch (Throwable t) {
            this.error(t);
            BwStats bwStats = null;
            return bwStats;
        }
        finally {
            this.closeSvci();
        }
    }

    @Override
    public void dumpDbStats() {
        try {
            this.getSvci();
            if (this.svci != null) {
                this.svci.dumpDbStats();
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
        finally {
            this.closeSvci();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String listOpenIfs() {
        StringBuilder sb = new StringBuilder();
        try {
            this.getSvci();
            if (this.svci != null) {
                for (IfInfo ifInfo : this.svci.getActiveIfInfos()) {
                    sb.append(ifInfo.getId());
                    sb.append("\t");
                    sb.append(ifInfo.getLastStateTime());
                    sb.append("\t");
                    sb.append(ifInfo.getState());
                    sb.append("\t");
                    sb.append(ifInfo.getSeconds());
                    sb.append("\n");
                }
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
        finally {
            this.closeSvci();
        }
        return sb.toString();
    }

    public String loadConfig() {
        String res = this.loadConfig(SystemPropertiesImpl.class);
        try {
            this.autoKiller = new AutoKillThread();
            this.running = true;
            this.autoKiller.start();
        }
        catch (Throwable t) {
            this.error(t);
            this.error("Unable to start autokill process");
        }
        return res;
    }

    public void putConfig() {
        this.saveConfig();
    }

    public SystemProperties cloneIt() {
        return null;
    }

    private CalSvcI getSvci() throws CalFacadeException {
        if (this.getConfig() == null) {
            return null;
        }
        if (this.svci != null && this.svci.isOpen()) {
            return this.svci;
        }
        if (this.getRootUsers() == null) {
            return null;
        }
        String[] rootUsers = this.getRootUsers().split(",");
        if (rootUsers.length == 0 || rootUsers[0] == null) {
            return null;
        }
        CalSvcIPars pars = CalSvcIPars.getServicePars((String)this.getServiceName(), (String)rootUsers[0], (boolean)true, (boolean)true);
        this.svci = new CalSvcFactoryDefault().getSvc(pars);
        this.svci.open();
        this.svci.beginTransaction();
        return this.svci;
    }

    private void closeSvci() {
        if (this.svci == null || !this.svci.isOpen()) {
            return;
        }
        try {
            this.svci.endTransaction();
        }
        catch (Throwable t) {
            try {
                this.svci.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            this.svci.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        dontKill.add("indexer");
        dontKill.add("restore");
    }

    private class AutoKillThread
    extends Thread {
        int ctr;
        boolean showedTrace;
        int terminated;
        int failedTerminations;

        AutoKillThread() {
            super("Bedework AutoKill");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (SystemConf.this.running) {
                int waitMins = SystemConf.this.getAutoKillMinutes();
                try {
                    if (waitMins == 0) {
                        ++this.ctr;
                        if (this.ctr == 10) {
                            SystemConf.this.info(SystemConf.this.listOpenIfs());
                            this.ctr = 0;
                        }
                    } else {
                        if (SystemConf.this.debug) {
                            SystemConf.this.debug("About to check interfaces");
                        }
                        this.checkIfs(waitMins * 60);
                    }
                }
                catch (Throwable t) {
                    if (!this.showedTrace) {
                        SystemConf.this.error(t);
                        this.showedTrace = true;
                    }
                    SystemConf.this.error(t.getMessage());
                }
                if (!SystemConf.this.running) continue;
                try {
                    AutoKillThread t = this;
                    synchronized (t) {
                        int wait = waitMins == 0 ? 60000 : waitMins * 60 * 1000;
                        this.wait(wait);
                    }
                }
                catch (Throwable t) {
                    SystemConf.this.error(t.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkIfs(int waitSecs) {
            try {
                SystemConf.this.getSvci();
                if (SystemConf.this.svci != null) {
                    for (IfInfo ifInfo : SystemConf.this.svci.getActiveIfInfos()) {
                        if (ifInfo.getSeconds() <= (long)waitSecs) continue;
                        if (ifInfo.getDontKill()) {
                            SystemConf.this.warn("Skipping dontKill task: " + ifInfo.getId());
                            continue;
                        }
                        if (dontKill.contains(ifInfo.getLogid())) {
                            SystemConf.this.warn("Skipping long running task: " + ifInfo.getId());
                            continue;
                        }
                        try {
                            if (SystemConf.this.debug) {
                                SystemConf.this.debug("About to shut down interface " + ifInfo.getId());
                            }
                            SystemConf.this.svci.kill(ifInfo);
                            ++this.terminated;
                        }
                        catch (Throwable t) {
                            SystemConf.this.warn("Failed to terminate " + ifInfo.getId());
                            SystemConf.this.error(t);
                            ++this.failedTerminations;
                        }
                    }
                }
            }
            catch (Throwable t) {
                SystemConf.this.error(t);
            }
            finally {
                SystemConf.this.closeSvci();
            }
        }
    }
}

