/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.notifications;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calsvc.notifications.NotifyMessage;
import org.bedework.calsvc.notifications.SubscribeMessage;
import org.bedework.util.http.BasicHttpClient;
import org.bedework.util.misc.Logged;

public class NotificationClient
extends Logged {
    final NotificationProperties np;
    private static final ObjectMapper om = new ObjectMapper();
    private BasicHttpClient cl;

    public NotificationClient(NotificationProperties np) {
        this.np = np;
    }

    public void informNotifier(String principalHref, String resourceName) throws CalFacadeException {
        NotifyMessage nm = new NotifyMessage(this.np.getNotifierId(), this.np.getNotifierToken());
        nm.setHref(principalHref);
        nm.setResourceName(resourceName);
        this.sendRequest(nm, "notification/");
    }

    public void subscribe(String principalHref, List<String> emails, String userToken) throws CalFacadeException {
        SubscribeMessage sm = new SubscribeMessage(this.np.getNotifierId(), this.np.getNotifierToken(), userToken, principalHref, emails);
        this.sendRequest(sm, "subscribe/");
    }

    public void unsubscribe(String principalHref, List<String> emails) throws CalFacadeException {
        SubscribeMessage sm = new SubscribeMessage(this.np.getNotifierId(), this.np.getNotifierToken(), null, principalHref, emails);
        this.sendRequest(sm, "unsubscribe/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(Object req, String path) throws CalFacadeException {
        if (this.np.getNotifierURI() == null) {
            return;
        }
        NotificationClient notificationClient = this;
        synchronized (notificationClient) {
            try {
                BasicHttpClient cl = this.getClient();
                cl.setBaseURI(new URI(this.np.getNotifierURI()));
                StringWriter sw = new StringWriter();
                om.writeValue((Writer)sw, req);
                byte[] content = sw.toString().getBytes();
                int status = cl.sendRequest("POST", path, null, "application/json", content.length, content);
                if (status != 200) {
                    this.warn("Unable to post notification");
                }
            }
            catch (Throwable t) {
                if (this.debug) {
                    this.error(t);
                }
                this.error("Unable to contact notification engine " + t.getLocalizedMessage());
            }
            finally {
                try {
                    this.getClient().release();
                }
                catch (Throwable t) {
                    this.warn("Error on close " + t.getLocalizedMessage());
                }
            }
        }
    }

    private BasicHttpClient getClient() throws CalFacadeException {
        if (this.cl != null) {
            return this.cl;
        }
        try {
            this.cl = new BasicHttpClient(30000, false);
            return this.cl;
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
    }
}

