/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import java.util.Map;
import net.fortuna.ical4j.model.component.VVoter;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwEventProxy;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.base.BwDbentity;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OrganizerSchedulingHandler;
import org.bedework.icalendar.IcalUtil;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;

public abstract class AttendeeSchedulingHandler
extends OrganizerSchedulingHandler {
    AttendeeSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    public ScheduleResult requestRefresh(EventInfo ei, String comment) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        if (ev.getScheduleMethod() != 2) {
            sr.errorCode = "org.bedework.error.scheduling.badmethod";
            return sr;
        }
        BwAttendee att = this.findUserAttendee(ev);
        if (att == null) {
            throw new CalFacadeException("org.bedework.error.scheduling.notattendee");
        }
        BwEventObj outEv = new BwEventObj();
        EventInfo outEi = new EventInfo((BwEvent)outEv);
        outEv.setScheduleMethod(6);
        outEv.addRecipient(ev.getOrganizer().getOrganizerUri());
        outEv.setOriginator(att.getAttendeeUri());
        outEv.updateDtstamp();
        outEv.setOrganizer((BwOrganizer)ev.getOrganizer().clone());
        outEv.getOrganizer().setDtstamp(outEv.getDtstamp());
        outEv.addAttendee((BwAttendee)att.clone());
        outEv.setUid(ev.getUid());
        outEv.setRecurrenceId(ev.getRecurrenceId());
        outEv.setDtstart(ev.getDtstart());
        outEv.setDtend(ev.getDtend());
        outEv.setDuration(ev.getDuration());
        outEv.setNoStart(ev.getNoStart());
        outEv.setRecurring(Boolean.valueOf(false));
        if (comment != null) {
            outEv.addComment(new BwString(null, comment));
        }
        sr = this.scheduleResponse(outEi);
        outEv.setScheduleState(1);
        return sr;
    }

    public ScheduleResult attendeeRespond(EventInfo ei, int method) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        BwAttendee att = null;
        if (!ev.getSuppressed() && (att = this.findUserAttendee(ev)) == null) {
            sr.errorCode = "org.bedework.error.scheduling.notattendee";
        } else if (ei.getNumOverrides() > 0) {
            for (EventInfo oei : ei.getOverrides()) {
                att = this.findUserAttendee(oei.getEvent());
                if (att != null) continue;
                sr.errorCode = "org.bedework.error.scheduling.notattendee";
                break;
            }
        } else if (ev.getOriginator() == null) {
            sr.errorCode = "org.bedework.error.scheduling.noOriginator";
        } else {
            EventInfo outEi = this.copyEventInfo(ei, this.getPrincipal());
            BwEvent outEv = outEi.getEvent();
            if (!Util.isEmpty((Collection)outEv.getRecipients())) {
                outEv.getRecipients().clear();
            }
            if (!Util.isEmpty((Collection)outEv.getAttendees())) {
                outEv.getAttendees().clear();
            }
            outEv.addRecipient(outEv.getOrganizer().getOrganizerUri());
            outEv.setOriginator(att.getAttendeeUri());
            outEv.updateDtstamp();
            outEv.getOrganizer().setDtstamp(outEv.getDtstamp());
            String delegate = att.getDelegatedTo();
            if (delegate != null) {
                outEv.setScheduleMethod(3);
                BwAttendee delAtt = new BwAttendee();
                delAtt.setAttendeeUri(delegate);
                delAtt.setDelegatedFrom(att.getAttendeeUri());
                delAtt.setPartstat("NEEDS-ACTION");
                delAtt.setRsvp(true);
                delAtt.setRole(att.getRole());
                outEv.addAttendee(delAtt);
                EventInfo delegateEi = this.copyEventInfo(ei, this.getPrincipal());
                BwEvent delegateEv = delegateEi.getEvent();
                delegateEv.addRecipient(delegate);
                delegateEv.addAttendee((BwAttendee)delAtt.clone());
                delegateEv.setScheduleMethod(2);
                att.setPartstat("DELEGATED");
                att.setRsvp(false);
                att.setDelegatedTo(delegate);
                this.schedule(delegateEi, null, null, false);
            } else if (method == 3) {
                ei.setOnlyAttendee(outEi, att.getAttendeeUri());
                if (ev.getEntityType() == 7) {
                    this.setPollResponse(outEi, ei, att.getAttendeeUri());
                }
                outEv.setScheduleMethod(3);
            } else if (method == 7) {
                ei.setOnlyAttendee(outEi, att.getAttendeeUri());
                outEv.setScheduleMethod(7);
            } else {
                throw new RuntimeException("Never get here");
            }
            outEv.addRequestStatus(new BwRequestStatus(IcalDefs.requestStatusSuccess.getCode(), IcalDefs.requestStatusSuccess.getDescription()));
            sr = this.scheduleResponse(outEi);
            outEv.setScheduleState(1);
            ev.getOrganizer().setScheduleStatus("1.2");
        }
        return sr;
    }

    public ScheduleResult scheduleResponse(EventInfo ei) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        try {
            Object ev;
            int smethod = ei.getEvent().getScheduleMethod();
            if (!Icalendar.itipReplyMethodType((int)smethod)) {
                sr.errorCode = "org.bedework.error.scheduling.badmethod";
                return sr;
            }
            int outAccess = 12;
            if (!ei.getEvent().getSuppressed() && (ev = ei.getEvent()).getNumAttendees() != 1) {
                sr.errorCode = "org.bedework.error.scheduling.bad.attendees";
                return sr;
            }
            if (ei.getNumOverrides() > 0) {
                for (EventInfo oei : ei.getOverrides()) {
                    BwEvent ev2 = oei.getEvent();
                    if (ev2.getNumAttendees() == 1) continue;
                    sr.errorCode = "org.bedework.error.scheduling.bad.attendees";
                    return sr;
                }
            }
            if (!this.initScheduleEvent(ei, true, false)) {
                return sr;
            }
            BwCalendar outBox = this.getSpecialCalendar(this.getPrincipal(), 6, true, outAccess);
            this.sendSchedule(sr, ei, null, null, false);
            if (sr.ignored) {
                return sr;
            }
            if (!sr.externalRcs.isEmpty()) {
                sr.errorCode = this.addToOutBox(ei, outBox, sr.externalRcs);
            }
            return sr;
        }
        catch (Throwable t) {
            this.getSvc().rollbackTransaction();
            if (t instanceof CalFacadeException) {
                throw (CalFacadeException)t;
            }
            throw new CalFacadeException(t);
        }
    }

    protected EventInfo makeReplyEventInfo(EventInfo ei, String owner) throws CalFacadeException {
        BwEvent newEv = this.makeReplyEvent(ei.getEvent(), owner);
        EventInfo newEi = new EventInfo(newEv);
        return newEi;
    }

    protected BwEvent makeReplyEvent(BwEvent origEv, String ownerHref) throws CalFacadeException {
        BwEventObj newEv = new BwEventObj();
        if (origEv instanceof BwEventProxy) {
            this.getSvc().reAttach((BwDbentity)((BwEventProxy)origEv).getRef());
        } else {
            this.getSvc().reAttach((BwDbentity)origEv);
        }
        newEv.setUid(origEv.getUid());
        newEv.setOrganizer(origEv.getOrganizer());
        newEv.setRecurrenceId(origEv.getRecurrenceId());
        newEv.setSequence(origEv.getSequence());
        newEv.setOwnerHref(ownerHref);
        newEv.setCreatorHref(ownerHref);
        newEv.setDtstamps(this.getCurrentTimestamp());
        newEv.setDtstart(origEv.getDtstart());
        newEv.setDtend(origEv.getDtend());
        newEv.setEndType(origEv.getEndType());
        newEv.setDuration(origEv.getDuration());
        newEv.setNoStart(origEv.getNoStart());
        newEv.setRecurring(Boolean.valueOf(false));
        newEv.setSummary(origEv.getSummary());
        return newEv;
    }

    private void setPollResponse(EventInfo outEi, EventInfo ei, String attUri) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        BwEvent outEv = outEi.getEvent();
        try {
            Map voters = IcalUtil.parseVpollVvoters((BwEvent)ev);
            outEv.clearVvoters();
            VVoter vv = (VVoter)voters.get(attUri);
            if (vv == null) {
                this.warn("No Vvoter element for " + attUri);
                return;
            }
            outEv.addVvoter(vv.toString());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }
}

