/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import java.util.List;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwRecurrenceInstance;
import org.bedework.calfacade.BwRequestStatus;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.exc.CalFacadeBadRequest;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.AttendeeSchedulingHandler;
import org.bedework.calsvci.EventsI;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;

public abstract class ImplicitSchedulingHandler
extends AttendeeSchedulingHandler {
    ImplicitSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    @Override
    public void implicitSchedule(EventInfo ei, boolean noInvites) throws CalFacadeException {
        BwCalendar inbox;
        EventsI events;
        EventInfo inboxei;
        EventInfo.UpdateResult uer = ei.getUpdResult();
        if (this.debug) {
            this.dump(uer);
        }
        BwEvent ev = ei.getEvent();
        boolean organizerSchedulingObject = ev.getOrganizerSchedulingObject();
        boolean attendeeSchedulingObject = ev.getAttendeeSchedulingObject();
        if (ev.getSuppressed() && !Util.isEmpty((Collection)ei.getOverrides())) {
            for (EventInfo oei : ei.getOverrides()) {
                BwEvent oev;
                uer = oei.getUpdResult();
                if (this.debug) {
                    this.dump(uer);
                }
                if ((oev = oei.getEvent()).getOrganizerSchedulingObject().booleanValue()) {
                    organizerSchedulingObject = true;
                }
                if (!oev.getAttendeeSchedulingObject().booleanValue()) continue;
                attendeeSchedulingObject = true;
            }
        }
        if (!organizerSchedulingObject && !attendeeSchedulingObject) {
            if (this.debug) {
                this.trace("No a scheduling object: just return");
            }
            return;
        }
        if (ev.getOrganizer() == null) {
            throw new CalFacadeBadRequest("org.bedework.exception.missingeventproperty");
        }
        if (ev.getOriginator() == null) {
            ev.setOriginator(ev.getOrganizer().getOrganizerUri());
        }
        if (uer.reply) {
            int meth = ei.getReplyAttendeeURI() != null ? 6 : 3;
            ev.setScheduleMethod(meth);
            uer.schedulingResult = this.attendeeRespond(ei, meth);
            return;
        }
        if (uer.deleting) {
            if (organizerSchedulingObject) {
                ev.setScheduleMethod(5);
            } else {
                ev.setScheduleMethod(3);
            }
        } else {
            ev.setScheduleMethod(2);
        }
        if (!noInvites) {
            uer.schedulingResult = this.schedule(ei, ei.getReplyAttendeeURI(), uer.fromAttUri, false);
        }
        if (!uer.adding && !Util.isEmpty((Collection)uer.deletedAttendees)) {
            for (BwAttendee att : uer.deletedAttendees) {
                if (Util.compareStrings((String)att.getPartstat(), (String)IcalDefs.partstats[2]) == 0) continue;
                BwEvent cncl = (BwEvent)ev.clone();
                cncl.setAttendees(null);
                cncl.addAttendee((BwAttendee)att.clone());
                cncl.setRecipients(null);
                cncl.addRecipient(att.getAttendeeUri());
                cncl.setScheduleMethod(5);
                cncl.setOrganizerSchedulingObject(Boolean.valueOf(true));
                cncl.setAttendeeSchedulingObject(Boolean.valueOf(false));
                EventInfo cei = new EventInfo(cncl);
                ScheduleResult cnclr = this.schedule(cei, null, null, false);
                if (!this.debug) continue;
                this.trace(cnclr.toString());
            }
        }
        if (ei.getInboxEventName() != null && (inboxei = (events = this.getSvc().getEventsHandler()).get((inbox = this.getSvc().getCalendarsHandler().getSpecial(5, true)).getPath(), ei.getInboxEventName())) != null) {
            events.delete(inboxei, false);
        }
    }

    public ScheduleResult sendReply(EventInfo ei, int partstat, String comment) throws CalFacadeException {
        ScheduleResult sr = new ScheduleResult();
        BwEvent ev = ei.getEvent();
        if (!ev.getAttendeeSchedulingObject().booleanValue()) {
            sr.errorCode = "org.bedework.error.scheduling.badmethod";
            return sr;
        }
        BwAttendee att = this.findUserAttendee(ev);
        if (att == null) {
            sr.errorCode = "org.bedework.error.scheduling.notattendee";
            return sr;
        }
        att = (BwAttendee)att.clone();
        att.setPartstat(IcalDefs.partstats[partstat]);
        att.setRsvp(partstat == 0);
        BwEventObj outEv = new BwEventObj();
        EventInfo outEi = new EventInfo((BwEvent)outEv);
        outEv.setScheduleMethod(3);
        outEv.addRequestStatus(new BwRequestStatus(IcalDefs.requestStatusSuccess.getCode(), IcalDefs.requestStatusSuccess.getDescription()));
        outEv.addRecipient(ev.getOrganizer().getOrganizerUri());
        outEv.setOriginator(att.getAttendeeUri());
        outEv.updateDtstamp();
        outEv.setOrganizer((BwOrganizer)ev.getOrganizer().clone());
        outEv.getOrganizer().setDtstamp(outEv.getDtstamp());
        outEv.addAttendee(att);
        outEv.setUid(ev.getUid());
        outEv.setRecurrenceId(ev.getRecurrenceId());
        outEv.setDtstart(ev.getDtstart());
        outEv.setDtend(ev.getDtend());
        outEv.setDuration(ev.getDuration());
        outEv.setNoStart(ev.getNoStart());
        outEv.setSummary(ev.getSummary());
        outEv.setRecurring(Boolean.valueOf(false));
        if (comment != null) {
            outEv.addComment(new BwString(null, comment));
        }
        sr = this.scheduleResponse(outEi);
        outEv.setScheduleState(1);
        return sr;
    }

    private void dump(EventInfo.UpdateResult uer) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateResult {");
        sb.append("adding = ");
        sb.append(uer.adding);
        sb.append(", ");
        this.trace(sb.toString());
        if (!uer.adding) {
            this.dump(uer.updatedInstances, "updatedInstances");
            this.dump(uer.deletedInstances, "deletedInstances");
            this.dump(uer.addedInstances, "addedInstances");
            this.dump(uer.addedAttendees, "addedAttendees");
            this.dump(uer.deletedAttendees, "deletedAttendees");
        }
    }

    private void dump(List<BwRecurrenceInstance> val, String name) {
        this.trace(name);
        if (Util.isEmpty(val)) {
            return;
        }
        for (BwRecurrenceInstance ri : val) {
            this.trace("  " + ri.getRecurrenceId());
        }
    }

    private void dump(Collection<BwAttendee> val, String name) {
        this.trace(name);
        if (Util.isEmpty(val)) {
            return;
        }
        for (BwAttendee att : val) {
            this.trace("  " + att.getAttendeeUri());
        }
    }
}

