/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwXproperty;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.exc.CalFacadeAccessException;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.IScheduleHandler;
import org.bedework.calsvc.scheduling.hosts.BwHosts;
import org.bedework.calsvc.scheduling.hosts.HostInfo;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.misc.Uid;
import org.bedework.util.misc.Util;

public abstract class OutboundSchedulingHandler
extends IScheduleHandler {
    OutboundSchedulingHandler(CalSvc svci) {
        super(svci);
    }

    protected void sendSchedule(ScheduleResult sr, EventInfo ei, String recipient, String fromAttUri, boolean fromOrganizer) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        boolean freeBusyRequest = ev.getEntityType() == 4;
        ev.updateDtstamp();
        if (recipient != null) {
            this.getRecipientInbox(ei, recipient, fromAttUri, sr, freeBusyRequest);
        } else {
            if (ev.getRecipients() == null) {
                return;
            }
            for (String recip : ev.getRecipients()) {
                this.getRecipientInbox(ei, recip, fromAttUri, sr, freeBusyRequest);
            }
        }
        HashMap<String, ArrayList<IScheduleHandler.UserInbox>> hostMap = new HashMap<String, ArrayList<IScheduleHandler.UserInbox>>();
        for (ScheduleResult.ScheduleRecipientResult sres : sr.recipientResults.values()) {
            IScheduleHandler.UserInbox ui = (IScheduleHandler.UserInbox)sres;
            if (sr.ignored) {
                ui.setStatus(3);
                continue;
            }
            if (ui.getStatus() == -1) {
                if (ui.getHost() != null) {
                    ArrayList<IScheduleHandler.UserInbox> inboxes = (ArrayList<IScheduleHandler.UserInbox>)hostMap.get(ui.getHost().getHostname());
                    if (inboxes == null) {
                        inboxes = new ArrayList<IScheduleHandler.UserInbox>();
                        hostMap.put(ui.getHost().getHostname(), inboxes);
                    }
                    inboxes.add(ui);
                    continue;
                }
                String deliveryStatus = null;
                try {
                    if (freeBusyRequest) {
                        sres.freeBusy = this.getFreeBusy(null, ui.principal, ev.getDtstart(), ev.getDtend(), ev.getOrganizer(), ev.getUid(), null);
                        ui.setStatus(0);
                    } else if (!ui.principal.getPrincipalRef().equals(this.getPrincipal().getPrincipalRef())) {
                        if (this.addToInbox(ui.inboxPath, ui.principal, ei, fromOrganizer) == null) {
                            ui.setStatus(0);
                            deliveryStatus = "1.2";
                        } else {
                            ui.setStatus(4);
                            deliveryStatus = "5.2";
                        }
                    } else {
                        ui.setAttendeeScheduleStatus(null);
                        ui.setStatus(0);
                    }
                }
                catch (CalFacadeAccessException cae) {
                    ui.setStatus(1);
                    deliveryStatus = "3.8";
                }
                if (fromOrganizer && deliveryStatus != null) {
                    ui.setAttendeeScheduleStatus(deliveryStatus);
                }
            }
            if (!this.debug) continue;
            this.trace("added recipient " + ui.recipient + " status = " + ui.getStatus());
        }
        for (Collection inboxes : hostMap.values()) {
            this.sendExternalRequest(sr, ei, inboxes);
        }
    }

    private String addToInbox(String inboxPath, BwPrincipal attPrincipal, EventInfo senderEi, boolean fromOrganizer) throws CalFacadeException {
        String ecode;
        int smethod;
        EventInfo ei = this.copyEventInfo(senderEi, fromOrganizer, attPrincipal);
        BwEvent ev = ei.getEvent();
        if (senderEi.getReplyUpdate()) {
            ev.addXproperty(new BwXproperty("X-BEDEWORK-SCHED-REPLY-UPDATE", null, "true"));
        }
        if (!Util.isEmpty((Collection)ev.getRecipients())) {
            ev.getRecipients().clear();
        }
        ev.addRecipient(this.getSvc().getDirectories().principalToCaladdr(attPrincipal));
        String evDtstamp = ev.getDtstamp();
        ev.setScheduleState(0);
        ev.setColPath(inboxPath);
        if (ei.getNumContainedItems() > 0) {
            for (EventInfo cei : ei.getContainedItems()) {
                cei.getEvent().setColPath(inboxPath);
            }
        }
        if (Icalendar.itipRequestMethodType((int)(smethod = ev.getScheduleMethod()))) {
            Collection<EventInfo> inevs = this.getEventsByUid(inboxPath, ev.getUid());
            for (EventInfo inei : inevs) {
                BwEvent inev = inei.getEvent();
                int cres = evDtstamp.compareTo(inev.getDtstamp());
                if (cres <= 0) {
                    return null;
                }
                this.deleteEvent(inei, true, false);
            }
        }
        if ((ecode = this.addEvent(ei, "In-" + Uid.getUid() + "-" + evDtstamp, 13, true)) != null) {
            return ecode;
        }
        if (this.debug) {
            this.trace("Add event with name " + ev.getName() + " and summary " + ev.getSummary() + " to " + ev.getColPath());
        }
        this.addAutoScheduleMessage(true, attPrincipal.getPrincipalRef(), ev.getName());
        return null;
    }

    private void getRecipientInbox(EventInfo ei, String recip, String fromAttUri, ScheduleResult sr, boolean freeBusyRequest) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        BwAttendee att = ev.findAttendee(recip);
        if (att != null && fromAttUri != null && fromAttUri.equals(att.getAttendeeUri())) {
            return;
        }
        IScheduleHandler.UserInbox ui = this.getInbox(sr, recip, freeBusyRequest);
        if (att != null) {
            ui.addAttendee(att);
            if (Util.compareStrings((String)att.getPartstat(), (String)"DECLINED") == 0) {
                return;
            }
            att.setScheduleStatus("1.0");
        }
        if (ui.getStatus() == 2) {
            sr.externalRcs.add(recip);
        } else if (ui.getStatus() == 1) {
            sr.errorCode = "org.bedework.error.scheduling.attendeeaccessdisallowed";
            if (att != null) {
                att.setScheduleStatus("3.8");
            }
        } else if (ui.principal == null && ui.getHost() != null) {
            sr.externalRcs.add(recip);
        }
        if (ei.getNumOverrides() > 0) {
            for (EventInfo oei : ei.getOverrides()) {
                this.getRecipientInbox(oei, recip, fromAttUri, sr, freeBusyRequest);
            }
        }
    }

    private IScheduleHandler.UserInbox getInbox(ScheduleResult sr, String recipient, boolean freeBusyRequest) throws CalFacadeException {
        IScheduleHandler.UserInbox ui = (IScheduleHandler.UserInbox)((Object)sr.recipientResults.get(recipient));
        if (ui != null) {
            return ui;
        }
        ui = new IScheduleHandler.UserInbox(recipient);
        sr.addRecipientResult((ScheduleResult.ScheduleRecipientResult)ui);
        BwPrincipal principal = this.getSvc().getDirectories().caladdrToPrincipal(recipient);
        if (principal == null) {
            ui.setHost(BwHosts.getHostForRecipient(recipient));
            HostInfo hi = ui.getHost();
            if (hi == null) {
                ui.setStatus(2);
                return ui;
            }
            if (freeBusyRequest) {
                return ui;
            }
            if (!(hi.getSupportsISchedule() || hi.getSupportsCaldav() || hi.getSupportsBedework())) {
                ui.setStatus(2);
            }
            return ui;
        }
        try {
            if (principal.getPrincipalRef().equals(this.getPrincipal().getPrincipalRef())) {
                ui.principal = this.getPrincipal();
                ui.setStatus(-1);
                return ui;
            }
            ui.principal = principal;
            int priv = freeBusyRequest ? 13 : 11;
            BwCalendar inbox = this.getSpecialCalendar(ui.principal, 13, true, priv);
            if (inbox == null) {
                ui.setStatus(1);
            } else {
                ui.inboxPath = inbox.getPath();
            }
        }
        catch (CalFacadeAccessException cae) {
            ui.setStatus(1);
        }
        return ui;
    }
}

