/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.util.Collection;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.ImplicitSchedulingHandler;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.util.misc.Util;

public class Scheduling
extends ImplicitSchedulingHandler {
    public Scheduling(CalSvc svci) {
        super(svci);
    }

    public EventInfo getStoredMeeting(BwEvent ev) throws CalFacadeException {
        Collection evs;
        String preferred = this.getSvc().getCalendarsHandler().getPreferred(IcalDefs.entityTypeIcalNames[ev.getEntityType()]);
        if (preferred == null) {
            throw new CalFacadeException("org.bedework.error.scheduling.nocalendar");
        }
        if (this.debug) {
            this.debug("Look for event " + ev.getUid() + " in " + preferred);
        }
        if (Util.isEmpty((Collection)(evs = this.getSvc().getEventsHandler().getByUid(preferred, ev.getUid(), null, RecurringRetrievalMode.overrides)))) {
            return null;
        }
        for (EventInfo ei : evs) {
            BwEvent e = ei.getEvent();
            BwCalendar evcal = this.getSvc().getCalendarsHandler().get(e.getColPath());
            if (!evcal.getCollectionInfo().scheduling) continue;
            if (e.getOrganizerSchedulingObject().booleanValue() || e.getAttendeeSchedulingObject().booleanValue()) {
                return ei;
            }
            if (!e.getSuppressed()) continue;
            for (BwEvent oe : ei.getOverrideProxies()) {
                if (!oe.getOrganizerSchedulingObject().booleanValue() && !oe.getAttendeeSchedulingObject().booleanValue()) continue;
                return ei;
            }
        }
        return null;
    }
}

