/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling.hosts;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.security.PrivateKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.fortuna.ical4j.model.Calendar;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.exc.CalFacadeException;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.scheduling.hosts.HostInfo;
import org.bedework.calsvc.scheduling.hosts.IscheduleOut;
import org.bedework.calsvc.scheduling.hosts.Response;
import org.bedework.icalendar.IcalTranslator;
import org.bedework.icalendar.Icalendar;
import org.bedework.util.http.HttpUtil;
import org.bedework.util.misc.Logged;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.CaldavTags;
import org.bedework.util.xml.tagdefs.IscheduleTags;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IscheduleClient
extends Logged {
    private transient IcalTranslator trans;
    private static CloseableHttpClient cio;
    private PrivateKeys pkeys;
    private String domain;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IscheduleClient(IcalTranslator trans, PrivateKeys pkeys, String domain) {
        this.trans = trans;
        this.pkeys = pkeys;
        this.domain = domain;
        if (cio != null) {
            return;
        }
        IscheduleClient ischeduleClient = this;
        synchronized (ischeduleClient) {
            if (cio != null) {
                return;
            }
            HttpClientBuilder clb = HttpClients.custom();
            cio = clb.create().disableRedirectHandling().build();
        }
    }

    public Response getFreeBusy(HostInfo hi, EventInfo ei) throws CalFacadeException {
        this.discover(hi);
        IscheduleOut iout = this.makeFreeBusyRequest(hi, ei);
        Response resp = new Response();
        this.send(iout, hi, resp);
        if (resp.getResponseCode() != 200) {
            return resp;
        }
        return resp;
    }

    public Response scheduleMeeting(HostInfo hi, EventInfo ei) throws CalFacadeException {
        this.discover(hi);
        IscheduleOut iout = this.makeMeetingRequest(hi, ei);
        Response resp = new Response();
        this.send(iout, hi, resp);
        if (resp.getResponseCode() != 200) {
            return resp;
        }
        return resp;
    }

    private void discover(HostInfo hi) throws CalFacadeException {
        if (hi.getIScheduleUrl() != null) {
            return;
        }
        int rcode = 0;
        try {
            int port = hi.getPort() == 0 ? 80 : hi.getPort();
            String scheme = hi.getSecure() ? "https://" : "http://";
            URI uri = new URIBuilder().setScheme(scheme).setHost(hi.getHostname()).setPort(port).setPath(".well-known/ischedule").addParameter("action", "capabilities").build();
            HttpRequestBase req = HttpUtil.findMethod((String)"GET", (URI)uri);
            for (int redirects = 0; redirects < 10; ++redirects) {
                try (CloseableHttpResponse resp = cio.execute((HttpUriRequest)req);){
                    String location;
                    rcode = HttpUtil.getStatus((HttpResponse)resp);
                    if ((rcode == 301 || rcode == 302 || rcode == 307) && (location = HttpUtil.getFirstHeaderValue((HttpResponse)resp, (String)"location")) != null) {
                        int qpos;
                        if (this.debug) {
                            this.debug("Got redirected to " + location + " from " + uri);
                        }
                        String noreq = (qpos = location.indexOf("?")) < 0 ? location : location.substring(0, qpos);
                        uri = new URIBuilder(noreq).addParameter("action", "capabilities").build();
                        continue;
                    }
                }
                if (rcode != 200) {
                    if (this.debug) {
                        this.error("Got response " + rcode + ", host " + hi.getHostname() + " and url " + uri);
                    }
                    throw new CalFacadeException("Got response " + rcode + ", host " + hi.getHostname() + " and url " + uri);
                }
                hi.setIScheduleUrl(uri.toString());
                return;
            }
            if (this.debug) {
                this.error("Too many redirects: Got response " + rcode + ", host " + hi.getHostname() + " and url " + uri);
            }
            throw new CalFacadeException("Too many redirects on " + uri);
        }
        catch (CalFacadeException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            throw new CalFacadeException(t);
        }
    }

    private Document parseContent(Response resp) throws CalFacadeException {
        try {
            CloseableHttpResponse hresp = resp.getHttpResponse();
            HttpEntity entity = hresp.getEntity();
            long len = entity.getContentLength();
            if (len == 0L) {
                return null;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputStream in = entity.getContent();
            return builder.parse(new InputSource(new InputStreamReader(in)));
        }
        catch (SAXException e) {
            throw new CalFacadeException(e.getMessage());
        }
        catch (Throwable t) {
            throw new CalFacadeException(t);
        }
    }

    private void parseResponse(HostInfo hi, Response resp) throws CalFacadeException {
        try {
            QName descriptionTag;
            QName errorTag;
            QName calendarDataTag;
            QName requestStatusTag;
            QName recipientTag;
            QName responseTag;
            QName sresponseTag;
            Document doc = this.parseContent(resp);
            if (doc == null) {
                throw new CalFacadeException("org.bedework.exception.badresponse");
            }
            if (hi.getSupportsISchedule()) {
                sresponseTag = IscheduleTags.scheduleResponse;
                responseTag = IscheduleTags.response;
                recipientTag = IscheduleTags.recipient;
                requestStatusTag = IscheduleTags.requestStatus;
                calendarDataTag = IscheduleTags.calendarData;
                errorTag = IscheduleTags.error;
                descriptionTag = IscheduleTags.responseDescription;
            } else {
                sresponseTag = CaldavTags.scheduleResponse;
                responseTag = CaldavTags.response;
                recipientTag = CaldavTags.recipient;
                requestStatusTag = CaldavTags.requestStatus;
                calendarDataTag = CaldavTags.calendarData;
                errorTag = WebdavTags.error;
                descriptionTag = WebdavTags.responseDescription;
            }
            Element root = doc.getDocumentElement();
            if (!XmlUtil.nodeMatches((Node)root, (QName)sresponseTag)) {
                throw new CalFacadeException("org.bedework.exception.badresponse");
            }
            for (Element el : this.getChildren(root)) {
                Response.ResponseElement fbel = new Response.ResponseElement();
                if (!XmlUtil.nodeMatches((Node)el, (QName)responseTag)) {
                    throw new CalFacadeException("org.bedework.exception.badresponse");
                }
                Iterator<Element> respels = this.getChildren(el).iterator();
                Element respel = respels.next();
                if (!XmlUtil.nodeMatches((Node)respel, (QName)recipientTag)) {
                    throw new CalFacadeException("org.bedework.exception.badresponse");
                }
                fbel.setRecipient(this.getElementContent(respel));
                respel = respels.next();
                if (!XmlUtil.nodeMatches((Node)respel, (QName)requestStatusTag)) {
                    throw new CalFacadeException("org.bedework.exception.badresponse");
                }
                fbel.setReqStatus(this.getElementContent(respel));
                if (respels.hasNext()) {
                    respel = respels.next();
                    if (XmlUtil.nodeMatches((Node)respel, (QName)calendarDataTag)) {
                        String calData = this.getElementContent(respel);
                        StringReader rdr = new StringReader(calData);
                        Icalendar ical = this.trans.fromIcal(null, (Reader)rdr);
                        fbel.setCalData(ical.getEventInfo());
                    } else if (XmlUtil.nodeMatches((Node)respel, (QName)errorTag)) {
                        fbel.setDavError(respel.getFirstChild().getLocalName());
                    } else if (!XmlUtil.nodeMatches((Node)respel, (QName)descriptionTag)) {
                        throw new CalFacadeException("org.bedework.exception.badresponse");
                    }
                }
                resp.addResponse(fbel);
            }
        }
        catch (Throwable t) {
            if (this.debug) {
                this.error(t);
            }
            resp.setException(t);
        }
    }

    public void send(IscheduleOut iout, HostInfo hi, Response resp) throws CalFacadeException {
        try {
            for (int failures = 0; failures < 10; ++failures) {
                resp.setHostInfo(hi);
                URI uri = new URI(hi.getIScheduleUrl());
                HttpRequestBase req = HttpUtil.findMethod((String)iout.getMethod(), (URI)uri);
                if (req == null) {
                    throw new CalFacadeException("No method " + iout.getMethod());
                }
                if (!Util.isEmpty(iout.getHeaders())) {
                    for (Header hdr : iout.getHeaders()) {
                        req.addHeader(hdr);
                    }
                }
                HttpUtil.setContent((HttpRequestBase)req, (byte[])iout.getContentBytes(), (String)iout.getContentType());
                try (CloseableHttpResponse hresp = cio.execute((HttpUriRequest)req);){
                    int rcode = HttpUtil.getStatus((HttpResponse)hresp);
                    if (rcode == 200) {
                        resp.setHttpResponse(hresp);
                        this.parseResponse(hi, resp);
                        return;
                    }
                    this.error("Got response " + resp.getResponseCode() + ", host " + hi.getHostname() + " and url " + hi.getIScheduleUrl());
                    this.discover(hi);
                    continue;
                }
            }
        }
        catch (NoHttpResponseException nhre) {
            resp.setNoResponse(true);
        }
        catch (Throwable t) {
            resp.setException(t);
            throw new CalFacadeException(t);
        }
    }

    private IscheduleOut makeFreeBusyRequest(HostInfo hi, EventInfo ei) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        IscheduleOut iout = this.makeIout(hi, "text/calendar", "POST");
        this.addOriginator(iout, ev);
        this.addRecipients(iout, ev);
        Calendar cal = this.trans.toIcal(ei, ev.getScheduleMethod());
        StringWriter sw = new StringWriter();
        IcalTranslator.writeCalendar((Calendar)cal, (Writer)sw);
        iout.addContentLine(sw.toString());
        return iout;
    }

    private void addOriginator(IscheduleOut iout, BwEvent ev) throws CalFacadeException {
        if (ev.getOriginator() != null) {
            iout.addHeader("Originator", ev.getOriginator());
            return;
        }
        iout.addHeader("Originator", ev.getOrganizer().getOrganizerUri());
    }

    private void addRecipients(IscheduleOut iout, BwEvent ev) throws CalFacadeException {
        Set recipients = ev.getRecipients();
        for (String recip : recipients) {
            iout.addHeader("Recipient", recip);
        }
    }

    private IscheduleOut makeMeetingRequest(HostInfo hi, EventInfo ei) throws CalFacadeException {
        BwEvent ev = ei.getEvent();
        IscheduleOut iout = this.makeIout(hi, "text/calendar", "POST");
        this.addOriginator(iout, ev);
        this.addRecipients(iout, ev);
        Calendar cal = this.trans.toIcal(ei, ev.getScheduleMethod());
        StringWriter sw = new StringWriter();
        IcalTranslator.writeCalendar((Calendar)cal, (Writer)sw);
        iout.addContentLine(sw.toString());
        return iout;
    }

    private IscheduleOut makeIout(HostInfo hi, String contentType, String method) throws CalFacadeException {
        IscheduleOut iout = new IscheduleOut(this.domain);
        iout.setContentType(contentType);
        iout.setMethod(method);
        return iout;
    }

    protected Collection<Element> getChildren(Node nd) throws CalFacadeException {
        try {
            return XmlUtil.getElements((Node)nd);
        }
        catch (Throwable t) {
            if (this.debug) {
                this.getLogger().error((Object)this, t);
            }
            throw new CalFacadeException("org.bedework.exception.badresponse");
        }
    }

    protected String getElementContent(Element el) throws CalFacadeException {
        try {
            return XmlUtil.getElementContent((Element)el);
        }
        catch (Throwable t) {
            if (this.debug) {
                this.getLogger().error((Object)this, t);
            }
            throw new CalFacadeException("org.bedework.exception.badresponse");
        }
    }

    public static abstract class PrivateKeys {
        public abstract PrivateKey getKey(String var1, String var2) throws CalFacadeException;
    }
}

