/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.sysmon;

import java.util.ArrayList;
import java.util.List;
import org.bedework.calfacade.MonitorStat;
import org.bedework.calfacade.svc.BwSysMonitorMBean;
import org.bedework.calsvc.sysmon.DataCounts;
import org.bedework.calsvc.sysmon.DataValues;
import org.bedework.sysevents.NotificationException;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.listeners.JmsSysEventListener;
import org.bedework.util.jmx.ConfBase;

public class BwSysMonitor
extends ConfBase
implements BwSysMonitorMBean {
    private final DataCounts dataCounts = new DataCounts();
    private final DataValues dataValues = new DataValues();
    private ListenerThread processor;

    public String getServiceName() {
        return "org.bedework.bwengine:service=BwSysMonitor";
    }

    public boolean isRunning() {
        return this.processor != null && this.processor.isAlive();
    }

    public String loadConfig() {
        return "Ok";
    }

    public synchronized void start() {
        if (this.processor != null) {
            this.error("Already started");
            return;
        }
        this.setStatus("Stopped");
        this.info("************************************************************");
        this.info(" * Starting org.bedework.bwengine:service=BwSysMonitor");
        this.info("************************************************************");
        this.processor = new ListenerThread();
        this.processor.start();
    }

    public synchronized void stop() {
        if (this.processor == null) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping org.bedework.bwengine:service=BwSysMonitor");
        this.info("************************************************************");
        this.processor.interrupt();
        try {
            this.processor.join();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Throwable t) {
            this.error("Error waiting for processor termination");
            this.error(t);
        }
        this.setStatus("Stopped");
        this.processor = null;
        this.info("************************************************************");
        this.info(" * org.bedework.bwengine:service=BwSysMonitor terminated");
        this.info("************************************************************");
    }

    public List<String> showValues() {
        ArrayList<String> vals = new ArrayList<String>();
        this.dataCounts.getValues(vals);
        this.dataValues.getValues(vals);
        return vals;
    }

    public List<MonitorStat> getStats() {
        ArrayList<MonitorStat> stats = new ArrayList<MonitorStat>();
        this.dataCounts.getStats(stats);
        this.dataValues.getStats(stats);
        return stats;
    }

    private class ListenerThread
    extends Thread {
        private ListenerThread() {
        }

        @Override
        public void run() {
            try (BedeworkListener bwl = new BedeworkListener();){
                BwSysMonitor.this.setStatus("Running");
                bwl.process(false);
            }
            catch (NotificationException ne) {
                ne.printStackTrace();
            }
            BwSysMonitor.this.setStatus("Stopped");
        }
    }

    private class BedeworkListener
    extends JmsSysEventListener {
        BedeworkListener() throws NotificationException {
            this.open("monitor");
        }

        public void action(SysEvent ev) throws NotificationException {
            if (ev == null) {
                return;
            }
            BwSysMonitor.this.dataCounts.update(ev);
            BwSysMonitor.this.dataValues.update(ev);
        }
    }
}

