/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.sysmon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bedework.calfacade.MonitorStat;
import org.bedework.calsvc.sysmon.DataValue;
import org.bedework.sysevents.events.SysEvent;
import org.bedework.sysevents.events.SysEventBase;

public class DataCounts {
    private Collection<DataValue> dls = new ArrayList<DataValue>();
    private Map<SysEventBase.SysCode, DataValue> dlMap = new HashMap<SysEventBase.SysCode, DataValue>();

    public DataCounts() {
        this.addDl("web requests", SysEventBase.SysCode.WEB_IN);
        this.addDl("caldav requests", SysEventBase.SysCode.CALDAV_IN);
        this.addDl("entities fetched", SysEventBase.SysCode.ENTITY_FETCHED);
        this.addDl("entities added", SysEventBase.SysCode.ENTITY_ADDED);
        this.addDl("entities updated", SysEventBase.SysCode.ENTITY_UPDATED);
        this.addDl("entities tombstoned", SysEventBase.SysCode.ENTITY_TOMBSTONED);
        this.addDl("entities deleted", SysEventBase.SysCode.ENTITY_DELETED);
        this.addDl("logins", SysEventBase.SysCode.USER_LOGIN);
        this.addDl("svc logins", SysEventBase.SysCode.SERVICE_USER_LOGIN);
    }

    public void update(SysEvent ev) {
        SysEventBase.SysCode sc = ev.getSysCode();
        DataValue dl = this.dlMap.get(sc);
        if (dl != null) {
            dl.inc();
        }
    }

    public void getValues(List<String> vals) {
        for (DataValue dv : this.dls) {
            vals.add(dv.toString());
        }
    }

    public void getStats(List<MonitorStat> stats) {
        for (DataValue dv : this.dls) {
            stats.add(dv.getStat());
        }
    }

    private DataValue addDl(String name, SysEventBase.SysCode scode) {
        DataValue dl = new DataValue(name, scode);
        this.dls.add(dl);
        SysEventBase.SysCode s = dl.getSysCode();
        if (s != null) {
            this.dlMap.put(s, dl);
        }
        return dl;
    }
}

